/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.halbrowser;

import javax.servlet.http.HttpServletRequest;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponents;

@BasePathAwareController
public class HalBrowser {
    private static String BROWSER = "/browser";
    private static String INDEX = "/index.html";

    @RequestMapping(value={"/", ""}, method={RequestMethod.GET}, produces={"text/html"})
    public View index(HttpServletRequest request) {
        return this.getRedirectView(request, false);
    }

    @RequestMapping(value={"/browser"}, method={RequestMethod.GET})
    public View browser(HttpServletRequest request) {
        return this.getRedirectView(request, request.getRequestURI().endsWith("/browser"));
    }

    private View getRedirectView(HttpServletRequest request, boolean browserRelative) {
        String path;
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request);
        UriComponents components = builder.build();
        String string = path = components.getPath() == null ? "" : components.getPath();
        if (!browserRelative) {
            builder.path(BROWSER);
        }
        builder.path(INDEX);
        builder.fragment(browserRelative ? path.substring(0, path.lastIndexOf("/browser")) : path);
        return new RedirectView(builder.build().toUriString());
    }
}

