/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.List;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Cast;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TupleExpression;

public abstract class Expressions {
    private static final Expression ASTERISK = new SimpleExpression("*");

    public static Expression asterisk() {
        return ASTERISK;
    }

    public static Expression just(String sql) {
        return new SimpleExpression(sql);
    }

    public static Expression asterisk(Table table) {
        return table.asterisk();
    }

    public static Expression cast(Expression expression, String targetType) {
        return Cast.create(expression, targetType);
    }

    public static Expression of(List<Column> columns) {
        if (columns.size() == 1) {
            return columns.get(0);
        }
        return new TupleExpression(columns);
    }

    private Expressions() {
    }

    public static class SimpleExpression
    extends AbstractSegment
    implements Expression {
        private final String expression;

        SimpleExpression(String expression) {
            super(new Segment[0]);
            this.expression = expression;
        }

        @Override
        public String toString() {
            return this.expression;
        }
    }
}

