/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.DefaultRootAggregateChange;
import org.springframework.data.relational.core.conversion.DeleteAggregateChange;
import org.springframework.data.relational.core.conversion.RootAggregateChange;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public interface MutableAggregateChange<T>
extends AggregateChange<T> {
    public static <T> RootAggregateChange<T> forSave(T entity) {
        return MutableAggregateChange.forSave(entity, null);
    }

    public static <T> RootAggregateChange<T> forSave(T entity, @Nullable Number previousVersion) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return new DefaultRootAggregateChange(AggregateChange.Kind.SAVE, ClassUtils.getUserClass(entity), previousVersion);
    }

    public static <T> DeleteAggregateChange<T> forDelete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return MutableAggregateChange.forDelete(ClassUtils.getUserClass(entity));
    }

    public static <T> DeleteAggregateChange<T> forDelete(Class<T> entityClass) {
        return MutableAggregateChange.forDelete(entityClass, null);
    }

    public static <T> DeleteAggregateChange<T> forDelete(Class<T> entityClass, @Nullable Number previousVersion) {
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return new DeleteAggregateChange<T>(entityClass, previousVersion);
    }

    public void addAction(DbAction<?> var1);

    public @Nullable Number getPreviousVersion();
}

