/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.support;

import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.support.TableNameQueryPreprocessor;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.Assert;

public abstract class RelationalQueryLookupStrategy
implements QueryLookupStrategy {
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context;
    private final Dialect dialect;

    protected RelationalQueryLookupStrategy(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, Dialect dialect) {
        Assert.notNull(context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        this.context = context;
        this.dialect = dialect;
    }

    public MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> getMappingContext() {
        return this.context;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    protected String evaluateTableExpressions(RepositoryMetadata repositoryMetadata, String queryString) {
        TableNameQueryPreprocessor preprocessor = new TableNameQueryPreprocessor((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(repositoryMetadata.getDomainType()), this.dialect);
        return preprocessor.transform(queryString);
    }
}

