/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.function.Function;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;

public class SqlServerSelectRenderContext
implements SelectRenderContext {
    private static final String SYNTHETIC_ORDER_BY_FIELD = "__relational_row_number__";
    private static final String SYNTHETIC_SELECT_LIST = ", ROW_NUMBER() over (ORDER BY (SELECT 1)) AS __relational_row_number__";
    private final Function<Select, CharSequence> afterFromTable;
    private final Function<Select, CharSequence> afterOrderBy;

    protected SqlServerSelectRenderContext(Function<Select, CharSequence> afterFromTable, Function<Select, CharSequence> afterOrderBy) {
        this.afterFromTable = afterFromTable;
        this.afterOrderBy = afterOrderBy;
    }

    @Override
    public Function<Select, ? extends CharSequence> afterSelectList() {
        return select -> {
            if (SqlServerSelectRenderContext.usesPagination(select) && select.getOrderBy().isEmpty()) {
                return SYNTHETIC_SELECT_LIST;
            }
            return "";
        };
    }

    @Override
    public Function<Select, ? extends CharSequence> afterFromTable() {
        return this.afterFromTable;
    }

    @Override
    public Function<Select, ? extends CharSequence> afterOrderBy(boolean hasOrderBy) {
        if (hasOrderBy) {
            return this.afterOrderBy;
        }
        return select -> {
            StringBuilder builder = new StringBuilder();
            if (SqlServerSelectRenderContext.usesPagination(select)) {
                builder.append(" ORDER BY __relational_row_number__");
            }
            builder.append(this.afterOrderBy.apply((Select)select));
            return builder;
        };
    }

    private static boolean usesPagination(Select select) {
        return select.getOffset().isPresent() || select.getLimit().isPresent();
    }
}

