/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.lang.Nullable;

public class OptimisticLockingUtils {
    public static OptimisticLockingFailureException updateFailed(Object entity, @Nullable Object version, RelationalPersistentEntity<?> persistentEntity) {
        IdentifierAccessor identifierAccessor = persistentEntity.getIdentifierAccessor(entity);
        Object id = identifierAccessor.getRequiredIdentifier();
        return new OptimisticLockingFailureException(String.format("Failed to update versioned entity with id '%s' (version '%s') in table [%s]; Was the entity updated or deleted concurrently?", id, version, persistentEntity.getTableName()));
    }

    public static OptimisticLockingFailureException deleteFailed(Object entity, RelationalPersistentEntity<?> persistentEntity) {
        IdentifierAccessor identifierAccessor = persistentEntity.getIdentifierAccessor(entity);
        Object id = identifierAccessor.getRequiredIdentifier();
        PersistentProperty versionProperty = persistentEntity.getRequiredVersionProperty();
        Object version = persistentEntity.getPropertyAccessor(entity).getProperty(versionProperty);
        return OptimisticLockingUtils.deleteFailed(id, version, persistentEntity);
    }

    public static OptimisticLockingFailureException deleteFailed(@Nullable Object id, @Nullable Object version, RelationalPersistentEntity<?> persistentEntity) {
        return new OptimisticLockingFailureException(String.format("Failed to delete versioned entity with id '%s' (version '%s') in table [%s]; Was the entity updated or deleted concurrently?", id, version, persistentEntity.getTableName()));
    }
}

