/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Update {
    private static final Update EMPTY = new Update(Collections.emptyMap());
    private final Map<SqlIdentifier, Object> columnsToUpdate;

    private Update(Map<SqlIdentifier, Object> columnsToUpdate) {
        this.columnsToUpdate = columnsToUpdate;
    }

    public static Update from(Map<SqlIdentifier, Object> assignments) {
        return new Update(new LinkedHashMap<SqlIdentifier, Object>(assignments));
    }

    public static Update update(String column, @Nullable Object value) {
        return EMPTY.set(column, value);
    }

    @CheckReturnValue
    public Update set(String column, @Nullable Object value) {
        Assert.hasText((String)column, (String)"Column for update must not be null or blank");
        return this.addMultiFieldOperation(SqlIdentifier.unquoted(column), value);
    }

    @CheckReturnValue
    public Update set(SqlIdentifier column, @Nullable Object value) {
        return this.addMultiFieldOperation(column, value);
    }

    public Map<SqlIdentifier, Object> getAssignments() {
        return Collections.unmodifiableMap(this.columnsToUpdate);
    }

    private Update addMultiFieldOperation(SqlIdentifier key, @Nullable Object value) {
        Assert.notNull((Object)key, (String)"Column for update must not be null");
        LinkedHashMap<SqlIdentifier, Object> updates = new LinkedHashMap<SqlIdentifier, Object>(this.columnsToUpdate);
        updates.put(key, value);
        return new Update(updates);
    }

    public String toString() {
        if (this.getAssignments().isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ");
        this.getAssignments().forEach((column, o) -> joiner.add(String.format("%s = %s", column.toSql(IdentifierProcessing.NONE), o instanceof Number ? o : "'" + String.valueOf(o) + "'")));
        return "SET " + String.valueOf(joiner);
    }
}

