/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.relational.core.dialect.AnsiDialect;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.dialect.TimestampAtUtcToOffsetDateTimeConverter;
import org.springframework.data.relational.core.sql.SqlIdentifier;

public class OracleDialect
extends AnsiDialect {
    public static final OracleDialect INSTANCE = new OracleDialect();
    private static final IdGeneration ID_GENERATION = new IdGeneration(){

        @Override
        public boolean driverRequiresKeyColumnNames() {
            return true;
        }

        @Override
        public String getKeyColumnName(SqlIdentifier id) {
            return id.toSql(INSTANCE.getIdentifierProcessing());
        }
    };

    protected OracleDialect() {
    }

    @Override
    public IdGeneration getIdGeneration() {
        return ID_GENERATION;
    }

    @Override
    public Collection<Object> getConverters() {
        return Arrays.asList(new Object[]{TimestampAtUtcToOffsetDateTimeConverter.INSTANCE, NumberToBooleanConverter.INSTANCE, BooleanToIntegerConverter.INSTANCE});
    }

    @ReadingConverter
    static enum NumberToBooleanConverter implements Converter<Number, Boolean>
    {
        INSTANCE;


        public Boolean convert(Number number) {
            return number.intValue() != 0;
        }
    }

    @WritingConverter
    static enum BooleanToIntegerConverter implements Converter<Boolean, Integer>
    {
        INSTANCE;


        public Integer convert(Boolean bool) {
            return bool != false ? 1 : 0;
        }
    }
}

