/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.relational.core.sql.Assignment;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.data.relational.core.sql.Visitor;
import org.springframework.data.relational.core.sql.Where;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DefaultUpdate
implements Update {
    private final Table table;
    private final List<Assignment> assignments;
    @Nullable
    private final Where where;

    DefaultUpdate(Table table, List<Assignment> assignments, @Nullable Condition where) {
        this.table = table;
        this.assignments = new ArrayList<Assignment>(assignments);
        this.where = where != null ? new Where(where) : null;
    }

    @Override
    public void visit(Visitor visitor) {
        Assert.notNull((Object)visitor, (String)"Visitor must not be null");
        visitor.enter(this);
        this.table.visit(visitor);
        this.assignments.forEach(it -> it.visit(visitor));
        if (this.where != null) {
            this.where.visit(visitor);
        }
        visitor.leave(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ").append(this.table);
        if (!this.assignments.isEmpty()) {
            builder.append(" SET ").append(StringUtils.collectionToDelimitedString(this.assignments, (String)", "));
        }
        if (this.where != null) {
            builder.append(" ").append(this.where);
        }
        return builder.toString();
    }
}

