/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Join;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.ConditionVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.FromTableVisitor;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;

class JoinVisitor
extends TypedSubtreeVisitor<Join> {
    private final RenderTarget parent;
    private final StringBuilder joinClause = new StringBuilder();
    private final FromTableVisitor fromTableVisitor;
    private final ConditionVisitor conditionVisitor;
    private boolean inCondition = false;
    private boolean hasSeenCondition = false;

    JoinVisitor(RenderContext context, RenderTarget parent) {
        this.parent = parent;
        this.conditionVisitor = new ConditionVisitor(context);
        this.fromTableVisitor = new FromTableVisitor(context, this.joinClause::append);
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(Join segment) {
        this.joinClause.append(segment.getType().getSql()).append(' ');
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof TableLike && !this.inCondition) {
            return DelegatingVisitor.Delegation.delegateTo(this.fromTableVisitor);
        }
        if (segment instanceof Condition) {
            this.inCondition = true;
            if (!this.hasSeenCondition) {
                this.hasSeenCondition = true;
                return DelegatingVisitor.Delegation.delegateTo(this.conditionVisitor);
            }
        }
        return super.enterNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (segment instanceof Condition) {
            this.inCondition = false;
            if (this.hasSeenCondition) {
                this.joinClause.append(" ON ");
                this.joinClause.append(this.conditionVisitor.getRenderedPart());
                this.hasSeenCondition = false;
            }
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Join segment) {
        this.parent.onRendered(this.joinClause);
        return super.leaveMatched(segment);
    }
}

