/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.query;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.query.DefaultSortQuery;
import org.springframework.data.redis.core.query.SortCriterion;
import org.springframework.data.redis.core.query.SortQuery;

class DefaultSortCriterion<K>
implements SortCriterion<K> {
    private final K key;
    private @Nullable String by;
    private final List<String> getKeys = new ArrayList<String>(4);
    private  @Nullable SortParameters.Range limit;
    private  @Nullable SortParameters.Order order;
    private @Nullable Boolean alpha;

    DefaultSortCriterion(K key) {
        this.key = key;
    }

    @Override
    public SortCriterion<K> alphabetical(boolean alpha) {
        this.alpha = alpha;
        return this;
    }

    @Override
    public SortQuery<K> build() {
        return new DefaultSortQuery<K>(this.key, this.order, this.alpha, this.limit, this.by, this.getKeys);
    }

    @Override
    public SortCriterion<K> limit(long offset, long count) {
        this.limit = new SortParameters.Range(offset, count);
        return this;
    }

    @Override
    public SortCriterion<K> limit(SortParameters.Range range) {
        this.limit = range;
        return this;
    }

    @Override
    public SortCriterion<K> order(SortParameters.Order order) {
        this.order = order;
        return this;
    }

    @Override
    public SortCriterion<K> get(String getPattern) {
        this.getKeys.add(getPattern);
        return this;
    }

    SortCriterion<K> addBy(String keyPattern) {
        this.by = keyPattern;
        return this;
    }
}

