/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.RedisClusterCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

@NullUnmarked
class DefaultClusterOperations<K, V>
extends AbstractOperations<K, V>
implements ClusterOperations<K, V> {
    private final RedisTemplate<K, V> template;

    DefaultClusterOperations(@NonNull RedisTemplate<K, V> template) {
        super(template);
        this.template = template;
    }

    @Override
    public Set<K> keys(@NonNull RedisClusterNode node, @NonNull K pattern) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        return this.doInCluster(connection -> this.deserializeKeys(connection.keys(node, this.rawKey(pattern))));
    }

    @Override
    public K randomKey(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        return (K)this.doInCluster(connection -> this.deserializeKey(connection.randomKey(node)));
    }

    @Override
    public String ping(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        return this.doInCluster(connection -> connection.ping(node));
    }

    @Override
    public void addSlots(@NonNull RedisClusterNode node, int ... slots) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.doInCluster(connection -> {
            connection.clusterAddSlots(node, slots);
            return null;
        });
    }

    @Override
    public void addSlots(@NonNull RedisClusterNode node, @NonNull RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        Assert.notNull((Object)range, (String)"Range must not be null");
        this.addSlots(node, range.getSlotsArray());
    }

    @Override
    public void bgReWriteAof(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.doInCluster(connection -> {
            connection.bgReWriteAof(node);
            return null;
        });
    }

    @Override
    public void bgSave(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.doInCluster(connection -> {
            connection.bgSave(node);
            return null;
        });
    }

    @Override
    public void meet(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.doInCluster(connection -> {
            connection.clusterMeet(node);
            return null;
        });
    }

    @Override
    public void forget(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.doInCluster(connection -> {
            connection.clusterForget(node);
            return null;
        });
    }

    @Override
    public void flushDb(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.doInCluster(connection -> {
            connection.flushDb(node);
            return null;
        });
    }

    @Override
    public void flushDb(@NonNull RedisClusterNode node,  @NonNull RedisServerCommands.FlushOption option) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.doInCluster(connection -> {
            connection.flushDb(node, option);
            return null;
        });
    }

    @Override
    public Collection<RedisClusterNode> getReplicas(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        return this.doInCluster(connection -> connection.clusterGetReplicas(node));
    }

    @Override
    public void save(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.doInCluster(connection -> {
            connection.save(node);
            return null;
        });
    }

    @Override
    public void shutdown(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.doInCluster(connection -> {
            connection.shutdown(node);
            return null;
        });
    }

    @Override
    public void reshard(@NonNull RedisClusterNode source, int slot, @NonNull RedisClusterNode target) {
        Assert.notNull((Object)source, (String)"Source node must not be null");
        Assert.notNull((Object)target, (String)"Target node must not be null");
        this.doInCluster(connection -> {
            connection.clusterSetSlot(target, slot, RedisClusterCommands.AddSlots.IMPORTING);
            connection.clusterSetSlot(source, slot, RedisClusterCommands.AddSlots.MIGRATING);
            List<byte[]> keys = connection.clusterGetKeysInSlot(slot, Integer.MAX_VALUE);
            for (byte[] key : keys) {
                connection.migrate(key, source, 0, RedisServerCommands.MigrateOption.COPY);
            }
            connection.clusterSetSlot(target, slot, RedisClusterCommands.AddSlots.NODE);
            return null;
        });
    }

    <T> T doInCluster(@NonNull RedisClusterCallback<T> callback) {
        Assert.notNull(callback, (String)"ClusterCallback must not be null");
        try (RedisClusterConnection connection = this.template.getConnectionFactory().getClusterConnection();){
            T t = callback.doInRedis(connection);
            return t;
        }
    }
}

