/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.util.Assert;

public class StringRedisSerializer
implements RedisSerializer<String> {
    private final Charset charset;
    public static final StringRedisSerializer US_ASCII = new StringRedisSerializer(StandardCharsets.US_ASCII);
    public static final StringRedisSerializer ISO_8859_1 = new StringRedisSerializer(StandardCharsets.ISO_8859_1);
    public static final StringRedisSerializer UTF_8 = new StringRedisSerializer(StandardCharsets.UTF_8);

    public StringRedisSerializer() {
        this(StandardCharsets.UTF_8);
    }

    public StringRedisSerializer(Charset charset) {
        Assert.notNull((Object)charset, (String)"Charset must not be null");
        this.charset = charset;
    }

    @Override
    public byte[] serialize(@Nullable String value) {
        return value == null ? SerializationUtils.EMPTY_ARRAY : value.getBytes(this.charset);
    }

    @Override
    public @Nullable String deserialize(byte @Nullable [] bytes) {
        return bytes == null ? null : new String(bytes, this.charset);
    }

    @Override
    public Class<?> getTargetType() {
        return String.class;
    }
}

