/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.api.async.RedisSetAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;

@NullUnmarked
class LettuceSetCommands
implements RedisSetCommands {
    private final LettuceConnection connection;

    LettuceSetCommands(@NonNull LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long sAdd(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        return (Long)this.connection.invoke().just(RedisSetAsyncCommands::sadd, key, values);
    }

    @Override
    public Long sCard(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisSetAsyncCommands::scard, key);
    }

    @Override
    public Set<byte @NonNull []> sDiff(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return (Set)this.connection.invoke().just(RedisSetAsyncCommands::sdiff, keys);
    }

    @Override
    public Long sDiffStore(byte @NonNull [] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)keys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements");
        return (Long)this.connection.invoke().just(RedisSetAsyncCommands::sdiffstore, destKey, keys);
    }

    @Override
    public Set<byte @NonNull []> sInter(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return (Set)this.connection.invoke().just(RedisSetAsyncCommands::sinter, keys);
    }

    @Override
    public Long sInterStore(byte @NonNull [] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)keys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements");
        return (Long)this.connection.invoke().just(RedisSetAsyncCommands::sinterstore, destKey, keys);
    }

    @Override
    public Long sInterCard(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return (Long)this.connection.invoke().just(RedisSetAsyncCommands::sintercard, keys);
    }

    @Override
    public Boolean sIsMember(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Boolean)this.connection.invoke().just(RedisSetAsyncCommands::sismember, key, value);
    }

    @Override
    public List<@NonNull Boolean> sMIsMember(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        return (List)this.connection.invoke().just(RedisSetAsyncCommands::smismember, key, values);
    }

    @Override
    public Set<byte @NonNull []> sMembers(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Set)this.connection.invoke().just(RedisSetAsyncCommands::smembers, key);
    }

    @Override
    public Boolean sMove(byte @NonNull [] srcKey, byte @NonNull [] destKey, byte @NonNull [] value) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Boolean)this.connection.invoke().just(RedisSetAsyncCommands::smove, srcKey, destKey, value);
    }

    @Override
    public byte[] sPop(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisSetAsyncCommands::spop, key);
    }

    @Override
    public List<byte @NonNull []> sPop(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().from(RedisSetAsyncCommands::spop, key, count).get(ArrayList::new);
    }

    @Override
    public byte[] sRandMember(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisSetAsyncCommands::srandmember, key);
    }

    @Override
    public List<byte @NonNull []> sRandMember(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().just(RedisSetAsyncCommands::srandmember, key, count);
    }

    @Override
    public Long sRem(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        return (Long)this.connection.invoke().just(RedisSetAsyncCommands::srem, key, values);
    }

    @Override
    public Set<byte @NonNull []> sUnion(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return (Set)this.connection.invoke().just(RedisSetAsyncCommands::sunion, keys);
    }

    @Override
    public Long sUnionStore(byte @NonNull [] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)keys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements");
        return (Long)this.connection.invoke().just(RedisSetAsyncCommands::sunionstore, destKey, keys);
    }

    @Override
    public Cursor<byte[]> sScan(byte @NonNull [] key, @Nullable ScanOptions options) {
        return this.sScan(key, Cursor.CursorId.initial(), options != null ? options : ScanOptions.NONE);
    }

    public Cursor<byte[]> sScan(byte @NonNull [] key, @NonNull Cursor.CursorId cursorId, @NonNull ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new KeyBoundCursor<byte[]>(key, cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(byte @NonNull [] key, Cursor.CursorId cursorId, ScanOptions options) {
                if (LettuceSetCommands.this.connection.isQueueing() || LettuceSetCommands.this.connection.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'SSCAN' cannot be called in pipeline / transaction mode");
                }
                ScanCursor scanCursor = LettuceSetCommands.this.connection.getScanCursor(cursorId);
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                ValueScanCursor valueScanCursor = (ValueScanCursor)LettuceSetCommands.this.connection.invoke().just(RedisSetAsyncCommands::sscan, key, scanCursor, scanArgs);
                String nextCursorId = valueScanCursor.getCursor();
                List values = (List)LettuceSetCommands.this.connection.failsafeReadScanValues(valueScanCursor.getValues(), null);
                return new ScanIteration<byte[]>(Cursor.CursorId.of(nextCursorId), values);
            }

            @Override
            protected void doClose() {
                LettuceSetCommands.this.connection.close();
            }
        }.open();
    }

    public RedisClusterCommands<byte[], byte[]> getCommands() {
        return this.connection.getConnection();
    }
}

