/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisScriptReturnConverter;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.ScriptingKeyPipelineBinaryCommands;

@NullUnmarked
class JedisScriptingCommands
implements RedisScriptingCommands {
    private static final byte[] SAMPLE_KEY = new byte[0];
    private final JedisConnection connection;

    JedisScriptingCommands(@NonNull JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public void scriptFlush() {
        this.connection.invoke().just(Jedis::scriptFlush, it -> it.scriptFlush(SAMPLE_KEY));
    }

    @Override
    public void scriptKill() {
        this.connection.invoke().just(Jedis::scriptKill, it -> it.scriptKill(SAMPLE_KEY));
    }

    @Override
    public String scriptLoad(byte @NonNull [] script) {
        Assert.notNull((Object)script, (String)"Script must not be null");
        return (String)this.connection.invoke().from(it -> it.scriptLoad(script), it -> it.scriptLoad(script, SAMPLE_KEY)).get(JedisConverters::toString);
    }

    @Override
    public List<@NonNull Boolean> scriptExists(String ... scriptSha1) {
        Assert.notNull((Object)scriptSha1, (String)"Script digests must not be null");
        Assert.noNullElements((Object[])scriptSha1, (String)"Script digests must not contain null elements");
        byte[][] sha1 = new byte[scriptSha1.length][];
        for (int i = 0; i < scriptSha1.length; ++i) {
            sha1[i] = JedisConverters.toBytes(scriptSha1[i]);
        }
        return this.connection.invoke().just(it -> it.scriptExists(scriptSha1), it -> it.scriptExists(SAMPLE_KEY, sha1));
    }

    @Override
    public <T> T eval(byte @NonNull [] script, @NonNull ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)script, (String)"Script must not be null");
        JedisScriptReturnConverter converter = new JedisScriptReturnConverter(returnType);
        return (T)this.connection.invoke().from(Jedis::eval, ScriptingKeyPipelineBinaryCommands::eval, script, numKeys, keysAndArgs).getOrElse(converter, () -> converter.convert(null));
    }

    @Override
    public <T> T evalSha(@NonNull String scriptSha1, @NonNull ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return this.evalSha(JedisConverters.toBytes(scriptSha1), returnType, numKeys, keysAndArgs);
    }

    @Override
    public <T> T evalSha(byte @NonNull [] scriptSha, @NonNull ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)scriptSha, (String)"Script digest must not be null");
        JedisScriptReturnConverter converter = new JedisScriptReturnConverter(returnType);
        return (T)this.connection.invoke().from(Jedis::evalsha, ScriptingKeyPipelineBinaryCommands::evalsha, scriptSha, numKeys, keysAndArgs).getOrElse(converter, () -> converter.convert(null));
    }
}

