/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.connection.stream.StringRecord;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.util.CollectionUtils;

@NullUnmarked
public interface StringRedisConnection
extends RedisConnection {
    public Object execute(@NonNull String var1, String ... var2);

    public Object execute(@NonNull String var1);

    public Boolean exists(@NonNull String var1);

    public Long exists(String ... var1);

    public Long del(String ... var1);

    public Boolean copy(@NonNull String var1, @NonNull String var2, boolean var3);

    public Long unlink(String ... var1);

    public DataType type(@NonNull String var1);

    public Long touch(String ... var1);

    public Collection<String> keys(@NonNull String var1);

    public void rename(@NonNull String var1, @NonNull String var2);

    public Boolean renameNX(@NonNull String var1, @NonNull String var2);

    default public Boolean expire(@NonNull String key, long seconds) {
        return this.expire(key, seconds, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean expire(@NonNull String var1, long var2, @NonNull ExpirationOptions.Condition var4);

    default public Boolean pExpire(@NonNull String key, long millis) {
        return this.pExpire(key, millis, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean pExpire(@NonNull String var1, long var2, @NonNull ExpirationOptions.Condition var4);

    default public Boolean expireAt(@NonNull String key, long unixTime) {
        return this.expireAt(key, unixTime, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean expireAt(@NonNull String var1, long var2, @NonNull ExpirationOptions.Condition var4);

    default public Boolean pExpireAt(@NonNull String key, long unixTimeInMillis) {
        return this.pExpireAt(key, unixTimeInMillis, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean pExpireAt(@NonNull String var1, long var2, @NonNull ExpirationOptions.Condition var4);

    public Boolean persist(@NonNull String var1);

    public Boolean move(@NonNull String var1, int var2);

    public Long ttl(@NonNull String var1);

    public Long ttl(@NonNull String var1, @NonNull TimeUnit var2);

    public Long pTtl(@NonNull String var1);

    public Long pTtl(@NonNull String var1, @NonNull TimeUnit var2);

    public String echo(@NonNull String var1);

    public List<String> sort(@NonNull String var1, @NonNull SortParameters var2);

    public Long sort(@NonNull String var1, @NonNull SortParameters var2, @NonNull String var3);

    public ValueEncoding encodingOf(@NonNull String var1);

    public Duration idletime(@NonNull String var1);

    public Long refcount(@NonNull String var1);

    public String get(@NonNull String var1);

    public String getDel(@NonNull String var1);

    public String getEx(@NonNull String var1, @NonNull Expiration var2);

    public String getSet(@NonNull String var1, String var2);

    public List<String> mGet(String ... var1);

    public Boolean set(@NonNull String var1, @NonNull String var2);

    public Boolean set(@NonNull String var1, @NonNull String var2, @Nullable Expiration var3,  @Nullable RedisStringCommands.SetOption var4);

    public Boolean setNX(@NonNull String var1, @NonNull String var2);

    public Boolean setEx(@NonNull String var1, long var2, @NonNull String var4);

    public Boolean pSetEx(@NonNull String var1, long var2, @NonNull String var4);

    public Boolean mSetString(@NonNull Map<@NonNull String, String> var1);

    public Boolean mSetNXString(@NonNull Map<@NonNull String, String> var1);

    public Long incr(@NonNull String var1);

    public Long incrBy(@NonNull String var1, long var2);

    public Double incrBy(@NonNull String var1, double var2);

    public Long decr(@NonNull String var1);

    public Long decrBy(@NonNull String var1, long var2);

    public Long append(@NonNull String var1, String var2);

    public String getRange(@NonNull String var1, long var2, long var4);

    public void setRange(@NonNull String var1, String var2, long var3);

    public Boolean getBit(@NonNull String var1, long var2);

    public Boolean setBit(@NonNull String var1, long var2, boolean var4);

    public Long bitCount(@NonNull String var1);

    public Long bitCount(@NonNull String var1, long var2, long var4);

    public Long bitOp( @NonNull RedisStringCommands.BitOperation var1, @NonNull String var2, String ... var3);

    default public Long bitPos(@NonNull String key, boolean bit) {
        return this.bitPos(key, bit, (Range<Long>)Range.unbounded());
    }

    public Long bitPos(@NonNull String var1, boolean var2, @NonNull Range<Long> var3);

    public Long strLen(@NonNull String var1);

    public Long rPush(@NonNull String var1, String ... var2);

    default public Long lPos(@NonNull String key, @NonNull String element) {
        return (Long)CollectionUtils.firstElement(this.lPos(key, element, null, null));
    }

    public List<Long> lPos(@NonNull String var1, @NonNull String var2, @Nullable Integer var3, @Nullable Integer var4);

    public Long lPush(@NonNull String var1, String ... var2);

    public Long rPushX(@NonNull String var1, @NonNull String var2);

    public Long lPushX(@NonNull String var1, @NonNull String var2);

    public Long lLen(@NonNull String var1);

    public List<String> lRange(@NonNull String var1, long var2, long var4);

    public void lTrim(@NonNull String var1, long var2, long var4);

    public String lIndex(@NonNull String var1, long var2);

    public Long lInsert(@NonNull String var1,  @NonNull RedisListCommands.Position var2, @NonNull String var3, String var4);

    public String lMove(@NonNull String var1, @NonNull String var2,  @NonNull RedisListCommands.Direction var3,  @NonNull RedisListCommands.Direction var4);

    public String bLMove(@NonNull String var1, @NonNull String var2,  @NonNull RedisListCommands.Direction var3,  @NonNull RedisListCommands.Direction var4, double var5);

    public void lSet(@NonNull String var1, long var2, String var4);

    public Long lRem(@NonNull String var1, long var2, String var4);

    public String lPop(@NonNull String var1);

    public List<String> lPop(@NonNull String var1, long var2);

    public String rPop(@NonNull String var1);

    public List<String> rPop(@NonNull String var1, long var2);

    public List<String> bLPop(int var1, String ... var2);

    public List<String> bRPop(int var1, String ... var2);

    public String rPopLPush(@NonNull String var1, @NonNull String var2);

    public String bRPopLPush(int var1, @NonNull String var2, @NonNull String var3);

    public Long sAdd(@NonNull String var1, String ... var2);

    public Long sRem(@NonNull String var1, String ... var2);

    public String sPop(@NonNull String var1);

    public List<String> sPop(@NonNull String var1, long var2);

    public Boolean sMove(@NonNull String var1, @NonNull String var2, String var3);

    public Long sCard(@NonNull String var1);

    public Boolean sIsMember(@NonNull String var1, String var2);

    public List<Boolean> sMIsMember(@NonNull String var1, String ... var2);

    public Set<String> sInter(String ... var1);

    public Long sInterStore(@NonNull String var1, String ... var2);

    public Set<String> sUnion(String ... var1);

    public Long sUnionStore(String var1, String ... var2);

    public Set<String> sDiff(String ... var1);

    public Long sDiffStore(String var1, String ... var2);

    public Set<String> sMembers(@NonNull String var1);

    public String sRandMember(@NonNull String var1);

    public List<String> sRandMember(@NonNull String var1, long var2);

    public Cursor<String> sScan(@NonNull String var1, ScanOptions var2);

    public Boolean zAdd(@NonNull String var1, double var2, String var4);

    public Boolean zAdd(@NonNull String var1, double var2, String var4, RedisZSetCommands.ZAddArgs var5);

    public Long zAdd(@NonNull String var1, Set<StringTuple> var2);

    public Long zAdd(@NonNull String var1, Set<StringTuple> var2, RedisZSetCommands.ZAddArgs var3);

    public Long zRem(@NonNull String var1, String ... var2);

    public Double zIncrBy(@NonNull String var1, double var2, String var4);

    public String zRandMember(@NonNull String var1);

    public List<String> zRandMember(@NonNull String var1, long var2);

    public StringTuple zRandMemberWithScore(@NonNull String var1);

    public List<StringTuple> zRandMemberWithScores(@NonNull String var1, long var2);

    public Long zRank(@NonNull String var1, String var2);

    public Long zRevRank(@NonNull String var1, String var2);

    public Set<String> zRange(@NonNull String var1, long var2, long var4);

    public Set<StringTuple> zRangeWithScores(@NonNull String var1, long var2, long var4);

    public Set<String> zRangeByScore(@NonNull String var1, double var2, double var4);

    public Set<StringTuple> zRangeByScoreWithScores(@NonNull String var1, double var2, double var4);

    public Set<String> zRangeByScore(@NonNull String var1, double var2, double var4, long var6, long var8);

    public Set<StringTuple> zRangeByScoreWithScores(@NonNull String var1, double var2, double var4, long var6, long var8);

    public Set<String> zRevRange(@NonNull String var1, long var2, long var4);

    public Set<StringTuple> zRevRangeWithScores(@NonNull String var1, long var2, long var4);

    public Set<String> zRevRangeByScore(@NonNull String var1, double var2, double var4);

    public Set<StringTuple> zRevRangeByScoreWithScores(@NonNull String var1, double var2, double var4);

    public Set<String> zRevRangeByScore(@NonNull String var1, double var2, double var4, long var6, long var8);

    public Set<StringTuple> zRevRangeByScoreWithScores(@NonNull String var1, double var2, double var4, long var6, long var8);

    public Long zCount(@NonNull String var1, double var2, double var4);

    public Long zLexCount(@NonNull String var1, @NonNull Range<String> var2);

    public Tuple zPopMin(@NonNull String var1);

    public Set<StringTuple> zPopMin(@NonNull String var1, long var2);

    public StringTuple bZPopMin(@NonNull String var1, long var2, @NonNull TimeUnit var4);

    public StringTuple zPopMax(@NonNull String var1);

    public Set<StringTuple> zPopMax(@NonNull String var1, long var2);

    public StringTuple bZPopMax(@NonNull String var1, long var2, @NonNull TimeUnit var4);

    public Long zCard(@NonNull String var1);

    public Double zScore(@NonNull String var1, String var2);

    public List<Double> zMScore(@NonNull String var1, String ... var2);

    public Long zRemRange(@NonNull String var1, long var2, long var4);

    public Long zRemRangeByLex(@NonNull String var1, @NonNull Range<String> var2);

    public Long zRemRangeByScore(@NonNull String var1, double var2, double var4);

    public Set<String> zDiff(String ... var1);

    public Set<StringTuple> zDiffWithScores(String ... var1);

    public Long zDiffStore(@NonNull String var1, String ... var2);

    public Set<String> zInter(String ... var1);

    public Set<StringTuple> zInterWithScores(String ... var1);

    default public Set<StringTuple> zInterWithScores(@NonNull Aggregate aggregate, int @NonNull [] weights, String ... sets) {
        return this.zInterWithScores(aggregate, Weights.of(weights), sets);
    }

    public Set<StringTuple> zInterWithScores(@NonNull Aggregate var1, @NonNull Weights var2, String ... var3);

    public Long zInterStore(@NonNull String var1, String ... var2);

    public Long zInterStore(@NonNull String var1, @NonNull Aggregate var2, int @NonNull [] var3, String ... var4);

    public Set<String> zUnion(String ... var1);

    public Set<StringTuple> zUnionWithScores(String ... var1);

    default public Set<StringTuple> zUnionWithScores(@NonNull Aggregate aggregate, int @NonNull [] weights, String ... sets) {
        return this.zUnionWithScores(aggregate, Weights.of(weights), sets);
    }

    public Set<StringTuple> zUnionWithScores(@NonNull Aggregate var1, @NonNull Weights var2, String ... var3);

    public Long zUnionStore(@NonNull String var1, String ... var2);

    public Long zUnionStore(@NonNull String var1, @NonNull Aggregate var2, int @NonNull [] var3, String ... var4);

    public Cursor<StringTuple> zScan(@NonNull String var1, ScanOptions var2);

    public Set<String> zRangeByScore(@NonNull String var1, @NonNull String var2, @NonNull String var3);

    public Set<String> zRangeByScore(@NonNull String var1, @NonNull String var2, @NonNull String var3, long var4, long var6);

    public Set<String> zRangeByLex(@NonNull String var1);

    public Set<String> zRangeByLex(@NonNull String var1, @NonNull Range<String> var2);

    public Set<String> zRangeByLex(@NonNull String var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public Set<String> zRevRangeByLex(@NonNull String key) {
        return this.zRevRangeByLex(key, (Range<String>)Range.unbounded());
    }

    default public Set<String> zRevRangeByLex(@NonNull String key, @NonNull Range<String> range) {
        return this.zRevRangeByLex(key, range, Limit.unlimited());
    }

    public Set<String> zRevRangeByLex(@NonNull String var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public Long zRangeStoreByLex(@NonNull String dstKey, @NonNull String srcKey, @NonNull Range<String> range) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, Limit.unlimited());
    }

    public Long zRangeStoreByLex(@NonNull String var1, @NonNull String var2, @NonNull Range<String> var3, @NonNull Limit var4);

    default public Long zRangeStoreRevByLex(@NonNull String dstKey, @NonNull String srcKey, @NonNull Range<String> range) {
        return this.zRangeStoreRevByLex(dstKey, srcKey, range, Limit.unlimited());
    }

    public Long zRangeStoreRevByLex(@NonNull String var1, @NonNull String var2, @NonNull Range<String> var3, @NonNull Limit var4);

    default public Long zRangeStoreByScore(@NonNull String dstKey, @NonNull String srcKey, @NonNull Range<? extends Number> range) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, Limit.unlimited());
    }

    public Long zRangeStoreByScore(@NonNull String var1, @NonNull String var2, @NonNull Range<? extends Number> var3, @NonNull Limit var4);

    default public Long zRangeStoreRevByScore(@NonNull String dstKey, @NonNull String srcKey, @NonNull Range<? extends Number> range) {
        return this.zRangeStoreRevByScore(dstKey, srcKey, range, Limit.unlimited());
    }

    public Long zRangeStoreRevByScore(@NonNull String var1, @NonNull String var2, @NonNull Range<? extends Number> var3, @NonNull Limit var4);

    public Boolean hSet(@NonNull String var1, @NonNull String var2, String var3);

    public Boolean hSetNX(@NonNull String var1, @NonNull String var2, String var3);

    public String hGet(@NonNull String var1, @NonNull String var2);

    public List<String> hMGet(@NonNull String var1, String ... var2);

    public void hMSet(@NonNull String var1, @NonNull Map<@NonNull String, String> var2);

    public Long hIncrBy(@NonNull String var1, @NonNull String var2, long var3);

    public Double hIncrBy(@NonNull String var1, @NonNull String var2, double var3);

    public String hRandField(@NonNull String var1);

    public @Nullable Map.Entry<String, String> hRandFieldWithValues(@NonNull String var1);

    public List<String> hRandField(@NonNull String var1, long var2);

    public List<Map.Entry<String, String>> hRandFieldWithValues(@NonNull String var1, long var2);

    public Boolean hExists(@NonNull String var1, @NonNull String var2);

    public Long hDel(@NonNull String var1, String ... var2);

    public Long hLen(@NonNull String var1);

    public Set<String> hKeys(@NonNull String var1);

    public List<String> hVals(@NonNull String var1);

    public Map<String, String> hGetAll(@NonNull String var1);

    public Cursor<Map.Entry<String, String>> hScan(@NonNull String var1, ScanOptions var2);

    public Long hStrLen(@NonNull String var1, @NonNull String var2);

    default public List<Long> hExpire(@NonNull String key, long seconds, String ... fields) {
        return this.hExpire(key, seconds, ExpirationOptions.Condition.ALWAYS, fields);
    }

    public List<Long> hExpire(@NonNull String var1, long var2, @NonNull ExpirationOptions.Condition var4, String ... var5);

    default public List<Long> hpExpire(@NonNull String key, long millis, String ... fields) {
        return this.hpExpire(key, millis, ExpirationOptions.Condition.ALWAYS, fields);
    }

    public List<Long> hpExpire(@NonNull String var1, long var2, @NonNull ExpirationOptions.Condition var4, String ... var5);

    default public List<Long> hExpireAt(@NonNull String key, long unixTime, String ... fields) {
        return this.hExpireAt(key, unixTime, ExpirationOptions.Condition.ALWAYS, fields);
    }

    public List<Long> hExpireAt(@NonNull String var1, long var2, @NonNull ExpirationOptions.Condition var4, String ... var5);

    default public List<Long> hpExpireAt(@NonNull String key, long unixTimeInMillis, String ... fields) {
        return this.hpExpireAt(key, unixTimeInMillis, ExpirationOptions.Condition.ALWAYS, fields);
    }

    public List<Long> hpExpireAt(@NonNull String var1, long var2, @NonNull ExpirationOptions.Condition var4, String ... var5);

    public List<Long> hPersist(@NonNull String var1, String ... var2);

    public List<Long> hTtl(@NonNull String var1, String ... var2);

    public List<Long> hTtl(@NonNull String var1, @NonNull TimeUnit var2, String ... var3);

    public List<Long> hpTtl(@NonNull String var1, String ... var2);

    public Long pfAdd(@NonNull String var1, String ... var2);

    public Long pfCount(String ... var1);

    public void pfMerge(@NonNull String var1, String ... var2);

    public Long geoAdd(@NonNull String var1, @NonNull Point var2, @NonNull String var3);

    public Long geoAdd(@NonNull String var1,  @NonNull RedisGeoCommands.GeoLocation<String> var2);

    public Long geoAdd(@NonNull String var1, @NonNull Map<@NonNull String, @NonNull Point> var2);

    public Long geoAdd(@NonNull String var1, @NonNull Iterable< @NonNull RedisGeoCommands.GeoLocation<String>> var2);

    public Distance geoDist(@NonNull String var1, @NonNull String var2, @NonNull String var3);

    public Distance geoDist(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull Metric var4);

    public List<String> geoHash(@NonNull String var1, String ... var2);

    public List<Point> geoPos(@NonNull String var1, String ... var2);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(@NonNull String var1, @NonNull Circle var2);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(@NonNull String var1, @NonNull Circle var2,  @NonNull RedisGeoCommands.GeoRadiusCommandArgs var3);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadiusByMember(@NonNull String var1, @NonNull String var2, double var3);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadiusByMember(@NonNull String var1, @NonNull String var2, @NonNull Distance var3);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadiusByMember(@NonNull String var1, @NonNull String var2, @NonNull Distance var3,  @NonNull RedisGeoCommands.GeoRadiusCommandArgs var4);

    public Long geoRemove(@NonNull String var1, String ... var2);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoSearch(@NonNull String var1, @NonNull GeoReference<String> var2, @NonNull GeoShape var3,  @NonNull RedisGeoCommands.GeoSearchCommandArgs var4);

    public Long geoSearchStore(String var1, @NonNull String var2, @NonNull GeoReference<String> var3, @NonNull GeoShape var4,  @NonNull RedisGeoCommands.GeoSearchStoreCommandArgs var5);

    public Long publish(@NonNull String var1, @NonNull String var2);

    public void subscribe(@NonNull MessageListener var1, String ... var2);

    public void pSubscribe(@NonNull MessageListener var1, String ... var2);

    public String scriptLoad(@NonNull String var1);

    public <T> T eval(@NonNull String var1, @NonNull ReturnType var2, int var3, String ... var4);

    public <T> T evalSha(@NonNull String var1, @NonNull ReturnType var2, int var3, String ... var4);

    public void setClientName(@NonNull String var1);

    @Override
    public List<RedisClientInfo> getClientList();

    public List<Long> bitfield(@NonNull String var1, @NonNull BitFieldSubCommands var2);

    public static RecordId[] entryIds(String ... entryIds) {
        if (entryIds.length == 1) {
            return new RecordId[]{RecordId.of(entryIds[0])};
        }
        return (RecordId[])Arrays.stream(entryIds).map(RecordId::of).toArray(RecordId[]::new);
    }

    default public Long xAck(@NonNull String key, @NonNull String group, String ... entryIds) {
        return this.xAck(key, group, StringRedisConnection.entryIds(entryIds));
    }

    public Long xAck(@NonNull String var1, @NonNull String var2, RecordId ... var3);

    default public RecordId xAdd(@NonNull String key, @NonNull Map<@NonNull String, String> body) {
        return this.xAdd(StreamRecords.newRecord().in(key).ofStrings(body));
    }

    default public RecordId xAdd(@NonNull StringRecord record) {
        return this.xAdd(record, RedisStreamCommands.XAddOptions.none());
    }

    public RecordId xAdd(@NonNull StringRecord var1, @NonNull RedisStreamCommands.XAddOptions var2);

    public List<RecordId> xClaimJustId(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull RedisStreamCommands.XClaimOptions var4);

    default public List<StringRecord> xClaim(@NonNull String key, @NonNull String group, @NonNull String newOwner, @NonNull Duration minIdleTime, RecordId ... recordIds) {
        return this.xClaim(key, group, newOwner, RedisStreamCommands.XClaimOptions.minIdle(minIdleTime).ids(recordIds));
    }

    public List<StringRecord> xClaim(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull RedisStreamCommands.XClaimOptions var4);

    default public Long xDel(@NonNull String key, String ... entryIds) {
        return this.xDel(key, StringRedisConnection.entryIds(entryIds));
    }

    public Long xDel(@NonNull String var1, RecordId ... var2);

    public String xGroupCreate(@NonNull String var1, @NonNull ReadOffset var2, @NonNull String var3);

    public String xGroupCreate(@NonNull String var1, @NonNull ReadOffset var2, @NonNull String var3, boolean var4);

    public Boolean xGroupDelConsumer(@NonNull String var1, @NonNull Consumer var2);

    public Boolean xGroupDestroy(@NonNull String var1, String var2);

    public StreamInfo.XInfoStream xInfo(@NonNull String var1);

    public StreamInfo.XInfoGroups xInfoGroups(@NonNull String var1);

    public StreamInfo.XInfoConsumers xInfoConsumers(@NonNull String var1, @NonNull String var2);

    public Long xLen(@NonNull String var1);

    public PendingMessagesSummary xPending(@NonNull String var1, @NonNull String var2);

    public PendingMessages xPending(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull Range<String> var4, @NonNull Long var5);

    public PendingMessages xPending(@NonNull String var1, @NonNull String var2, @NonNull Range<String> var3, @NonNull Long var4);

    public PendingMessages xPending(@NonNull String var1, @NonNull String var2, @NonNull RedisStreamCommands.XPendingOptions var3);

    default public List<StringRecord> xRange(@NonNull String key, @NonNull Range<String> range) {
        return this.xRange(key, range, Limit.unlimited());
    }

    public List<StringRecord> xRange(@NonNull String var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public List<StringRecord> xReadAsString(@NonNull StreamOffset<String> stream) {
        return this.xReadAsString(StreamReadOptions.empty(), new StreamOffset[]{stream});
    }

    default public List<StringRecord> xReadAsString(StreamOffset<String> ... streams) {
        return this.xReadAsString(StreamReadOptions.empty(), streams);
    }

    default public List<StringRecord> xReadAsString(@NonNull StreamReadOptions readOptions, @NonNull StreamOffset<String> stream) {
        return this.xReadAsString(readOptions, new StreamOffset[]{stream});
    }

    public List<StringRecord> xReadAsString(@NonNull StreamReadOptions var1, StreamOffset<String> ... var2);

    default public List<StringRecord> xReadGroupAsString(@NonNull Consumer consumer, @NonNull StreamOffset<String> stream) {
        return this.xReadGroupAsString(consumer, StreamReadOptions.empty(), new StreamOffset[]{stream});
    }

    default public List<StringRecord> xReadGroupAsString(@NonNull Consumer consumer, StreamOffset<String> ... streams) {
        return this.xReadGroupAsString(consumer, StreamReadOptions.empty(), streams);
    }

    default public List<StringRecord> xReadGroupAsString(@NonNull Consumer consumer, @NonNull StreamReadOptions readOptions, @NonNull StreamOffset<String> stream) {
        return this.xReadGroupAsString(consumer, readOptions, new StreamOffset[]{stream});
    }

    public List<StringRecord> xReadGroupAsString(@NonNull Consumer var1, @NonNull StreamReadOptions var2, StreamOffset<String> ... var3);

    default public List<StringRecord> xRevRange(@NonNull String key, @NonNull Range<String> range) {
        return this.xRevRange(key, range, RedisZSetCommands.Limit.unlimited());
    }

    public List<StringRecord> xRevRange(@NonNull String var1, @NonNull Range<String> var2, @NonNull Limit var3);

    public Long xTrim(@NonNull String var1, long var2);

    public Long xTrim(@NonNull String var1, long var2, boolean var4);

    public static interface StringTuple
    extends Tuple {
        public String getValueAsString();
    }
}

