/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.util.CollectionUtils;

class DefaultListOperations<K, V>
extends AbstractOperations<K, V>
implements ListOperations<K, V> {
    DefaultListOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public V index(K key, final long index) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(this, key){
            final /* synthetic */ DefaultListOperations this$0;
            {
                this.this$0 = this$0;
                super(this$0, key);
            }

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.lIndex(rawKey, index);
            }
        });
    }

    @Override
    public Long indexOf(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.lPos(rawKey, rawValue));
    }

    @Override
    public Long lastIndexOf(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> {
            List<Long> indexes = connection.lPos(rawKey, rawValue, -1, null);
            return (Long)CollectionUtils.firstElement(indexes);
        });
    }

    @Override
    public V leftPop(K key) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.lPop(rawKey);
            }
        });
    }

    @Override
    public List<V> leftPop(K key, long count) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> this.deserializeValues(connection.lPop(rawKey, count)));
    }

    @Override
    public V leftPop(K key, long timeout, TimeUnit unit) {
        final int tm = (int)TimeoutUtils.toSeconds(timeout, unit);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(this, key){
            final /* synthetic */ DefaultListOperations this$0;
            {
                this.this$0 = this$0;
                super(this$0, key);
            }

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                List<byte[]> lPop = connection.bLPop(tm, new byte[][]{rawKey});
                return CollectionUtils.isEmpty(lPop) ? null : lPop.get(1);
            }
        });
    }

    @Override
    public Long leftPush(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.lPush(rawKey, new byte[][]{rawValue}));
    }

    @Override
    public Long leftPushAll(K key, V ... values) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(values);
        return this.execute(connection -> connection.lPush(rawKey, rawValues));
    }

    @Override
    public Long leftPushAll(K key, Collection<V> values) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(values);
        return this.execute(connection -> connection.lPush(rawKey, rawValues));
    }

    @Override
    public Long leftPushIfPresent(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.lPushX(rawKey, rawValue));
    }

    @Override
    public Long leftPush(K key, V pivot, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawPivot = this.rawValue(pivot);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.lInsert(rawKey, RedisListCommands.Position.BEFORE, rawPivot, rawValue));
    }

    @Override
    public Long size(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.lLen(rawKey));
    }

    @Override
    public List<V> range(K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> this.deserializeValues(connection.lRange(rawKey, start, end)));
    }

    @Override
    public Long remove(K key, long count, Object value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.lRem(rawKey, count, rawValue));
    }

    @Override
    public V rightPop(K key) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.rPop(rawKey);
            }
        });
    }

    @Override
    public List<V> rightPop(K key, long count) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> this.deserializeValues(connection.rPop(rawKey, count)));
    }

    @Override
    public V rightPop(K key, long timeout, TimeUnit unit) {
        final int tm = (int)TimeoutUtils.toSeconds(timeout, unit);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(this, key){
            final /* synthetic */ DefaultListOperations this$0;
            {
                this.this$0 = this$0;
                super(this$0, key);
            }

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                List<byte[]> bRPop = connection.bRPop(tm, new byte[][]{rawKey});
                return CollectionUtils.isEmpty(bRPop) ? null : bRPop.get(1);
            }
        });
    }

    @Override
    public Long rightPush(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.rPush(rawKey, new byte[][]{rawValue}));
    }

    @Override
    public Long rightPushAll(K key, V ... values) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(values);
        return this.execute(connection -> connection.rPush(rawKey, rawValues));
    }

    @Override
    public Long rightPushAll(K key, Collection<V> values) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(values);
        return this.execute(connection -> connection.rPush(rawKey, rawValues));
    }

    @Override
    public Long rightPushIfPresent(K key, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.rPushX(rawKey, rawValue));
    }

    @Override
    public Long rightPush(K key, V pivot, V value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawPivot = this.rawValue(pivot);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.lInsert(rawKey, RedisListCommands.Position.AFTER, rawPivot, rawValue));
    }

    @Override
    public V rightPopAndLeftPush(K sourceKey, K destinationKey) {
        final byte[] rawDestKey = this.rawKey(destinationKey);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(this, sourceKey){
            final /* synthetic */ DefaultListOperations this$0;
            {
                this.this$0 = this$0;
                super(this$0, key);
            }

            @Override
            protected byte[] inRedis(byte[] rawSourceKey, RedisConnection connection) {
                return connection.rPopLPush(rawSourceKey, rawDestKey);
            }
        });
    }

    @Override
    public V rightPopAndLeftPush(K sourceKey, K destinationKey, long timeout, TimeUnit unit) {
        final int tm = (int)TimeoutUtils.toSeconds(timeout, unit);
        final byte[] rawDestKey = this.rawKey(destinationKey);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(this, sourceKey){
            final /* synthetic */ DefaultListOperations this$0;
            {
                this.this$0 = this$0;
                super(this$0, key);
            }

            @Override
            protected byte[] inRedis(byte[] rawSourceKey, RedisConnection connection) {
                return connection.bRPopLPush(tm, rawSourceKey, rawDestKey);
            }
        });
    }

    @Override
    public V move(K sourceKey, final RedisListCommands.Direction from, K destinationKey, final RedisListCommands.Direction to) {
        final byte[] rawDestKey = this.rawKey(destinationKey);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(this, sourceKey){
            final /* synthetic */ DefaultListOperations this$0;
            {
                this.this$0 = this$0;
                super(this$0, key);
            }

            @Override
            protected byte[] inRedis(byte[] rawSourceKey, RedisConnection connection) {
                return connection.lMove(rawSourceKey, rawDestKey, from, to);
            }
        });
    }

    @Override
    public V move(K sourceKey, final RedisListCommands.Direction from, K destinationKey, final RedisListCommands.Direction to, final long timeout, final TimeUnit unit) {
        final byte[] rawDestKey = this.rawKey(destinationKey);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(this, sourceKey){
            final /* synthetic */ DefaultListOperations this$0;
            {
                this.this$0 = this$0;
                super(this$0, key);
            }

            @Override
            protected byte[] inRedis(byte[] rawSourceKey, RedisConnection connection) {
                return connection.bLMove(rawSourceKey, rawDestKey, from, to, TimeoutUtils.toDoubleSeconds(timeout, unit));
            }
        });
    }

    @Override
    public void set(K key, final long index, V value) {
        final byte[] rawValue = this.rawValue(value);
        this.execute(new AbstractOperations.ValueDeserializingRedisCallback(this, key){
            final /* synthetic */ DefaultListOperations this$0;
            {
                this.this$0 = this$0;
                super(this$0, key);
            }

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                connection.lSet(rawKey, index, rawValue);
                return null;
            }
        });
    }

    @Override
    public void trim(K key, final long start, final long end) {
        this.execute(new AbstractOperations.ValueDeserializingRedisCallback(this, key){
            final /* synthetic */ DefaultListOperations this$0;
            {
                this.this$0 = this$0;
                super(this$0, key);
            }

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                connection.lTrim(rawKey, start, end);
                return null;
            }
        });
    }
}

