/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.IndexWriter;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisKeyExpiredEvent;
import org.springframework.data.redis.core.RedisKeyspaceEvent;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisQueryEngine;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.GeoIndexedPropertyValue;
import org.springframework.data.redis.core.convert.MappingRedisConverter;
import org.springframework.data.redis.core.convert.PathIndexResolver;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisCustomConversions;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class RedisKeyValueAdapter
extends AbstractKeyValueAdapter
implements InitializingBean,
SmartLifecycle,
ApplicationContextAware,
ApplicationListener<RedisKeyspaceEvent> {
    private static final int PHANTOM_KEY_TTL = 300;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final AtomicReference<State> state = new AtomicReference<State>(State.CREATED);
    private RedisOperations<?, ?> redisOps;
    private RedisConverter converter;
    @Nullable
    private RedisMessageListenerContainer messageListenerContainer;
    private boolean managedListenerContainer = true;
    private final AtomicReference<KeyExpirationEventMessageListener> expirationListener = new AtomicReference<Object>(null);
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    private EnableKeyspaceEvents enableKeyspaceEvents = EnableKeyspaceEvents.OFF;
    @Nullable
    private String keyspaceNotificationsConfigParameter = null;
    private ShadowCopy shadowCopy = ShadowCopy.DEFAULT;

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps) {
        this(redisOps, new RedisMappingContext());
    }

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisMappingContext mappingContext) {
        this(redisOps, mappingContext, new RedisCustomConversions());
    }

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisMappingContext mappingContext, @Nullable CustomConversions customConversions) {
        super((QueryEngine)new RedisQueryEngine());
        Assert.notNull(redisOps, (String)"RedisOperations must not be null");
        Assert.notNull((Object)((Object)mappingContext), (String)"RedisMappingContext must not be null");
        MappingRedisConverter mappingConverter = new MappingRedisConverter(mappingContext, new PathIndexResolver(mappingContext), new ReferenceResolverImpl(redisOps));
        mappingConverter.setCustomConversions(customConversions == null ? new RedisCustomConversions() : customConversions);
        mappingConverter.afterPropertiesSet();
        this.converter = mappingConverter;
        this.redisOps = redisOps;
        this.initMessageListenerContainer();
    }

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisConverter redisConverter) {
        super((QueryEngine)new RedisQueryEngine());
        Assert.notNull(redisOps, (String)"RedisOperations must not be null");
        this.converter = redisConverter;
        this.redisOps = redisOps;
    }

    protected RedisKeyValueAdapter() {
    }

    public Object put(Object id, Object item, String keyspace) {
        RedisData rdo;
        RedisData redisData = rdo = item instanceof RedisData ? (RedisData)item : new RedisData();
        if (!(item instanceof RedisData)) {
            this.converter.write(item, rdo);
        }
        if (ObjectUtils.nullSafeEquals((Object)((Object)EnableKeyspaceEvents.ON_DEMAND), (Object)((Object)this.enableKeyspaceEvents)) && this.expirationListener.get() == null && rdo.getTimeToLive() != null && rdo.getTimeToLive() > 0L) {
            this.initKeyExpirationListener(this.messageListenerContainer);
        }
        if (rdo.getId() == null) {
            rdo.setId((String)this.converter.getConversionService().convert(id, String.class));
        }
        this.redisOps.execute(connection -> {
            byte[] key = this.toBytes(rdo.getId());
            byte[] objectKey = this.createKey(rdo.getKeyspace(), rdo.getId());
            boolean isNew = connection.del(new byte[][]{objectKey}) == 0L;
            connection.hMSet(objectKey, rdo.getBucket().rawMap());
            if (isNew) {
                connection.sAdd(this.toBytes(rdo.getKeyspace()), new byte[][]{key});
            }
            if (this.expires(rdo)) {
                connection.expire(objectKey, rdo.getTimeToLive());
            }
            if (this.keepShadowCopy()) {
                byte[] phantomKey = ByteUtils.concat(objectKey, MappingRedisConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX);
                if (this.expires(rdo)) {
                    connection.del(new byte[][]{phantomKey});
                    connection.hMSet(phantomKey, rdo.getBucket().rawMap());
                    connection.expire(phantomKey, rdo.getTimeToLive() + 300L);
                } else if (!isNew) {
                    connection.del(new byte[][]{phantomKey});
                }
            }
            IndexWriter indexWriter = new IndexWriter(connection, this.converter);
            if (isNew) {
                indexWriter.createIndexes(key, rdo.getIndexedData());
            } else {
                indexWriter.deleteAndUpdateIndexes(key, rdo.getIndexedData());
            }
            return null;
        });
        return item;
    }

    public boolean contains(Object id, String keyspace) {
        RedisCallback<Boolean> command = connection -> connection.sIsMember(this.toBytes(keyspace), this.toBytes(id));
        return Boolean.TRUE.equals(this.redisOps.execute(command));
    }

    @Nullable
    public Object get(Object id, String keyspace) {
        return this.get(id, keyspace, Object.class);
    }

    @Nullable
    public <T> T get(Object id, String keyspace, Class<T> type) {
        String stringId = this.toString(id);
        byte[] binId = this.createKey(keyspace, stringId);
        RedisCallback<Map> command = connection -> connection.hGetAll(binId);
        Map raw = this.redisOps.execute(command);
        if (CollectionUtils.isEmpty((Map)raw)) {
            return null;
        }
        RedisData data = new RedisData(raw);
        data.setId(stringId);
        data.setKeyspace(keyspace);
        return (T)this.readBackTimeToLiveIfSet(binId, this.converter.read(type, data));
    }

    public Object delete(Object id, String keyspace) {
        return this.delete(id, keyspace, Object.class);
    }

    public <T> T delete(Object id, String keyspace, Class<T> type) {
        byte[] binId = this.toBytes(id);
        byte[] binKeyspace = this.toBytes(keyspace);
        T value = this.get(id, keyspace, type);
        if (value != null) {
            byte[] keyToDelete = this.createKey(keyspace, this.toString(id));
            this.redisOps.execute(connection -> {
                RedisPersistentEntity persistentEntity;
                connection.del(new byte[][]{keyToDelete});
                connection.sRem(binKeyspace, new byte[][]{binId});
                new IndexWriter(connection, this.converter).removeKeyFromIndexes(keyspace, binId);
                if (this.keepShadowCopy() && (persistentEntity = (RedisPersistentEntity)this.converter.getMappingContext().getPersistentEntity(type)) != null && persistentEntity.isExpiring()) {
                    byte[] phantomKey = ByteUtils.concat(keyToDelete, MappingRedisConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX);
                    connection.del(new byte[][]{phantomKey});
                }
                return null;
            });
        }
        return value;
    }

    public List<Object> getAllOf(String keyspace) {
        return this.getAllOf(keyspace, Object.class, -1L, -1);
    }

    public <T> List<T> getAllOf(String keyspace, Class<T> type) {
        return this.getAllOf(keyspace, type, -1L, -1);
    }

    public <T> List<T> getAllOf(String keyspace, Class<T> type, long offset, int rows) {
        byte[] binKeyspace = this.toBytes(keyspace);
        Set ids = this.redisOps.execute(connection -> connection.sMembers(binKeyspace));
        ArrayList<T> result = new ArrayList<T>();
        List keys = new ArrayList(ids);
        if (keys.isEmpty() || (long)keys.size() < offset) {
            return Collections.emptyList();
        }
        offset = Math.max(0L, offset);
        if (rows > 0) {
            keys = keys.subList((int)offset, Math.min((int)offset + rows, keys.size()));
        }
        for (byte[] key : keys) {
            result.add(this.get(key, keyspace, type));
        }
        return result;
    }

    public void deleteAllOf(String keyspace) {
        this.redisOps.execute(connection -> {
            connection.del(new byte[][]{this.toBytes(keyspace)});
            new IndexWriter(connection, this.converter).removeAllIndexes(keyspace);
            return null;
        });
    }

    public CloseableIterator<Map.Entry<Object, Object>> entries(String keyspace) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public long count(String keyspace) {
        Long count = this.redisOps.execute(connection -> connection.sCard(this.toBytes(keyspace)));
        return count != null ? count : 0L;
    }

    public void update(PartialUpdate<?> update) {
        RedisPersistentEntity entity = (RedisPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(update.getTarget());
        String keyspace = entity.getKeySpace();
        Object id = update.getId();
        byte[] redisKey = this.createKey(keyspace, (String)this.converter.getConversionService().convert(id, String.class));
        RedisData rdo = new RedisData();
        this.converter.write(update, rdo);
        this.redisOps.execute(connection -> {
            RedisUpdateObject redisUpdateObject = new RedisUpdateObject(redisKey, keyspace, id);
            for (PartialUpdate.PropertyUpdate pUpdate : update.getPropertyUpdates()) {
                String propertyPath = pUpdate.getPropertyPath();
                if (!PartialUpdate.UpdateCommand.DEL.equals((Object)pUpdate.getCmd()) && !(pUpdate.getValue() instanceof Collection) && !(pUpdate.getValue() instanceof Map) && (pUpdate.getValue() == null || !pUpdate.getValue().getClass().isArray()) && (pUpdate.getValue() == null || this.converter.getConversionService().canConvert(pUpdate.getValue().getClass(), byte[].class))) continue;
                redisUpdateObject = this.fetchDeletePathsFromHashAndUpdateIndex(redisUpdateObject, propertyPath, connection);
            }
            if (!redisUpdateObject.fieldsToRemove.isEmpty()) {
                connection.hDel(redisKey, (byte[][])redisUpdateObject.fieldsToRemove.toArray((T[])new byte[redisUpdateObject.fieldsToRemove.size()][]));
            }
            for (RedisUpdateObject.Index index : redisUpdateObject.indexesToUpdate) {
                if (ObjectUtils.nullSafeEquals((Object)((Object)DataType.ZSET), (Object)((Object)index.type))) {
                    connection.zRem(index.key, new byte[][]{this.toBytes(redisUpdateObject.targetId)});
                    continue;
                }
                connection.sRem(index.key, new byte[][]{this.toBytes(redisUpdateObject.targetId)});
            }
            if (!rdo.getBucket().isEmpty() && (rdo.getBucket().size() > 1 || rdo.getBucket().size() == 1 && !rdo.getBucket().asMap().containsKey("_class"))) {
                connection.hMSet(redisKey, rdo.getBucket().rawMap());
            }
            if (update.isRefreshTtl()) {
                if (this.expires(rdo)) {
                    connection.expire(redisKey, rdo.getTimeToLive());
                    if (this.keepShadowCopy()) {
                        byte[] phantomKey = ByteUtils.concat(redisKey, MappingRedisConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX);
                        connection.hMSet(phantomKey, rdo.getBucket().rawMap());
                        connection.expire(phantomKey, rdo.getTimeToLive() + 300L);
                    }
                } else {
                    connection.persist(redisKey);
                    if (this.keepShadowCopy()) {
                        connection.del(new byte[][]{ByteUtils.concat(redisKey, MappingRedisConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX)});
                    }
                }
            }
            new IndexWriter(connection, this.converter).updateIndexes(this.toBytes(id), rdo.getIndexedData());
            return null;
        });
    }

    private RedisUpdateObject fetchDeletePathsFromHashAndUpdateIndex(RedisUpdateObject redisUpdateObject, String path, RedisConnection connection) {
        redisUpdateObject.addFieldToRemove(this.toBytes(path));
        byte[] value = connection.hGet(redisUpdateObject.targetKey, this.toBytes(path));
        if (value != null && value.length > 0) {
            byte[] existingValueIndexKey = ByteUtils.concatAll(this.toBytes(redisUpdateObject.keyspace), this.toBytes(":" + path), this.toBytes(":"), value);
            if (connection.exists(existingValueIndexKey).booleanValue()) {
                redisUpdateObject.addIndexToUpdate(new RedisUpdateObject.Index(existingValueIndexKey, DataType.SET));
            }
            return redisUpdateObject;
        }
        Set<byte[]> existingFields = connection.hKeys(redisUpdateObject.targetKey);
        for (byte[] field : existingFields) {
            byte[] existingValueIndexKey;
            if (!this.toString(field).startsWith(path + ".")) continue;
            redisUpdateObject.addFieldToRemove(field);
            value = connection.hGet(redisUpdateObject.targetKey, this.toBytes(field));
            if (value == null || !connection.exists(existingValueIndexKey = ByteUtils.concatAll(this.toBytes(redisUpdateObject.keyspace), this.toBytes(":"), field, this.toBytes(":"), value)).booleanValue()) continue;
            redisUpdateObject.addIndexToUpdate(new RedisUpdateObject.Index(existingValueIndexKey, DataType.SET));
        }
        String pathToUse = GeoIndexedPropertyValue.geoIndexName(path);
        byte[] existingGeoIndexKey = ByteUtils.concatAll(this.toBytes(redisUpdateObject.keyspace), this.toBytes(":"), this.toBytes(pathToUse));
        if (connection.zRank(existingGeoIndexKey, this.toBytes(redisUpdateObject.targetId)) != null) {
            redisUpdateObject.addIndexToUpdate(new RedisUpdateObject.Index(existingGeoIndexKey, DataType.ZSET));
        }
        return redisUpdateObject;
    }

    @Nullable
    public <T> T execute(RedisCallback<T> callback) {
        return this.redisOps.execute(callback);
    }

    public RedisConverter getConverter() {
        return this.converter;
    }

    public void clear() {
    }

    public byte[] createKey(String keyspace, String id) {
        return this.toBytes(keyspace + ":" + id);
    }

    public byte[] toBytes(Object source) {
        byte[] bytes;
        return source instanceof byte[] ? (bytes = (byte[])source) : (byte[])this.getConverter().getConversionService().convert(source, byte[].class);
    }

    private String toString(Object value) {
        String stringValue;
        return value instanceof String ? (stringValue = (String)value) : (String)this.getConverter().getConversionService().convert(value, String.class);
    }

    @Nullable
    private <T> T readBackTimeToLiveIfSet(@Nullable byte[] key, @Nullable T target) {
        if (target == null || key == null) {
            return target;
        }
        RedisPersistentEntity entity = (RedisPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(target.getClass());
        if (entity.hasExplicitTimeToLiveProperty()) {
            RedisPersistentProperty ttlProperty = entity.getExplicitTimeToLiveProperty();
            if (ttlProperty == null) {
                return target;
            }
            TimeToLive ttl = (TimeToLive)ttlProperty.findAnnotation(TimeToLive.class);
            Long timeout = this.redisOps.execute(connection -> {
                if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)ttl.unit()))) {
                    return connection.ttl(key);
                }
                return connection.pTtl(key, ttl.unit());
            });
            if (timeout != null || !ttlProperty.getType().isPrimitive()) {
                PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(target);
                propertyAccessor.setProperty((PersistentProperty)ttlProperty, this.converter.getConversionService().convert((Object)timeout, ttlProperty.getType()));
                target = propertyAccessor.getBean();
            }
        }
        return target;
    }

    private boolean expires(RedisData data) {
        return data.getTimeToLive() != null && data.getTimeToLive() > 0L;
    }

    public void setEnableKeyspaceEvents(EnableKeyspaceEvents enableKeyspaceEvents) {
        this.enableKeyspaceEvents = enableKeyspaceEvents;
    }

    public void setMessageListenerContainer(RedisMessageListenerContainer messageListenerContainer) {
        Assert.notNull((Object)messageListenerContainer, (String)"RedisMessageListenerContainer must not be null");
        if (this.managedListenerContainer && this.messageListenerContainer != null) {
            throw new IllegalStateException("Cannot set RedisMessageListenerContainer after initializing a managed RedisMessageListenerContainer instance");
        }
        this.managedListenerContainer = false;
        this.messageListenerContainer = messageListenerContainer;
    }

    public void setKeyspaceNotificationsConfigParameter(String keyspaceNotificationsConfigParameter) {
        this.keyspaceNotificationsConfigParameter = keyspaceNotificationsConfigParameter;
    }

    public void setShadowCopy(ShadowCopy shadowCopy) {
        this.shadowCopy = shadowCopy;
    }

    public boolean isRunning() {
        return State.STARTED.equals((Object)this.state.get());
    }

    public void afterPropertiesSet() {
        if (this.managedListenerContainer) {
            this.initMessageListenerContainer();
        }
    }

    public void start() {
        State current = this.state.getAndUpdate(state -> RedisKeyValueAdapter.isCreatedOrStopped(state) ? State.STARTING : state);
        if (RedisKeyValueAdapter.isCreatedOrStopped(current)) {
            this.messageListenerContainer.start();
            if (ObjectUtils.nullSafeEquals((Object)((Object)EnableKeyspaceEvents.ON_STARTUP), (Object)((Object)this.enableKeyspaceEvents))) {
                this.initKeyExpirationListener(this.messageListenerContainer);
            }
            this.state.set(State.STARTED);
        }
    }

    private static boolean isCreatedOrStopped(@Nullable State state) {
        return State.CREATED.equals((Object)state) || State.STOPPED.equals((Object)state);
    }

    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            KeyExpirationEventMessageListener listener = this.expirationListener.get();
            if (listener != null && this.expirationListener.compareAndSet(listener, null)) {
                try {
                    listener.destroy();
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Could not destroy KeyExpirationEventMessageListener", (Throwable)e);
                }
            }
            this.messageListenerContainer.stop();
            this.state.set(State.STOPPED);
        }
    }

    public void destroy() throws Exception {
        this.stop();
        if (this.managedListenerContainer && this.messageListenerContainer != null) {
            this.messageListenerContainer.destroy();
            this.messageListenerContainer = null;
        }
        this.state.set(State.DESTROYED);
    }

    public void onApplicationEvent(RedisKeyspaceEvent event) {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.eventPublisher = applicationContext;
    }

    private void initMessageListenerContainer() {
        this.messageListenerContainer = new RedisMessageListenerContainer();
        this.messageListenerContainer.setConnectionFactory(((RedisTemplate)this.redisOps).getConnectionFactory());
        this.messageListenerContainer.afterPropertiesSet();
    }

    private void initKeyExpirationListener(RedisMessageListenerContainer messageListenerContainer) {
        if (this.expirationListener.get() == null) {
            MappingExpirationListener listener = new MappingExpirationListener(messageListenerContainer, this.redisOps, this.converter, this.shadowCopy);
            listener.setKeyspaceNotificationsConfigParameter(this.keyspaceNotificationsConfigParameter);
            if (this.eventPublisher != null) {
                listener.setApplicationEventPublisher(this.eventPublisher);
            }
            if (this.expirationListener.compareAndSet(null, listener)) {
                listener.init();
            }
        }
    }

    private boolean keepShadowCopy() {
        return switch (this.shadowCopy) {
            case ShadowCopy.OFF -> false;
            case ShadowCopy.ON -> true;
            default -> this.expirationListener.get() != null;
        };
    }

    static enum State {
        CREATED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        DESTROYED;

    }

    public static enum EnableKeyspaceEvents {
        ON_STARTUP,
        ON_DEMAND,
        OFF;

    }

    public static enum ShadowCopy {
        DEFAULT,
        ON,
        OFF;

    }

    static class RedisUpdateObject {
        private final String keyspace;
        private final Object targetId;
        private final byte[] targetKey;
        private final Set<byte[]> fieldsToRemove = new LinkedHashSet<byte[]>();
        private final Set<Index> indexesToUpdate = new LinkedHashSet<Index>();

        RedisUpdateObject(byte[] targetKey, String keyspace, Object targetId) {
            this.targetKey = targetKey;
            this.keyspace = keyspace;
            this.targetId = targetId;
        }

        void addFieldToRemove(byte[] field) {
            this.fieldsToRemove.add(field);
        }

        void addIndexToUpdate(Index index) {
            this.indexesToUpdate.add(index);
        }

        static class Index {
            final DataType type;
            final byte[] key;

            public Index(byte[] key, DataType type) {
                this.key = key;
                this.type = type;
            }
        }
    }

    static class MappingExpirationListener
    extends KeyExpirationEventMessageListener {
        private final RedisOperations<?, ?> ops;
        private final RedisConverter converter;
        private final ShadowCopy shadowCopy;

        MappingExpirationListener(RedisMessageListenerContainer listenerContainer, RedisOperations<?, ?> ops, RedisConverter converter, ShadowCopy shadowCopy) {
            super(listenerContainer);
            this.ops = ops;
            this.converter = converter;
            this.shadowCopy = shadowCopy;
        }

        @Override
        public void onMessage(Message message, @Nullable byte[] pattern) {
            if (!this.isKeyExpirationMessage(message)) {
                return;
            }
            byte[] key = message.getBody();
            Object value = this.readShadowCopyIfEnabled(key);
            byte[] channelAsBytes = message.getChannel();
            String channel = !ObjectUtils.isEmpty((Object)channelAsBytes) ? (String)this.converter.getConversionService().convert((Object)channelAsBytes, String.class) : null;
            RedisKeyExpiredEvent event = new RedisKeyExpiredEvent(channel, key, value);
            this.ops.execute(connection -> {
                connection.sRem((byte[])this.converter.getConversionService().convert((Object)event.getKeyspace(), byte[].class), new byte[][]{event.getId()});
                new IndexWriter(connection, this.converter).removeKeyFromIndexes(event.getKeyspace(), event.getId());
                return null;
            });
            this.publishEvent(event);
        }

        private boolean isKeyExpirationMessage(Message message) {
            return MappingRedisConverter.BinaryKeyspaceIdentifier.isValid(message.getBody());
        }

        @Nullable
        private Object readShadowCopyIfEnabled(byte[] key) {
            if (this.shadowCopy == ShadowCopy.OFF) {
                return null;
            }
            return this.readShadowCopy(key);
        }

        @Nullable
        private Object readShadowCopy(byte[] key) {
            byte[] phantomKey = ByteUtils.concat(key, (byte[])this.converter.getConversionService().convert((Object)":phantom", byte[].class));
            Map hash = this.ops.execute(connection -> {
                Map<byte[], byte[]> phantomValue = connection.hGetAll(phantomKey);
                if (!CollectionUtils.isEmpty(phantomValue)) {
                    connection.del(new byte[][]{phantomKey});
                }
                return phantomValue;
            });
            return CollectionUtils.isEmpty((Map)hash) ? null : this.converter.read(Object.class, new RedisData(hash));
        }
    }
}

