/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public abstract class TimeoutUtils {
    private static final Duration ONE_SECOND = Duration.ofSeconds(1L);

    public static boolean hasMillis(Duration duration) {
        return TimeoutUtils.containsSplitSecond(duration.toMillis());
    }

    public static boolean containsSplitSecond(long millis) {
        return millis % 1000L != 0L;
    }

    public static long toSeconds(Duration duration) {
        return TimeoutUtils.roundUpIfNecessary(duration.toMillis(), duration.getSeconds());
    }

    public static long toSeconds(long timeout, TimeUnit unit) {
        return TimeoutUtils.roundUpIfNecessary(timeout, unit.toSeconds(timeout));
    }

    public static double toDoubleSeconds(long timeout, TimeUnit unit) {
        return switch (unit) {
            case TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS -> (double)unit.toMillis(timeout) / 1000.0;
            default -> unit.toSeconds(timeout);
        };
    }

    public static long toMillis(long timeout, TimeUnit unit) {
        return TimeoutUtils.roundUpIfNecessary(timeout, unit.toMillis(timeout));
    }

    static boolean isZeroOrGreaterThanOneSecond(Duration duration) {
        return duration.isZero() || duration.compareTo(ONE_SECOND) >= 0;
    }

    private static long roundUpIfNecessary(long timeout, long convertedTimeout) {
        if (timeout > 0L && convertedTimeout == 0L) {
            return 1L;
        }
        return convertedTimeout;
    }
}

