/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class DigestUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Charset UTF8_CHARSET = Charset.forName("UTF8");

    public static String sha1DigestAsHex(String data) {
        byte[] dataBytes = DigestUtils.getDigest("SHA").digest(data.getBytes(UTF8_CHARSET));
        return new String(DigestUtils.encodeHex(dataBytes));
    }

    private static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = HEX_CHARS[(0xF0 & data[i]) >>> 4];
            out[j++] = HEX_CHARS[0xF & data[i]];
        }
        return out;
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("MessageDigest with algorithm '%s' not found".formatted(algorithm), ex);
        }
    }
}

