/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisGeoCommands {
    @Nullable
    public Long geoAdd(byte[] var1, Point var2, byte[] var3);

    @Nullable
    default public Long geoAdd(byte[] key, GeoLocation<byte[]> location) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(location, (String)"Location must not be null");
        return this.geoAdd(key, location.getPoint(), (byte[])location.getName());
    }

    @Nullable
    public Long geoAdd(byte[] var1, Map<byte[], Point> var2);

    @Nullable
    public Long geoAdd(byte[] var1, Iterable<GeoLocation<byte[]>> var2);

    @Nullable
    public Distance geoDist(byte[] var1, byte[] var2, byte[] var3);

    @Nullable
    public Distance geoDist(byte[] var1, byte[] var2, byte[] var3, Metric var4);

    @Nullable
    public List<String> geoHash(byte[] var1, byte[] ... var2);

    @Nullable
    public List<Point> geoPos(byte[] var1, byte[] ... var2);

    @Nullable
    public GeoResults<GeoLocation<byte[]>> geoRadius(byte[] var1, Circle var2);

    @Nullable
    public GeoResults<GeoLocation<byte[]>> geoRadius(byte[] var1, Circle var2, GeoRadiusCommandArgs var3);

    @Nullable
    default public GeoResults<GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, (Metric)DistanceUnit.METERS));
    }

    @Nullable
    public GeoResults<GeoLocation<byte[]>> geoRadiusByMember(byte[] var1, byte[] var2, Distance var3);

    @Nullable
    public GeoResults<GeoLocation<byte[]>> geoRadiusByMember(byte[] var1, byte[] var2, Distance var3, GeoRadiusCommandArgs var4);

    @Nullable
    public Long geoRemove(byte[] var1, byte[] ... var2);

    @Nullable
    public GeoResults<GeoLocation<byte[]>> geoSearch(byte[] var1, GeoReference<byte[]> var2, GeoShape var3, GeoSearchCommandArgs var4);

    @Nullable
    public Long geoSearchStore(byte[] var1, byte[] var2, GeoReference<byte[]> var3, GeoShape var4, GeoSearchStoreCommandArgs var5);

    public static class GeoLocation<T>
    extends org.springframework.data.redis.domain.geo.GeoLocation<T> {
        public GeoLocation(T name, Point point) {
            super(name, point);
        }

        @Override
        public String toString() {
            return "RedisGeoCommands.GeoLocation(name=" + String.valueOf(this.getName()) + ", point=" + String.valueOf(this.getPoint()) + ")";
        }
    }

    public static enum DistanceUnit implements Metric
    {
        METERS(6378137.0, "m"),
        KILOMETERS(6378.137, "km"),
        MILES(3963.191, "mi"),
        FEET(2.0925646325E7, "ft");

        private final double multiplier;
        private final String abbreviation;

        private DistanceUnit(double multiplier, String abbreviation) {
            this.multiplier = multiplier;
            this.abbreviation = abbreviation;
        }

        public double getMultiplier() {
            return this.multiplier;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }
    }

    public static class GeoRadiusCommandArgs
    extends GeoSearchCommandArgs
    implements Cloneable {
        private GeoRadiusCommandArgs() {
        }

        public static GeoRadiusCommandArgs newGeoRadiusArgs() {
            return new GeoRadiusCommandArgs();
        }

        @Override
        public GeoRadiusCommandArgs includeCoordinates() {
            super.includeCoordinates();
            return this;
        }

        @Override
        public GeoRadiusCommandArgs includeDistance() {
            super.includeDistance();
            return this;
        }

        @Override
        public GeoRadiusCommandArgs sort(Sort.Direction direction) {
            super.sort(direction);
            return this;
        }

        @Override
        public GeoRadiusCommandArgs sortAscending() {
            super.sortAscending();
            return this;
        }

        @Override
        public GeoRadiusCommandArgs sortDescending() {
            super.sortDescending();
            return this;
        }

        @Override
        public GeoRadiusCommandArgs limit(long count) {
            super.limit(count);
            return this;
        }

        public Set<Flag> getFlags() {
            return this.flags.stream().map(it -> (Flag)it).collect(Collectors.toSet());
        }

        @Override
        protected GeoRadiusCommandArgs clone() {
            GeoRadiusCommandArgs that = new GeoRadiusCommandArgs();
            that.flags.addAll(this.flags);
            that.limit = this.limit;
            that.sortDirection = this.sortDirection;
            return that;
        }

        public static enum Flag implements GeoCommandArgs.GeoCommandFlag
        {
            WITHCOORD,
            WITHDIST,
            ANY,
            STOREDIST;

        }
    }

    public static class GeoSearchStoreCommandArgs
    implements GeoCommandArgs,
    Cloneable {
        private final Set<GeoCommandArgs.GeoCommandFlag> flags = new LinkedHashSet<GeoCommandArgs.GeoCommandFlag>(2, 1.0f);
        @Nullable
        private Long limit;
        @Nullable
        private Sort.Direction sortDirection;

        private GeoSearchStoreCommandArgs() {
        }

        public static GeoSearchStoreCommandArgs newGeoSearchStoreArgs() {
            return new GeoSearchStoreCommandArgs();
        }

        public GeoSearchStoreCommandArgs storeDistance() {
            this.flags.add(GeoRadiusCommandArgs.Flag.STOREDIST);
            return this;
        }

        public GeoSearchStoreCommandArgs sort(Sort.Direction direction) {
            Assert.notNull((Object)direction, (String)"Sort direction must not be null");
            this.sortDirection = Sort.Direction.ASC;
            return this;
        }

        public GeoSearchStoreCommandArgs sortAscending() {
            return this.sort(Sort.Direction.ASC);
        }

        public GeoSearchStoreCommandArgs sortDescending() {
            return this.sort(Sort.Direction.DESC);
        }

        public GeoSearchStoreCommandArgs limit(long count) {
            return this.limit(count, false);
        }

        public GeoSearchStoreCommandArgs limit(long count, boolean any) {
            Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Count has to positive value");
            this.limit = count;
            if (any) {
                this.flags.add(GeoCommandArgs.GeoCommandFlag.any());
            }
            return this;
        }

        public Set<GeoCommandArgs.GeoCommandFlag> getFlags() {
            return this.flags;
        }

        @Override
        @Nullable
        public Long getLimit() {
            return this.limit;
        }

        @Override
        @Nullable
        public Sort.Direction getSortDirection() {
            return this.sortDirection;
        }

        public boolean isStoreDistance() {
            return this.flags.contains(GeoCommandArgs.GeoCommandFlag.storeDist());
        }

        public boolean hasAnyLimit() {
            return this.hasLimit() && this.flags.contains(GeoCommandArgs.GeoCommandFlag.any());
        }

        protected GeoSearchStoreCommandArgs clone() {
            GeoSearchStoreCommandArgs that = new GeoSearchStoreCommandArgs();
            that.flags.addAll(this.flags);
            that.limit = this.limit;
            that.sortDirection = this.sortDirection;
            return that;
        }
    }

    public static class GeoSearchCommandArgs
    implements GeoCommandArgs,
    Cloneable {
        protected final Set<GeoCommandArgs.GeoCommandFlag> flags = new LinkedHashSet<GeoCommandArgs.GeoCommandFlag>(2, 1.0f);
        @Nullable
        protected Long limit;
        @Nullable
        protected Sort.Direction sortDirection;

        private GeoSearchCommandArgs() {
        }

        public static GeoSearchCommandArgs newGeoSearchArgs() {
            return new GeoSearchCommandArgs();
        }

        public GeoSearchCommandArgs includeCoordinates() {
            this.flags.add(GeoCommandArgs.GeoCommandFlag.withCord());
            return this;
        }

        public GeoSearchCommandArgs includeDistance() {
            this.flags.add(GeoCommandArgs.GeoCommandFlag.withDist());
            return this;
        }

        public GeoSearchCommandArgs sort(Sort.Direction direction) {
            Assert.notNull((Object)direction, (String)"Sort direction must not be null");
            this.sortDirection = direction;
            return this;
        }

        public GeoSearchCommandArgs sortAscending() {
            return this.sort(Sort.Direction.ASC);
        }

        public GeoSearchCommandArgs sortDescending() {
            return this.sort(Sort.Direction.DESC);
        }

        public GeoSearchCommandArgs limit(long count) {
            return this.limit(count, false);
        }

        public GeoSearchCommandArgs limit(long count, boolean any) {
            Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Count has to positive value");
            this.limit = count;
            if (any) {
                this.flags.add(GeoCommandArgs.GeoCommandFlag.any());
            }
            return this;
        }

        @Override
        public Set<? extends GeoCommandArgs.GeoCommandFlag> getFlags() {
            return this.flags;
        }

        @Override
        @Nullable
        public Long getLimit() {
            return this.limit;
        }

        @Override
        @Nullable
        public Sort.Direction getSortDirection() {
            return this.sortDirection;
        }

        public boolean hasAnyLimit() {
            return this.hasLimit() && this.flags.contains(GeoCommandArgs.GeoCommandFlag.any());
        }

        protected GeoSearchCommandArgs clone() {
            GeoSearchCommandArgs that = new GeoSearchCommandArgs();
            that.flags.addAll(this.flags);
            that.limit = this.limit;
            that.sortDirection = this.sortDirection;
            return that;
        }
    }

    public static interface GeoCommandArgs {
        @Nullable
        public Sort.Direction getSortDirection();

        @Nullable
        public Long getLimit();

        public Set<? extends GeoCommandFlag> getFlags();

        default public boolean hasLimit() {
            return this.getLimit() != null;
        }

        default public boolean hasSortDirection() {
            return this.getSortDirection() != null;
        }

        default public boolean hasFlags() {
            return !this.getFlags().isEmpty();
        }

        public static interface GeoCommandFlag {
            public static GeoCommandFlag any() {
                return GeoRadiusCommandArgs.Flag.ANY;
            }

            public static GeoCommandFlag withCord() {
                return GeoRadiusCommandArgs.Flag.WITHCOORD;
            }

            public static GeoCommandFlag withDist() {
                return GeoRadiusCommandArgs.Flag.WITHDIST;
            }

            public static GeoCommandFlag storeDist() {
                return GeoRadiusCommandArgs.Flag.STOREDIST;
            }
        }
    }
}

