/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisTxCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundOperationsProxyFactory;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundStreamOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.CloseSuppressingInvocationHandler;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultClusterOperations;
import org.springframework.data.redis.core.DefaultGeoOperations;
import org.springframework.data.redis.core.DefaultHashOperations;
import org.springframework.data.redis.core.DefaultHyperLogLogOperations;
import org.springframework.data.redis.core.DefaultListOperations;
import org.springframework.data.redis.core.DefaultSetOperations;
import org.springframework.data.redis.core.DefaultStreamOperations;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.DefaultValueOperations;
import org.springframework.data.redis.core.DefaultZSetOperations;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisAccessor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.QueryUtils;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.script.ScriptExecutor;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.hash.ObjectHashMapper;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class RedisTemplate<K, V>
extends RedisAccessor
implements RedisOperations<K, V>,
BeanClassLoaderAware {
    private boolean enableTransactionSupport = false;
    private boolean exposeConnection = false;
    private boolean initialized = false;
    private boolean enableDefaultSerializer = true;
    @Nullable
    private RedisSerializer<?> defaultSerializer;
    @Nullable
    private ClassLoader classLoader;
    @Nullable
    private RedisSerializer keySerializer = null;
    @Nullable
    private RedisSerializer valueSerializer = null;
    @Nullable
    private RedisSerializer hashKeySerializer = null;
    @Nullable
    private RedisSerializer hashValueSerializer = null;
    private RedisSerializer<String> stringSerializer = RedisSerializer.string();
    @Nullable
    private ScriptExecutor<K> scriptExecutor;
    private final BoundOperationsProxyFactory boundOperations = new BoundOperationsProxyFactory();
    private final ValueOperations<K, V> valueOps = new DefaultValueOperations(this);
    private final ListOperations<K, V> listOps = new DefaultListOperations(this);
    private final SetOperations<K, V> setOps = new DefaultSetOperations(this);
    private final StreamOperations<K, ?, ?> streamOps = new DefaultStreamOperations<Object, byte[], byte[]>(this, ObjectHashMapper.getSharedInstance());
    private final ZSetOperations<K, V> zSetOps = new DefaultZSetOperations(this);
    private final GeoOperations<K, V> geoOps = new DefaultGeoOperations<K, V>(this);
    private final HyperLogLogOperations<K, V> hllOps = new DefaultHyperLogLogOperations(this);
    private final ClusterOperations<K, V> clusterOps = new DefaultClusterOperations(this);

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        boolean defaultUsed = false;
        if (this.defaultSerializer == null) {
            this.defaultSerializer = new JdkSerializationRedisSerializer(this.classLoader != null ? this.classLoader : this.getClass().getClassLoader());
        }
        if (this.enableDefaultSerializer) {
            if (this.keySerializer == null) {
                this.keySerializer = this.defaultSerializer;
                defaultUsed = true;
            }
            if (this.valueSerializer == null) {
                this.valueSerializer = this.defaultSerializer;
                defaultUsed = true;
            }
            if (this.hashKeySerializer == null) {
                this.hashKeySerializer = this.defaultSerializer;
                defaultUsed = true;
            }
            if (this.hashValueSerializer == null) {
                this.hashValueSerializer = this.defaultSerializer;
                defaultUsed = true;
            }
        }
        if (this.enableDefaultSerializer && defaultUsed) {
            Assert.notNull(this.defaultSerializer, (String)"default serializer null and not all serializers initialized");
        }
        if (this.scriptExecutor == null) {
            this.scriptExecutor = new DefaultScriptExecutor(this);
        }
        this.initialized = true;
    }

    public boolean isExposeConnection() {
        return this.exposeConnection;
    }

    public void setExposeConnection(boolean exposeConnection) {
        this.exposeConnection = exposeConnection;
    }

    public boolean isEnableDefaultSerializer() {
        return this.enableDefaultSerializer;
    }

    public void setEnableDefaultSerializer(boolean enableDefaultSerializer) {
        this.enableDefaultSerializer = enableDefaultSerializer;
    }

    public void setEnableTransactionSupport(boolean enableTransactionSupport) {
        this.enableTransactionSupport = enableTransactionSupport;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Nullable
    public RedisSerializer<?> getDefaultSerializer() {
        return this.defaultSerializer;
    }

    public void setDefaultSerializer(RedisSerializer<?> serializer) {
        this.defaultSerializer = serializer;
    }

    public void setKeySerializer(RedisSerializer<?> serializer) {
        this.keySerializer = serializer;
    }

    @Override
    public RedisSerializer<?> getKeySerializer() {
        return this.keySerializer;
    }

    public void setValueSerializer(RedisSerializer<?> serializer) {
        this.valueSerializer = serializer;
    }

    @Override
    public RedisSerializer<?> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public RedisSerializer<?> getHashKeySerializer() {
        return this.hashKeySerializer;
    }

    public void setHashKeySerializer(RedisSerializer<?> hashKeySerializer) {
        this.hashKeySerializer = hashKeySerializer;
    }

    @Override
    public RedisSerializer<?> getHashValueSerializer() {
        return this.hashValueSerializer;
    }

    public void setHashValueSerializer(RedisSerializer<?> hashValueSerializer) {
        this.hashValueSerializer = hashValueSerializer;
    }

    public RedisSerializer<String> getStringSerializer() {
        return this.stringSerializer;
    }

    public void setStringSerializer(RedisSerializer<String> stringSerializer) {
        this.stringSerializer = stringSerializer;
    }

    public void setScriptExecutor(ScriptExecutor<K> scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    @Override
    @Nullable
    public <T> T execute(RedisCallback<T> action) {
        return this.execute(action, this.isExposeConnection());
    }

    @Nullable
    public <T> T execute(RedisCallback<T> action, boolean exposeConnection) {
        return this.execute(action, exposeConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T execute(RedisCallback<T> action, boolean exposeConnection, boolean pipeline) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(action, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnection conn = RedisConnectionUtils.getConnection(factory, this.enableTransactionSupport);
        try {
            boolean existingConnection = TransactionSynchronizationManager.hasResource((Object)factory);
            RedisConnection connToUse = this.preProcessConnection(conn, existingConnection);
            boolean pipelineStatus = connToUse.isPipelined();
            if (pipeline && !pipelineStatus) {
                connToUse.openPipeline();
            }
            RedisConnection connToExpose = exposeConnection ? connToUse : this.createRedisConnectionProxy(connToUse);
            T result = action.doInRedis(connToExpose);
            if (pipeline && !pipelineStatus) {
                connToUse.closePipeline();
            }
            T t = this.postProcessResult(result, connToUse, existingConnection);
            return t;
        }
        finally {
            RedisConnectionUtils.releaseConnection(conn, factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(SessionCallback<T> session) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(session, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnectionUtils.bindConnection(factory, this.enableTransactionSupport);
        try {
            T t = session.execute(this);
            return t;
        }
        finally {
            RedisConnectionUtils.unbindConnection(factory);
        }
    }

    @Override
    public List<Object> executePipelined(SessionCallback<?> session) {
        return this.executePipelined(session, this.valueSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> executePipelined(SessionCallback<?> session, @Nullable RedisSerializer<?> resultSerializer) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(session, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnectionUtils.bindConnection(factory, this.enableTransactionSupport);
        try {
            List list = this.execute((RedisConnection connection) -> {
                connection.openPipeline();
                boolean pipelinedClosed = false;
                try {
                    Object result = this.executeSession(session);
                    if (result != null) {
                        throw new InvalidDataAccessApiUsageException("Callback cannot return a non-null value as it gets overwritten by the pipeline");
                    }
                    List<Object> closePipeline = connection.closePipeline();
                    pipelinedClosed = true;
                    List<Object> list = this.deserializeMixedResults(closePipeline, resultSerializer, this.hashKeySerializer, this.hashValueSerializer);
                    return list;
                }
                finally {
                    if (!pipelinedClosed) {
                        connection.closePipeline();
                    }
                }
            });
            return list;
        }
        finally {
            RedisConnectionUtils.unbindConnection(factory);
        }
    }

    @Override
    public List<Object> executePipelined(RedisCallback<?> action) {
        return this.executePipelined(action, this.valueSerializer);
    }

    @Override
    public List<Object> executePipelined(RedisCallback<?> action, @Nullable RedisSerializer<?> resultSerializer) {
        return this.execute((RedisConnection connection) -> {
            connection.openPipeline();
            boolean pipelinedClosed = false;
            try {
                Object result = action.doInRedis(connection);
                if (result != null) {
                    throw new InvalidDataAccessApiUsageException("Callback cannot return a non-null value as it gets overwritten by the pipeline");
                }
                List<Object> closePipeline = connection.closePipeline();
                pipelinedClosed = true;
                List<Object> list = this.deserializeMixedResults(closePipeline, resultSerializer, this.hashKeySerializer, this.hashValueSerializer);
                return list;
            }
            finally {
                if (!pipelinedClosed) {
                    connection.closePipeline();
                }
            }
        });
    }

    @Override
    public <T> T execute(RedisScript<T> script, List<K> keys, Object ... args) {
        return this.scriptExecutor.execute(script, keys, args);
    }

    @Override
    public <T> T execute(RedisScript<T> script, RedisSerializer<?> argsSerializer, RedisSerializer<T> resultSerializer, List<K> keys, Object ... args) {
        return this.scriptExecutor.execute(script, argsSerializer, resultSerializer, keys, args);
    }

    @Override
    public <T extends Closeable> T executeWithStickyConnection(RedisCallback<T> callback) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(callback, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnection connection = this.preProcessConnection(RedisConnectionUtils.doGetConnection(factory, true, false, false), false);
        return (T)((Closeable)callback.doInRedis(connection));
    }

    private Object executeSession(SessionCallback<?> session) {
        return session.execute(this);
    }

    protected RedisConnection createRedisConnectionProxy(RedisConnection connection) {
        Class[] ifcs = ClassUtils.getAllInterfacesForClass(connection.getClass(), (ClassLoader)this.getClass().getClassLoader());
        return (RedisConnection)Proxy.newProxyInstance(connection.getClass().getClassLoader(), ifcs, (InvocationHandler)new CloseSuppressingInvocationHandler(connection));
    }

    protected RedisConnection preProcessConnection(RedisConnection connection, boolean existingConnection) {
        return connection;
    }

    @Nullable
    protected <T> T postProcessResult(@Nullable T result, RedisConnection conn, boolean existingConnection) {
        return result;
    }

    @Override
    public Boolean copy(K source, K target, boolean replace) {
        byte[] sourceKey = this.rawKey(source);
        byte[] targetKey = this.rawKey(target);
        return this.doWithKeys(connection -> connection.copy(sourceKey, targetKey, replace));
    }

    @Override
    public Boolean hasKey(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.doWithKeys(connection -> connection.exists(rawKey));
    }

    @Override
    public Long countExistingKeys(Collection<K> keys) {
        Assert.notNull(keys, (String)"Keys must not be null");
        byte[][] rawKeys = this.rawKeys(keys);
        return this.doWithKeys(connection -> connection.exists(rawKeys));
    }

    @Override
    public Boolean delete(K key) {
        byte[] rawKey = this.rawKey(key);
        Long result = this.doWithKeys(connection -> connection.del(new byte[][]{rawKey}));
        return result != null && result.intValue() == 1;
    }

    @Override
    public Long delete(Collection<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        byte[][] rawKeys = this.rawKeys(keys);
        return this.doWithKeys(connection -> connection.del(rawKeys));
    }

    @Override
    public Boolean unlink(K key) {
        byte[] rawKey = this.rawKey(key);
        Long result = this.doWithKeys(connection -> connection.unlink(new byte[][]{rawKey}));
        return result != null && result.intValue() == 1;
    }

    @Override
    public Long unlink(Collection<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        byte[][] rawKeys = this.rawKeys(keys);
        return this.doWithKeys(connection -> connection.unlink(rawKeys));
    }

    @Override
    public DataType type(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.doWithKeys(connection -> connection.type(rawKey));
    }

    @Override
    public Set<K> keys(K pattern) {
        byte[] rawKey = this.rawKey(pattern);
        Set rawKeys = this.doWithKeys(connection -> connection.keys(rawKey));
        return this.keySerializer != null ? SerializationUtils.deserialize(rawKeys, this.keySerializer) : rawKeys;
    }

    @Override
    public Cursor<K> scan(ScanOptions options) {
        Assert.notNull((Object)options, (String)"ScanOptions must not be null");
        return this.executeWithStickyConnection(connection -> new ConvertingCursor(connection.scan(options), this::deserializeKey));
    }

    @Override
    public K randomKey() {
        byte[] rawKey = this.doWithKeys(RedisKeyCommands::randomKey);
        return this.deserializeKey(rawKey);
    }

    @Override
    public void rename(K oldKey, K newKey) {
        byte[] rawOldKey = this.rawKey(oldKey);
        byte[] rawNewKey = this.rawKey(newKey);
        this.doWithKeys(connection -> {
            connection.rename(rawOldKey, rawNewKey);
            return null;
        });
    }

    @Override
    public Boolean renameIfAbsent(K oldKey, K newKey) {
        byte[] rawOldKey = this.rawKey(oldKey);
        byte[] rawNewKey = this.rawKey(newKey);
        return this.doWithKeys(connection -> connection.renameNX(rawOldKey, rawNewKey));
    }

    @Override
    public Boolean expire(K key, long timeout, TimeUnit unit) {
        byte[] rawKey = this.rawKey(key);
        long rawTimeout = TimeoutUtils.toMillis(timeout, unit);
        return this.doWithKeys(connection -> {
            try {
                return connection.pExpire(rawKey, rawTimeout);
            }
            catch (Exception ignore) {
                return connection.expire(rawKey, TimeoutUtils.toSeconds(timeout, unit));
            }
        });
    }

    @Override
    public Boolean expireAt(K key, Date date) {
        byte[] rawKey = this.rawKey(key);
        return this.doWithKeys(connection -> {
            try {
                return connection.pExpireAt(rawKey, date.getTime());
            }
            catch (Exception ignore) {
                return connection.expireAt(rawKey, date.getTime() / 1000L);
            }
        });
    }

    @Override
    public Boolean persist(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.doWithKeys(connection -> connection.persist(rawKey));
    }

    @Override
    public Long getExpire(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.doWithKeys(connection -> connection.ttl(rawKey));
    }

    @Override
    public Long getExpire(K key, TimeUnit timeUnit) {
        byte[] rawKey = this.rawKey(key);
        return this.doWithKeys(connection -> {
            try {
                return connection.pTtl(rawKey, timeUnit);
            }
            catch (Exception ignore) {
                return connection.ttl(rawKey, timeUnit);
            }
        });
    }

    @Override
    public Boolean move(K key, int dbIndex) {
        byte[] rawKey = this.rawKey(key);
        return this.doWithKeys(connection -> connection.move(rawKey, dbIndex));
    }

    @Override
    public byte[] dump(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.doWithKeys(connection -> connection.dump(rawKey));
    }

    @Override
    public void restore(K key, byte[] value, long timeToLive, TimeUnit unit, boolean replace) {
        byte[] rawKey = this.rawKey(key);
        long rawTimeout = TimeoutUtils.toMillis(timeToLive, unit);
        this.doWithKeys(connection -> {
            connection.restore(rawKey, rawTimeout, value, replace);
            return null;
        });
    }

    @Nullable
    private <T> T doWithKeys(Function<RedisKeyCommands, T> action) {
        return (T)this.execute(connection -> action.apply(connection.keyCommands()), true);
    }

    @Override
    public List<V> sort(SortQuery<K> query) {
        return this.sort(query, this.valueSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, @Nullable RedisSerializer<T> resultSerializer) {
        byte[] rawKey = this.rawKey(query.getKey());
        SortParameters params = QueryUtils.convertQuery(query, this.stringSerializer);
        List vals = this.doWithKeys(connection -> connection.sort(rawKey, params));
        return SerializationUtils.deserialize(vals, resultSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, BulkMapper<T, V> bulkMapper) {
        return this.sort(query, bulkMapper, this.valueSerializer);
    }

    @Override
    public <T, S> List<T> sort(SortQuery<K> query, BulkMapper<T, S> bulkMapper, @Nullable RedisSerializer<S> resultSerializer) {
        List<S> values = this.sort(query, resultSerializer);
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        int bulkSize = query.getGetPattern().size();
        ArrayList<T> result = new ArrayList<T>(values.size() / bulkSize + 1);
        ArrayList<S> bulk = new ArrayList<S>(bulkSize);
        for (S s : values) {
            bulk.add(s);
            if (bulk.size() != bulkSize) continue;
            result.add(bulkMapper.mapBulk(Collections.unmodifiableList(bulk)));
            bulk = new ArrayList(bulkSize);
        }
        return result;
    }

    @Override
    public Long sort(SortQuery<K> query, K storeKey) {
        byte[] rawStoreKey = this.rawKey(storeKey);
        byte[] rawKey = this.rawKey(query.getKey());
        SortParameters params = QueryUtils.convertQuery(query, this.stringSerializer);
        return this.doWithKeys(connection -> connection.sort(rawKey, params, rawStoreKey));
    }

    @Override
    public void watch(K key) {
        byte[] rawKey = this.rawKey(key);
        this.executeWithoutResult(connection -> connection.watch(new byte[][]{rawKey}));
    }

    @Override
    public void watch(Collection<K> keys) {
        byte[][] rawKeys = this.rawKeys(keys);
        this.executeWithoutResult(connection -> connection.watch(rawKeys));
    }

    @Override
    public void unwatch() {
        this.executeWithoutResult(RedisTxCommands::unwatch);
    }

    @Override
    public void multi() {
        this.executeWithoutResult(RedisTxCommands::multi);
    }

    @Override
    public void discard() {
        this.executeWithoutResult(RedisTxCommands::discard);
    }

    @Override
    public List<Object> exec() {
        List<Object> results = this.execRaw();
        if (this.getRequiredConnectionFactory().getConvertPipelineAndTxResults()) {
            return this.deserializeMixedResults(results, this.valueSerializer, this.hashKeySerializer, this.hashValueSerializer);
        }
        return results;
    }

    @Override
    public List<Object> exec(RedisSerializer<?> valueSerializer) {
        return this.deserializeMixedResults(this.execRaw(), valueSerializer, valueSerializer, valueSerializer);
    }

    protected List<Object> execRaw() {
        List raw = this.execute(RedisTxCommands::exec);
        return raw == null ? Collections.emptyList() : raw;
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        return this.execute(RedisServerCommands::getClientList);
    }

    @Override
    public void killClient(String host, int port) {
        this.executeWithoutResult(connection -> connection.killClient(host, port));
    }

    @Override
    public void replicaOf(String host, int port) {
        this.executeWithoutResult(connection -> connection.replicaOf(host, port));
    }

    @Override
    public void replicaOfNoOne() {
        this.executeWithoutResult(RedisServerCommands::replicaOfNoOne);
    }

    @Override
    public Long convertAndSend(String channel, Object message) {
        Assert.hasText((String)channel, (String)"a non-empty channel is required");
        byte[] rawChannel = this.rawString(channel);
        byte[] rawMessage = this.rawValue(message);
        return this.execute(connection -> connection.publish(rawChannel, rawMessage), true);
    }

    private void executeWithoutResult(Consumer<RedisConnection> action) {
        this.execute(it -> {
            action.accept(it);
            return null;
        }, true);
    }

    @Override
    public ClusterOperations<K, V> opsForCluster() {
        return this.clusterOps;
    }

    @Override
    public GeoOperations<K, V> opsForGeo() {
        return this.geoOps;
    }

    @Override
    public BoundGeoOperations<K, V> boundGeoOps(K key) {
        return this.boundOperations.createProxy(BoundGeoOperations.class, key, DataType.ZSET, this, RedisOperations::opsForGeo);
    }

    @Override
    public <HK, HV> BoundHashOperations<K, HK, HV> boundHashOps(K key) {
        return this.boundOperations.createProxy(BoundHashOperations.class, key, DataType.HASH, this, it -> it.opsForHash());
    }

    @Override
    public <HK, HV> HashOperations<K, HK, HV> opsForHash() {
        return new DefaultHashOperations(this);
    }

    @Override
    public HyperLogLogOperations<K, V> opsForHyperLogLog() {
        return this.hllOps;
    }

    @Override
    public ListOperations<K, V> opsForList() {
        return this.listOps;
    }

    @Override
    public BoundListOperations<K, V> boundListOps(K key) {
        return this.boundOperations.createProxy(BoundListOperations.class, key, DataType.LIST, this, RedisOperations::opsForList);
    }

    @Override
    public BoundSetOperations<K, V> boundSetOps(K key) {
        return this.boundOperations.createProxy(BoundSetOperations.class, key, DataType.SET, this, RedisOperations::opsForSet);
    }

    @Override
    public SetOperations<K, V> opsForSet() {
        return this.setOps;
    }

    @Override
    public <HK, HV> StreamOperations<K, HK, HV> opsForStream() {
        return this.streamOps;
    }

    @Override
    public <HK, HV> StreamOperations<K, HK, HV> opsForStream(HashMapper<? super K, ? super HK, ? super HV> hashMapper) {
        return new DefaultStreamOperations<K, HK, HV>(this, hashMapper);
    }

    @Override
    public <HK, HV> BoundStreamOperations<K, HK, HV> boundStreamOps(K key) {
        return this.boundOperations.createProxy(BoundStreamOperations.class, key, DataType.STREAM, this, it -> this.opsForStream());
    }

    @Override
    public BoundValueOperations<K, V> boundValueOps(K key) {
        return this.boundOperations.createProxy(BoundValueOperations.class, key, DataType.STRING, this, RedisOperations::opsForValue);
    }

    @Override
    public ValueOperations<K, V> opsForValue() {
        return this.valueOps;
    }

    @Override
    public BoundZSetOperations<K, V> boundZSetOps(K key) {
        return this.boundOperations.createProxy(BoundZSetOperations.class, key, DataType.ZSET, this, RedisOperations::opsForZSet);
    }

    @Override
    public ZSetOperations<K, V> opsForZSet() {
        return this.zSetOps;
    }

    private byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        if (this.keySerializer == null && key instanceof byte[]) {
            byte[] bytes = (byte[])key;
            return bytes;
        }
        return this.keySerializer.serialize(key);
    }

    private byte[] rawString(String key) {
        return this.stringSerializer.serialize(key);
    }

    private byte[] rawValue(Object value) {
        if (this.valueSerializer == null && value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes;
        }
        return this.valueSerializer.serialize(value);
    }

    private byte[][] rawKeys(Collection<K> keys) {
        byte[][] rawKeys = new byte[keys.size()][];
        int i = 0;
        for (K key : keys) {
            rawKeys[i++] = this.rawKey(key);
        }
        return rawKeys;
    }

    private K deserializeKey(byte[] value) {
        return (K)(this.keySerializer != null ? (Object)this.keySerializer.deserialize(value) : value);
    }

    @Nullable
    private List<Object> deserializeMixedResults(@Nullable List<Object> rawValues, @Nullable RedisSerializer valueSerializer, @Nullable RedisSerializer hashKeySerializer, @Nullable RedisSerializer hashValueSerializer) {
        if (rawValues == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object rawValue : rawValues) {
            Map map;
            Set set;
            if (rawValue instanceof byte[]) {
                byte[] bytes = (byte[])rawValue;
                if (valueSerializer != null) {
                    values.add(valueSerializer.deserialize(bytes));
                    continue;
                }
            }
            if (rawValue instanceof List) {
                List list = (List)rawValue;
                values.add(this.deserializeMixedResults(list, valueSerializer, hashKeySerializer, hashValueSerializer));
                continue;
            }
            if (rawValue instanceof Set && !(set = (Set)rawValue).isEmpty()) {
                values.add(this.deserializeSet(set, valueSerializer));
                continue;
            }
            if (rawValue instanceof Map && !(map = (Map)rawValue).isEmpty() && map.values().iterator().next() instanceof byte[]) {
                values.add(SerializationUtils.deserialize(map, hashKeySerializer, hashValueSerializer));
                continue;
            }
            values.add(rawValue);
        }
        return values;
    }

    private Set<?> deserializeSet(Set rawSet, @Nullable RedisSerializer valueSerializer) {
        if (rawSet.isEmpty()) {
            return rawSet;
        }
        Object setValue = rawSet.iterator().next();
        if (setValue instanceof byte[] && valueSerializer != null) {
            return SerializationUtils.deserialize(rawSet, valueSerializer);
        }
        if (setValue instanceof Tuple) {
            return this.convertTupleValues(rawSet, valueSerializer);
        }
        return rawSet;
    }

    private Set<ZSetOperations.TypedTuple<V>> convertTupleValues(Set<Tuple> rawValues, @Nullable RedisSerializer valueSerializer) {
        LinkedHashSet<ZSetOperations.TypedTuple<V>> set = new LinkedHashSet<ZSetOperations.TypedTuple<V>>(rawValues.size());
        for (Tuple rawValue : rawValues) {
            Object value = rawValue.getValue();
            if (valueSerializer != null) {
                value = valueSerializer.deserialize(rawValue.getValue());
            }
            set.add(new DefaultTypedTuple<byte[]>((byte[])value, rawValue.getScore()));
        }
        return set;
    }
}

