/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.listener;

import org.springframework.data.redis.listener.Topic;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PatternTopic
implements Topic {
    private final String channelPattern;

    public PatternTopic(String pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        this.channelPattern = pattern;
    }

    public static PatternTopic of(String pattern) {
        return new PatternTopic(pattern);
    }

    @Override
    public String getTopic() {
        return this.channelPattern;
    }

    public String toString() {
        return this.channelPattern;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternTopic that = (PatternTopic)o;
        return ObjectUtils.nullSafeEquals((Object)this.channelPattern, (Object)that.channelPattern);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.channelPattern);
    }
}

