/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.MapScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceHashCommands
implements RedisHashCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hset((Object)key, (Object)field, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hset((Object)key, (Object)field, (Object)value)));
                return null;
            }
            return this.getConnection().hset((Object)key, (Object)field, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hsetnx((Object)key, (Object)field, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hsetnx((Object)key, (Object)field, (Object)value)));
                return null;
            }
            return this.getConnection().hsetnx((Object)key, (Object)field, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)fields, (String)"Fields must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hdel((Object)key, (Object[])fields)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hdel((Object)key, (Object[])fields)));
                return null;
            }
            return this.getConnection().hdel((Object)key, (Object[])fields);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Fields must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hexists((Object)key, (Object)field)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hexists((Object)key, (Object)field)));
                return null;
            }
            return this.getConnection().hexists((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hget((Object)key, (Object)field)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hget((Object)key, (Object)field)));
                return null;
            }
            return (byte[])this.getConnection().hget((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hgetall((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hgetall((Object)key)));
                return null;
            }
            return this.getConnection().hgetall((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hincrby((Object)key, (Object)field, delta)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hincrby((Object)key, (Object)field, delta)));
                return null;
            }
            return this.getConnection().hincrby((Object)key, (Object)field, delta);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hincrbyfloat((Object)key, (Object)field, delta)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hincrbyfloat((Object)key, (Object)field, delta)));
                return null;
            }
            return this.getConnection().hincrbyfloat((Object)key, (Object)field, delta);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().hkeys((Object)key), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().hkeys((Object)key), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().hkeys((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hlen((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hlen((Object)key)));
                return null;
            }
            return this.getConnection().hlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)fields, (String)"Fields must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().hmget((Object)key, (Object[])fields), LettuceConverters.keyValueListUnwrapper()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().hmget((Object)key, (Object[])fields), LettuceConverters.keyValueListUnwrapper()));
                return null;
            }
            return LettuceConverters.keyValueListUnwrapper().convert(this.getConnection().hmget((Object)key, (Object[])fields));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(hashes, (String)"Hashes must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().hmset((Object)key, hashes)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceStatusResult(this.getAsyncConnection().hmset((Object)key, hashes)));
                return;
            }
            this.getConnection().hmset((Object)key, hashes);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hvals((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hvals((Object)key)));
                return null;
            }
            return this.getConnection().hvals((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return this.hScan(key, 0L, options);
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, long cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, cursorId, options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (LettuceHashCommands.this.isQueueing() || LettuceHashCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'HSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanCursor scanCursor = LettuceHashCommands.this.connection.getScanCursor(cursorId);
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                MapScanCursor mapScanCursor = LettuceHashCommands.this.getConnection().hscan((Object)key, scanCursor, scanArgs);
                String nextCursorId = mapScanCursor.getCursor();
                Map values = mapScanCursor.getMap();
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Long.valueOf(nextCursorId), values.entrySet());
            }

            @Override
            protected void doClose() {
                LettuceHashCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    @Nullable
    public Long hStrLen(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hstrlen((Object)key, (Object)field)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().hstrlen((Object)key, (Object)field)));
                return null;
            }
            return this.getConnection().hstrlen((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    public LettuceHashCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked @NonNull but is null");
        }
        this.connection = connection;
    }
}

