/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.lettuce.LettuceMessageListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;

class LettuceSubscription
extends AbstractSubscription {
    final StatefulRedisPubSubConnection<byte[], byte[]> pubsub;
    private LettuceMessageListener listener;

    LettuceSubscription(MessageListener listener, StatefulRedisPubSubConnection<byte[], byte[]> pubsubConnection) {
        super(listener);
        this.pubsub = pubsubConnection;
        this.listener = new LettuceMessageListener(listener);
        this.pubsub.addListener((RedisPubSubListener)this.listener);
    }

    @Override
    protected void doClose() {
        if (!this.getChannels().isEmpty()) {
            this.pubsub.sync().unsubscribe((Object[])new byte[][]{new byte[0]});
        }
        if (!this.getPatterns().isEmpty()) {
            this.pubsub.sync().punsubscribe((Object[])new byte[][]{new byte[0]});
        }
        this.pubsub.removeListener((RedisPubSubListener)this.listener);
        this.pubsub.close();
    }

    @Override
    protected void doPsubscribe(byte[] ... patterns) {
        this.pubsub.sync().psubscribe((Object[])patterns);
    }

    @Override
    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        this.pubsub.sync().punsubscribe((Object[])patterns);
    }

    @Override
    protected void doSubscribe(byte[] ... channels) {
        this.pubsub.sync().subscribe((Object[])channels);
    }

    @Override
    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        this.pubsub.sync().unsubscribe((Object[])channels);
    }
}

