/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.cluster.SlotHash;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.codec.RedisCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.ClusterNodeResourceProvider;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ClusterTopology;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.BytesRedisCodec;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceExceptionConverter;
import org.springframework.data.redis.connection.util.ByteArraySet;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class LettuceClusterConnection
extends LettuceConnection
implements RedisClusterConnection {
    static final ExceptionTranslationStrategy exceptionConverter = new PassThroughExceptionTranslationStrategy(new LettuceExceptionConverter());
    static final RedisCodec<byte[], byte[]> CODEC = new BytesRedisCodec();
    private final RedisClusterClient clusterClient;
    private ClusterCommandExecutor clusterCommandExecutor;
    private ClusterTopologyProvider topologyProvider;

    public LettuceClusterConnection(RedisClusterClient clusterClient) {
        super(null, 100L, (AbstractRedisClient)clusterClient, null, 0);
        Assert.notNull((Object)clusterClient, (String)"RedisClusterClient must not be null.");
        this.clusterClient = clusterClient;
        this.topologyProvider = new LettuceClusterTopologyProvider(clusterClient);
        this.clusterCommandExecutor = new ClusterCommandExecutor(this.topologyProvider, new LettuceClusterNodeResourceProvider(clusterClient), exceptionConverter);
    }

    public LettuceClusterConnection(RedisClusterClient clusterClient, ClusterCommandExecutor executor) {
        super(null, 100L, (AbstractRedisClient)clusterClient, null, 0);
        Assert.notNull((Object)clusterClient, (String)"RedisClusterClient must not be null.");
        Assert.notNull((Object)executor, (String)"ClusterCommandExecutor must not be null.");
        this.clusterClient = clusterClient;
        this.topologyProvider = new LettuceClusterTopologyProvider(clusterClient);
        this.clusterCommandExecutor = executor;
    }

    @Override
    public Cursor<byte[]> scan(long cursorId, ScanOptions options) {
        throw new InvalidDataAccessApiUsageException("Scan is not supported accros multiple nodes within a cluster.");
    }

    @Override
    public Set<byte[]> keys(final byte[] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        List<List<byte[]>> keysPerNode = this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> connection) {
                return connection.keys((Object)pattern);
            }
        }).resultsAsList();
        HashSet<byte[]> keys = new HashSet<byte[]>();
        for (List list : keysPerNode) {
            keys.addAll(list);
        }
        return keys;
    }

    @Override
    public void flushAll() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.flushall();
            }
        });
    }

    @Override
    public void flushDb() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.flushdb();
            }
        });
    }

    @Override
    public Long dbSize() {
        List<Long> dbSizes = this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.dbsize();
            }
        }).resultsAsList();
        if (CollectionUtils.isEmpty(dbSizes)) {
            return 0L;
        }
        Long size = 0L;
        for (Long value : dbSizes) {
            size = size + value;
        }
        return size;
    }

    @Override
    public Properties info() {
        Properties infos = new Properties();
        List<ClusterCommandExecutor.NodeResult<Properties>> nodeResults = this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<Properties>(){

            @Override
            public Properties doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return LettuceConverters.toProperties(client.info());
            }
        }).getResults();
        for (ClusterCommandExecutor.NodeResult<Properties> nodePorperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : nodePorperties.getValue().entrySet()) {
                infos.put(nodePorperties.getNode().asString() + "." + entry.getKey(), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(final String section) {
        Properties infos = new Properties();
        List<ClusterCommandExecutor.NodeResult<Properties>> nodeResults = this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<Properties>(){

            @Override
            public Properties doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return LettuceConverters.toProperties(client.info(section));
            }
        }).getResults();
        for (ClusterCommandExecutor.NodeResult<Properties> nodePorperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : nodePorperties.getValue().entrySet()) {
                infos.put(nodePorperties.getNode().asString() + "." + entry.getKey(), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(RedisClusterNode node, final String section) {
        return LettuceConverters.toProperties(this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.info(section);
            }
        }, node).getValue());
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        throw new UnsupportedOperationException("MOVE not supported in CLUSTER mode!");
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.noNullElements((Object[])keys, (String)"Keys must not be null or contain null key!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.del(keys);
        }
        long total = 0L;
        for (byte[] key : keys) {
            Long delted = super.del(new byte[][]{key});
            total += delted != null ? delted : 0L;
        }
        return total;
    }

    public Set<RedisClusterNode> clusterGetSlaves(RedisClusterNode master) {
        Assert.notNull((Object)master, (String)"Master must not be null!");
        final RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(master);
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<Set<RedisClusterNode>>(){

            @Override
            public Set<RedisClusterNode> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return LettuceConverters.toSetOfRedisClusterNodes(client.clusterSlaves(nodeToUse.getId()));
            }
        }, master).getValue();
    }

    @Override
    public Integer clusterGetSlotForKey(byte[] key) {
        return SlotHash.getSlot((byte[])key);
    }

    @Override
    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        DirectFieldAccessor accessor = new DirectFieldAccessor((Object)this.clusterClient);
        return LettuceConverters.toRedisClusterNode(((Partitions)accessor.getPropertyValue("partitions")).getPartitionBySlot(slot));
    }

    @Override
    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        return this.clusterGetNodeForSlot(this.clusterGetSlotForKey(key));
    }

    @Override
    public ClusterInfo clusterGetClusterInfo() {
        return this.clusterCommandExecutor.executeCommandOnArbitraryNode(new LettuceClusterCommandCallback<ClusterInfo>(){

            @Override
            public ClusterInfo doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return new ClusterInfo(LettuceConverters.toProperties(client.clusterInfo()));
            }
        }).getValue();
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, final int ... slots) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.clusterAddSlots(slots);
            }
        }, node);
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.clusterAddSlots(node, range.getSlotsArray());
    }

    @Override
    public void clusterDeleteSlots(RedisClusterNode node, final int ... slots) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.clusterDelSlots(slots);
            }
        }, node);
    }

    @Override
    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.clusterDeleteSlots(node, range.getSlotsArray());
    }

    @Override
    public void clusterForget(RedisClusterNode node) {
        ArrayList<RedisClusterNode> nodes = new ArrayList<RedisClusterNode>((Collection<RedisClusterNode>)this.clusterGetNodes());
        final RedisClusterNode nodeToRemove = this.topologyProvider.getTopology().lookup(node);
        nodes.remove(nodeToRemove);
        this.clusterCommandExecutor.executeCommandAsyncOnNodes(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.clusterForget(nodeToRemove.getId());
            }
        }, nodes);
    }

    @Override
    public void clusterMeet(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"Cluster node must not be null for CLUSTER MEET command!");
        Assert.hasText((String)node.getHost(), (String)"Node to meet cluster must have a host!");
        Assert.isTrue((node.getPort() > 0 ? 1 : 0) != 0, (String)"Node to meet cluster must have a port greater 0!");
        this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.clusterMeet(node.getHost(), node.getPort().intValue());
            }
        });
    }

    @Override
    public void clusterSetSlot(RedisClusterNode node, final int slot, final RedisClusterCommands.AddSlots mode) {
        Assert.notNull((Object)node, (String)"Node must not be null.");
        Assert.notNull((Object)((Object)mode), (String)"AddSlots mode must not be null.");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(node);
        final String nodeId = nodeToUse.getId();
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                switch (mode) {
                    case MIGRATING: {
                        return client.clusterSetSlotMigrating(slot, nodeId);
                    }
                    case IMPORTING: {
                        return client.clusterSetSlotImporting(slot, nodeId);
                    }
                    case NODE: {
                        return client.clusterSetSlotNode(slot, nodeId);
                    }
                    case STABLE: {
                        return client.clusterSetSlotStable(slot);
                    }
                }
                throw new InvalidDataAccessApiUsageException("Invalid import mode for cluster slot: " + slot);
            }
        }, node);
    }

    @Override
    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        try {
            return this.getConnection().clusterGetKeysInSlot(slot, count.intValue());
        }
        catch (Exception ex) {
            throw exceptionConverter.translate(ex);
        }
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        try {
            return this.getConnection().clusterCountKeysInSlot(slot);
        }
        catch (Exception ex) {
            throw exceptionConverter.translate(ex);
        }
    }

    @Override
    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        final RedisClusterNode masterNode = this.topologyProvider.getTopology().lookup(master);
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.clusterReplicate(masterNode.getId());
            }
        }, slave);
    }

    @Override
    public String ping() {
        List<String> ping = this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> connection) {
                return LettuceClusterConnection.this.doPing(connection);
            }
        }).resultsAsList();
        for (String result : ping) {
            if (ObjectUtils.nullSafeEquals((Object)"PONG", (Object)result)) continue;
            return "";
        }
        return "PONG";
    }

    @Override
    public String ping(RedisClusterNode node) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return LettuceClusterConnection.this.doPing(client);
            }
        }, node).getValue();
    }

    protected String doPing(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
        if (client instanceof RedisConnection) {
            return ((RedisConnection)client).ping();
        }
        if (client instanceof RedisAsyncConnectionImpl) {
            try {
                return (String)((RedisAsyncConnectionImpl)client).ping().get();
            }
            catch (Exception e) {
                throw exceptionConverter.translate(e);
            }
        }
        throw new DataAccessResourceFailureException("Cannot execute ping using " + client);
    }

    @Override
    public void bgReWriteAof(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.bgrewriteaof();
            }
        }, node);
    }

    @Override
    public void bgSave(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.bgsave();
            }
        }, node);
    }

    @Override
    public Long lastSave(RedisClusterNode node) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.lastsave().getTime();
            }
        }, node).getValue();
    }

    @Override
    public void save(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.save();
            }
        }, node);
    }

    @Override
    public Long dbSize(RedisClusterNode node) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<Long>(){

            @Override
            public Long doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.dbsize();
            }
        }, node).getValue();
    }

    @Override
    public void flushDb(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.flushdb();
            }
        }, node);
    }

    @Override
    public void flushAll(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.flushall();
            }
        }, node);
    }

    @Override
    public Properties info(RedisClusterNode node) {
        return LettuceConverters.toProperties(this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.info();
            }
        }, node).getValue());
    }

    @Override
    public Set<byte[]> keys(RedisClusterNode node, final byte[] pattern) {
        return LettuceConverters.toBytesSet(this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.keys((Object)pattern);
            }
        }, node).getValue());
    }

    @Override
    public byte[] randomKey(RedisClusterNode node) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<byte[]>(){

            @Override
            public byte[] doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return (byte[])client.randomkey();
            }
        }, node).getValue();
    }

    @Override
    public byte[] randomKey() {
        Iterable nodes = this.clusterGetNodes();
        HashSet<RedisClusterNode> inspectedNodes = new HashSet<RedisClusterNode>(nodes.size());
        do {
            RedisClusterNode node = (RedisClusterNode)nodes.get(new Random().nextInt(nodes.size()));
            while (inspectedNodes.contains(node)) {
                node = (RedisClusterNode)nodes.get(new Random().nextInt(nodes.size()));
            }
            inspectedNodes.add(node);
            byte[] key = this.randomKey(node);
            if (key == null || key.length <= 0) continue;
            return key;
        } while (nodes.size() != inspectedNodes.size());
        return null;
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(oldName, newName)) {
            super.rename(oldName, newName);
            return;
        }
        byte[] value = this.dump(oldName);
        if (value != null && value.length > 0) {
            this.restore(newName, 0L, value);
            this.del(new byte[][]{oldName});
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(oldName, newName)) {
            return super.renameNX(oldName, newName);
        }
        byte[] value = this.dump(oldName);
        if (value != null && value.length > 0 && !this.exists(newName).booleanValue()) {
            this.restore(newName, 0L, value);
            this.del(new byte[][]{oldName});
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void shutdown(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<Void>(){

            @Override
            public Void doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                client.shutdown(true);
                return null;
            }
        }, node);
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(key, storeKey)) {
            return super.sort(key, params, storeKey);
        }
        List<byte[]> sorted = this.sort(key, params);
        if (!CollectionUtils.isEmpty(sorted)) {
            byte[][] arr = new byte[sorted.size()][];
            switch (this.type(key)) {
                case SET: {
                    this.sAdd(storeKey, (byte[][])sorted.toArray((T[])arr));
                    return 1L;
                }
                case LIST: {
                    this.lPush(storeKey, (byte[][])sorted.toArray((T[])arr));
                    return 1L;
                }
            }
            throw new IllegalArgumentException("sort and store is only supported for SET and LIST");
        }
        return 0L;
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.mGet(keys);
        }
        return this.clusterCommandExecutor.executeMuliKeyCommand(new LettuceMultiKeyClusterCommandCallback<byte[]>(){

            @Override
            public byte[] doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client, byte[] key) {
                return (byte[])client.get((Object)key);
            }
        }, Arrays.asList(keys)).resultsAsListSortBy(keys);
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuple must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            super.mSet(tuples);
            return;
        }
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            return super.mSetNX(tuples);
        }
        boolean result = true;
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            if (this.setNX(entry.getKey(), entry.getValue()).booleanValue() || !result) continue;
            result = false;
        }
        return result;
    }

    @Override
    public List<byte[]> bLPop(final int timeout, byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.bLPop(timeout, keys);
        }
        List<KeyValue<byte[], byte[]>> resultList = this.clusterCommandExecutor.executeMuliKeyCommand(new LettuceMultiKeyClusterCommandCallback<KeyValue<byte[], byte[]>>(){

            @Override
            public KeyValue<byte[], byte[]> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client, byte[] key) {
                return client.blpop((long)timeout, (Object[])new byte[][]{key});
            }
        }, Arrays.asList(keys)).resultsAsList();
        for (KeyValue<byte[], byte[]> kv : resultList) {
            if (kv == null) continue;
            return LettuceConverters.toBytesList(kv);
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> bRPop(final int timeout, byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.bRPop(timeout, keys);
        }
        List<KeyValue<byte[], byte[]>> resultList = this.clusterCommandExecutor.executeMuliKeyCommand(new LettuceMultiKeyClusterCommandCallback<KeyValue<byte[], byte[]>>(){

            @Override
            public KeyValue<byte[], byte[]> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client, byte[] key) {
                return client.brpop((long)timeout, (Object[])new byte[][]{key});
            }
        }, Arrays.asList(keys)).resultsAsList();
        for (KeyValue<byte[], byte[]> kv : resultList) {
            if (kv == null) continue;
            return LettuceConverters.toBytesList(kv);
        }
        return Collections.emptyList();
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            return super.rPopLPush(srcKey, dstKey);
        }
        byte[] val = this.rPop(srcKey);
        this.lPush(dstKey, new byte[][]{val});
        return val;
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            return super.bRPopLPush(timeout, srcKey, dstKey);
        }
        List<byte[]> val = this.bRPop(timeout, new byte[][]{srcKey});
        if (!CollectionUtils.isEmpty(val)) {
            this.lPush(dstKey, new byte[][]{val.get(1)});
            return val.get(1);
        }
        return null;
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, destKey)) {
            return super.sMove(srcKey, destKey, value);
        }
        if (this.exists(srcKey).booleanValue() && this.sRem(srcKey, new byte[][]{value}) > 0L && !this.sIsMember(destKey, value).booleanValue()) {
            return LettuceConverters.toBoolean(this.sAdd(destKey, new byte[][]{value}));
        }
        return Boolean.FALSE;
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.sInter(keys);
        }
        List<Set<byte[]>> nodeResult = this.clusterCommandExecutor.executeMuliKeyCommand(new LettuceMultiKeyClusterCommandCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client, byte[] key) {
                return client.smembers((Object)key);
            }
        }, Arrays.asList(keys)).resultsAsList();
        ByteArraySet result = null;
        for (Set set : nodeResult) {
            ByteArraySet tmp = new ByteArraySet(set);
            if (result == null) {
                result = tmp;
                continue;
            }
            result.retainAll(tmp);
            if (!result.isEmpty()) continue;
            break;
        }
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result.asRawSet();
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            return super.sInterStore(destKey, keys);
        }
        Set<byte[]> result = this.sInter(keys);
        if (result.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])result.toArray((T[])new byte[result.size()][]));
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.sUnion(keys);
        }
        List<Set<byte[]>> nodeResult = this.clusterCommandExecutor.executeMuliKeyCommand(new LettuceMultiKeyClusterCommandCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client, byte[] key) {
                return client.smembers((Object)key);
            }
        }, Arrays.asList(keys)).resultsAsList();
        ByteArraySet result = new ByteArraySet();
        for (Set set : nodeResult) {
            result.addAll(set);
        }
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result.asRawSet();
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            return super.sUnionStore(destKey, keys);
        }
        Set<byte[]> result = this.sUnion(keys);
        if (result.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])result.toArray((T[])new byte[result.size()][]));
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.sDiff(keys);
        }
        byte[] source = keys[0];
        byte[][] others = (byte[][])Arrays.copyOfRange(keys, 1, keys.length - 1);
        ByteArraySet values = new ByteArraySet(this.sMembers(source));
        List<Set<byte[]>> nodeResult = this.clusterCommandExecutor.executeMuliKeyCommand(new LettuceMultiKeyClusterCommandCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client, byte[] key) {
                return client.smembers((Object)key);
            }
        }, Arrays.asList(others)).resultsAsList();
        if (values.isEmpty()) {
            return Collections.emptySet();
        }
        for (Set set : nodeResult) {
            values.removeAll(set);
        }
        return values.asRawSet();
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            return super.sDiffStore(destKey, keys);
        }
        Set<byte[]> diff = this.sDiff(keys);
        if (diff.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])diff.toArray((T[])new byte[diff.size()][]));
    }

    @Override
    protected RedisAsyncConnection<byte[], byte[]> doGetAsyncDedicatedConnection() {
        return (RedisAsyncConnection)this.clusterClient.connectClusterAsync(CODEC);
    }

    public List<RedisClusterNode> clusterGetNodes() {
        return LettuceConverters.partitionsToClusterNodes(this.clusterClient.getPartitions());
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return super.pfCount(keys);
            }
            catch (Exception ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("All keys must map to same slot for pfcount in cluster mode.");
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destinationKey, sourceKeys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                super.pfMerge(destinationKey, sourceKeys);
                return;
            }
            catch (Exception ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("All keys must map to same slot for pfmerge in cluster mode.");
    }

    @Override
    public void watch(byte[] ... keys) {
        throw new InvalidDataAccessApiUsageException("WATCH is currently not supported in cluster mode.");
    }

    @Override
    public void unwatch() {
        throw new InvalidDataAccessApiUsageException("UNWATCH is currently not supported in cluster mode.");
    }

    @Override
    public void multi() {
        throw new InvalidDataAccessApiUsageException("MULTI is currently not supported in cluster mode.");
    }

    @Override
    public List<String> getConfig(final String pattern) {
        List<ClusterCommandExecutor.NodeResult<List<String>>> mapResult = this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<List<String>>(){

            @Override
            public List<String> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.configGet(pattern);
            }
        }).getResults();
        ArrayList<String> result = new ArrayList<String>();
        for (ClusterCommandExecutor.NodeResult<List<String>> entry : mapResult) {
            String prefix = entry.getNode().asString();
            int i = 0;
            for (String value : entry.getValue()) {
                result.add((i++ % 2 == 0 ? prefix + "." : "") + value);
            }
        }
        return result;
    }

    @Override
    public List<String> getConfig(RedisClusterNode node, final String pattern) {
        return this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<List<String>>(){

            @Override
            public List<String> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.configGet(pattern);
            }
        }, node).getValue();
    }

    @Override
    public void setConfig(final String param, final String value) {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.configSet(param, value);
            }
        });
    }

    @Override
    public void setConfig(RedisClusterNode node, final String param, final String value) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.configSet(param, value);
            }
        }, node);
    }

    @Override
    public void resetConfigStats() {
        this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.configResetstat();
            }
        });
    }

    @Override
    public void resetConfigStats(RedisClusterNode node) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.configResetstat();
            }
        }, node);
    }

    @Override
    public Long time() {
        return this.convertListOfStringToTime(this.clusterCommandExecutor.executeCommandOnArbitraryNode(new LettuceClusterCommandCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.time();
            }
        }).getValue());
    }

    @Override
    public Long time(RedisClusterNode node) {
        return this.convertListOfStringToTime(this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.time();
            }
        }, node).getValue());
    }

    private Long convertListOfStringToTime(List<byte[]> serverTimeInformation) {
        Assert.notEmpty(serverTimeInformation, (String)"Received invalid result from server. Expected 2 items in collection.");
        Assert.isTrue((serverTimeInformation.size() == 2 ? 1 : 0) != 0, (String)("Received invalid number of arguments from redis server. Expected 2 received " + serverTimeInformation.size()));
        return Converters.toTimeMillis(LettuceConverters.toString(serverTimeInformation.get(0)), LettuceConverters.toString(serverTimeInformation.get(1)));
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        List<String> map = this.clusterCommandExecutor.executeCommandOnAllNodes(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.clientList();
            }
        }).resultsAsList();
        ArrayList<RedisClientInfo> result = new ArrayList<RedisClientInfo>();
        for (String infos : map) {
            result.addAll(LettuceConverters.toListOfRedisClientInformation(infos));
        }
        return result;
    }

    @Override
    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        return LettuceConverters.toListOfRedisClientInformation(this.clusterCommandExecutor.executeCommandOnSingleNode(new LettuceClusterCommandCallback<String>(){

            @Override
            public String doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return client.clientList();
            }
        }, node).getValue());
    }

    @Override
    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterSlaveMap() {
        List<ClusterCommandExecutor.NodeResult<Collection<RedisClusterNode>>> nodeResults = this.clusterCommandExecutor.executeCommandAsyncOnNodes(new LettuceClusterCommandCallback<Collection<RedisClusterNode>>(){

            @Override
            public Set<RedisClusterNode> doInCluster(com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> client) {
                return Converters.toSetOfRedisClusterNodes(client.clusterSlaves(client.clusterMyId()));
            }
        }, this.topologyProvider.getTopology().getActiveMasterNodes()).getResults();
        LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>> result = new LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>>();
        for (ClusterCommandExecutor.NodeResult<Collection<RedisClusterNode>> nodeResult : nodeResults) {
            result.put(nodeResult.getNode(), nodeResult.getValue());
        }
        return result;
    }

    static class LettuceClusterTopologyProvider
    implements ClusterTopologyProvider {
        private final RedisClusterClient client;

        public LettuceClusterTopologyProvider(RedisClusterClient client) {
            Assert.notNull((Object)client, (String)"RedisClusterClient must not be null.");
            this.client = client;
        }

        @Override
        public ClusterTopology getTopology() {
            return new ClusterTopology(new LinkedHashSet<RedisClusterNode>(LettuceConverters.partitionsToClusterNodes(this.client.getPartitions())));
        }
    }

    static class LettuceClusterNodeResourceProvider
    implements ClusterNodeResourceProvider {
        private final RedisClusterClient client;

        public LettuceClusterNodeResourceProvider(RedisClusterClient client) {
            this.client = client;
        }

        public com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]> getResourceForSpecificNode(RedisClusterNode node) {
            Assert.notNull((Object)node, (String)"Node must not be null!");
            try {
                com.lambdaworks.redis.RedisClusterConnection connection = this.client.connectCluster(CODEC).getConnection(node.getHost(), node.getPort().intValue());
                return connection;
            }
            catch (RedisException e) {
                if (e.getCause() instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void returnResourceForSpecificNode(RedisClusterNode node, Object resource) {
            com.lambdaworks.redis.RedisClusterConnection connection = (com.lambdaworks.redis.RedisClusterConnection)resource;
            connection.close();
        }
    }

    protected static interface LettuceMultiKeyClusterCommandCallback<T>
    extends ClusterCommandExecutor.MultiKeyClusterCommandCallback<com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]>, T> {
    }

    protected static interface LettuceClusterCommandCallback<T>
    extends ClusterCommandExecutor.ClusterCommandCallback<com.lambdaworks.redis.RedisClusterConnection<byte[], byte[]>, T> {
    }
}

