/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.util.Pool;

public class JedisConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private static final Log log = LogFactory.getLog(JedisConnectionFactory.class);
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy(JedisConverters.exceptionConverter());
    private JedisShardInfo shardInfo;
    private String hostName = "localhost";
    private int port = 6379;
    private int timeout = 2000;
    private String password;
    private boolean usePool = true;
    private JedisPool pool = null;
    private JedisPoolConfig poolConfig = new JedisPoolConfig();
    private int dbIndex = 0;
    private boolean convertPipelineAndTxResults = true;

    public JedisConnectionFactory() {
    }

    public JedisConnectionFactory(JedisShardInfo shardInfo) {
        this.shardInfo = shardInfo;
    }

    public JedisConnectionFactory(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    protected Jedis fetchJedisConnector() {
        try {
            if (this.usePool && this.pool != null) {
                return (Jedis)this.pool.getResource();
            }
            Jedis jedis = new Jedis(this.getShardInfo());
            jedis.connect();
            return jedis;
        }
        catch (Exception ex) {
            throw new RedisConnectionFailureException("Cannot get Jedis connection", ex);
        }
    }

    protected JedisConnection postProcessConnection(JedisConnection connection) {
        return connection;
    }

    public void afterPropertiesSet() {
        if (this.shardInfo == null) {
            this.shardInfo = new JedisShardInfo(this.hostName, this.port);
            if (StringUtils.hasLength((String)this.password)) {
                this.shardInfo.setPassword(this.password);
            }
            if (this.timeout > 0) {
                this.shardInfo.setTimeout(this.timeout);
            }
        }
        if (this.usePool) {
            this.pool = new JedisPool((GenericObjectPoolConfig)this.poolConfig, this.shardInfo.getHost(), this.shardInfo.getPort(), this.shardInfo.getTimeout(), this.shardInfo.getPassword());
        }
    }

    public void destroy() {
        if (this.usePool && this.pool != null) {
            try {
                this.pool.destroy();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot properly close Jedis pool", (Throwable)ex);
            }
            this.pool = null;
        }
    }

    @Override
    public JedisConnection getConnection() {
        Jedis jedis = this.fetchJedisConnector();
        JedisConnection connection = this.usePool ? new JedisConnection(jedis, (Pool<Jedis>)this.pool, this.dbIndex) : new JedisConnection(jedis, null, this.dbIndex);
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return this.postProcessConnection(connection);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public JedisShardInfo getShardInfo() {
        return this.shardInfo;
    }

    public void setShardInfo(JedisShardInfo shardInfo) {
        this.shardInfo = shardInfo;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean getUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean usePool) {
        this.usePool = usePool;
    }

    public JedisPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    @Override
    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }
}

