/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.convert.MapConverter;
import org.springframework.data.redis.connection.convert.SetConverter;
import org.springframework.data.redis.connection.jedis.JedisExceptionConverter;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.util.SafeEncoder;

public abstract class JedisConverters
extends Converters {
    private static final Converter<String, byte[]> STRING_TO_BYTES;
    private static final ListConverter<String, byte[]> STRING_LIST_TO_BYTE_LIST;
    private static final SetConverter<String, byte[]> STRING_SET_TO_BYTE_SET;
    private static final MapConverter<String, byte[]> STRING_MAP_TO_BYTE_MAP;
    private static final SetConverter<Tuple, RedisZSetCommands.Tuple> TUPLE_SET_TO_TUPLE_SET;
    private static final Converter<Exception, DataAccessException> EXCEPTION_CONVERTER;

    public static Converter<String, byte[]> stringToBytes() {
        return STRING_TO_BYTES;
    }

    public static ListConverter<String, byte[]> stringListToByteList() {
        return STRING_LIST_TO_BYTE_LIST;
    }

    public static SetConverter<String, byte[]> stringSetToByteSet() {
        return STRING_SET_TO_BYTE_SET;
    }

    public static MapConverter<String, byte[]> stringMapToByteMap() {
        return STRING_MAP_TO_BYTE_MAP;
    }

    public static SetConverter<Tuple, RedisZSetCommands.Tuple> tupleSetToTupleSet() {
        return TUPLE_SET_TO_TUPLE_SET;
    }

    public static Converter<Exception, DataAccessException> exceptionConverter() {
        return EXCEPTION_CONVERTER;
    }

    public static String[] toStrings(byte[][] source) {
        String[] result = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = SafeEncoder.encode((byte[])source[i]);
        }
        return result;
    }

    public static Set<RedisZSetCommands.Tuple> toTupleSet(Set<Tuple> source) {
        return TUPLE_SET_TO_TUPLE_SET.convert(source);
    }

    public static byte[] toBytes(Integer source) {
        return String.valueOf(source).getBytes();
    }

    public static String toString(byte[] source) {
        return source == null ? null : SafeEncoder.encode((byte[])source);
    }

    public static DataAccessException toDataAccessException(Exception ex) {
        return (DataAccessException)((Object)EXCEPTION_CONVERTER.convert((Object)ex));
    }

    public static BinaryClient.LIST_POSITION toListPosition(RedisListCommands.Position source) {
        Assert.notNull((Object)"list positions are mandatory");
        return RedisListCommands.Position.AFTER.equals((Object)source) ? BinaryClient.LIST_POSITION.AFTER : BinaryClient.LIST_POSITION.BEFORE;
    }

    public static byte[][] toByteArrays(Map<byte[], byte[]> source) {
        byte[][] result = new byte[source.size() * 2][];
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : source.entrySet()) {
            result[index++] = entry.getKey();
            result[index++] = entry.getValue();
        }
        return result;
    }

    public static SortingParams toSortingParams(SortParameters params) {
        SortingParams jedisParams = null;
        if (params != null) {
            Boolean isAlpha;
            SortParameters.Order order;
            SortParameters.Range limit;
            byte[][] getPattern;
            jedisParams = new SortingParams();
            byte[] byPattern = params.getByPattern();
            if (byPattern != null) {
                jedisParams.by(params.getByPattern());
            }
            if ((getPattern = params.getGetPattern()) != null) {
                jedisParams.get(getPattern);
            }
            if ((limit = params.getLimit()) != null) {
                jedisParams.limit((int)limit.getStart(), (int)limit.getCount());
            }
            if ((order = params.getOrder()) != null && order.equals((Object)SortParameters.Order.DESC)) {
                jedisParams.desc();
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                jedisParams.alpha();
            }
        }
        return jedisParams;
    }

    public static BitOP toBitOp(RedisStringCommands.BitOperation bitOp) {
        switch (bitOp) {
            case AND: {
                return BitOP.AND;
            }
            case OR: {
                return BitOP.OR;
            }
            case NOT: {
                return BitOP.NOT;
            }
            case XOR: {
                return BitOP.XOR;
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        EXCEPTION_CONVERTER = new JedisExceptionConverter();
        STRING_TO_BYTES = new Converter<String, byte[]>(){

            public byte[] convert(String source) {
                return source == null ? null : SafeEncoder.encode((String)source);
            }
        };
        STRING_LIST_TO_BYTE_LIST = new ListConverter<String, byte[]>(STRING_TO_BYTES);
        STRING_SET_TO_BYTE_SET = new SetConverter<String, byte[]>(STRING_TO_BYTES);
        STRING_MAP_TO_BYTE_MAP = new MapConverter<String, byte[]>(STRING_TO_BYTES);
        TUPLE_SET_TO_TUPLE_SET = new SetConverter<Tuple, RedisZSetCommands.Tuple>(new Converter<Tuple, RedisZSetCommands.Tuple>(){

            public RedisZSetCommands.Tuple convert(Tuple source) {
                return source != null ? new DefaultTuple(source.getBinaryElement(), source.getScore()) : null;
            }
        });
    }
}

