/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisClient;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.data.redis.connection.lettuce.AuthenticatingRedisClient;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLettucePool
implements LettucePool,
InitializingBean {
    private GenericObjectPool internalPool;
    private RedisClient client;
    private int dbIndex = 0;
    private GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
    private String hostName = "localhost";
    private int port = 6379;
    private String password;
    private long timeout = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);

    public DefaultLettucePool() {
    }

    public DefaultLettucePool(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    public DefaultLettucePool(String hostName, int port, GenericObjectPool.Config poolConfig) {
        this.hostName = hostName;
        this.port = port;
        this.poolConfig = poolConfig;
    }

    public void afterPropertiesSet() {
        this.client = this.password != null ? new AuthenticatingRedisClient(this.hostName, this.port, this.password) : new RedisClient(this.hostName, this.port);
        this.client.setDefaultTimeout(this.timeout, TimeUnit.MILLISECONDS);
        this.internalPool = new GenericObjectPool((PoolableObjectFactory)new LettuceFactory(this.client, this.dbIndex), this.poolConfig);
    }

    @Override
    public RedisAsyncConnection<byte[], byte[]> getResource() {
        try {
            return (RedisAsyncConnection)this.internalPool.borrowObject();
        }
        catch (Exception e) {
            throw new PoolException("Could not get a resource from the pool", e);
        }
    }

    @Override
    public void returnBrokenResource(RedisAsyncConnection<byte[], byte[]> resource) {
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not invalidate the broken resource", e);
        }
    }

    @Override
    public void returnResource(RedisAsyncConnection<byte[], byte[]> resource) {
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not return the resource to the pool", e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.client.shutdown();
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new PoolException("Could not destroy the pool", e);
        }
    }

    @Override
    public RedisClient getClient() {
        return this.client;
    }

    public GenericObjectPool.Config getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(GenericObjectPool.Config poolConfig) {
        this.poolConfig = poolConfig;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private static class LettuceFactory
    extends BasePoolableObjectFactory {
        private final RedisClient client;
        private int dbIndex;

        public LettuceFactory(RedisClient client, int dbIndex) {
            this.client = client;
            this.dbIndex = dbIndex;
        }

        public Object makeObject() throws Exception {
            return this.client.connectAsync(LettuceConnection.CODEC);
        }

        public void activateObject(Object obj) throws Exception {
            if (obj instanceof RedisAsyncConnection) {
                ((RedisAsyncConnection)obj).select(this.dbIndex);
            }
        }

        public void destroyObject(Object obj) throws Exception {
            if (obj instanceof RedisAsyncConnection) {
                try {
                    ((RedisAsyncConnection)obj).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean validateObject(Object obj) {
            if (obj instanceof RedisAsyncConnection) {
                try {
                    ((RedisAsyncConnection)obj).ping();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
    }
}

