/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import com.lambdaworks.redis.pubsub.RedisPubSubListener;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.lettuce.LettuceMessageListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LettuceSubscription
extends AbstractSubscription {
    final RedisPubSubConnection<byte[], byte[]> pubsub;
    private LettuceMessageListener listener;

    LettuceSubscription(MessageListener listener, RedisPubSubConnection<byte[], byte[]> pubsubConnection) {
        super(listener);
        this.pubsub = pubsubConnection;
        this.listener = new LettuceMessageListener(listener);
        this.pubsub.addListener((RedisPubSubListener)this.listener);
    }

    @Override
    protected void doClose() {
        if (!this.getChannels().isEmpty()) {
            this.pubsub.unsubscribe((Object[])new byte[][]{new byte[0]});
        }
        if (!this.getPatterns().isEmpty()) {
            this.pubsub.punsubscribe((Object[])new byte[][]{new byte[0]});
        }
        this.pubsub.removeListener((RedisPubSubListener)this.listener);
        this.pubsub.close();
    }

    @Override
    protected void doPsubscribe(byte[] ... patterns) {
        this.pubsub.psubscribe((Object[])patterns);
    }

    @Override
    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        this.pubsub.punsubscribe((Object[])patterns);
    }

    @Override
    protected void doSubscribe(byte[] ... channels) {
        this.pubsub.subscribe((Object[])channels);
    }

    @Override
    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        this.pubsub.unsubscribe((Object[])channels);
    }
}

