/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.listener.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.adapter.RedisListenerExecutionFailedException;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageListenerAdapter
implements InitializingBean,
MessageListener {
    public static final String ORIGINAL_DEFAULT_LISTENER_METHOD = "handleMessage";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile Object delegate;
    private volatile MethodInvoker invoker;
    private String defaultListenerMethod = "handleMessage";
    private RedisSerializer<?> serializer;
    private RedisSerializer<String> stringSerializer;

    public MessageListenerAdapter() {
        this.initDefaultStrategies();
        this.delegate = this;
    }

    public MessageListenerAdapter(Object delegate) {
        this.initDefaultStrategies();
        this.setDelegate(delegate);
    }

    public MessageListenerAdapter(Object delegate, String defaultListenerMethod) {
        this(delegate);
        this.setDefaultListenerMethod(defaultListenerMethod);
    }

    public void setDelegate(Object delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public void setStringSerializer(RedisSerializer<String> serializer) {
        this.stringSerializer = serializer;
    }

    public void afterPropertiesSet() {
        String methodName = this.getDefaultListenerMethod();
        if (!StringUtils.hasText((String)methodName)) {
            throw new InvalidDataAccessApiUsageException("No default listener method specified: Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method.");
        }
        this.invoker = new MethodInvoker(this.delegate, methodName);
    }

    @Override
    public void onMessage(Message message, byte[] pattern) {
        try {
            if (this.delegate != this && this.delegate instanceof MessageListener) {
                ((MessageListener)this.delegate).onMessage(message, pattern);
                return;
            }
            Object convertedMessage = this.extractMessage(message);
            String convertedChannel = this.stringSerializer.deserialize(pattern);
            Object[] listenerArguments = new Object[]{convertedMessage, convertedChannel};
            this.invokeListenerMethod(this.invoker.getMethodName(), listenerArguments);
        }
        catch (Throwable th) {
            this.handleListenerException(th);
        }
    }

    protected void initDefaultStrategies() {
        StringRedisSerializer serializer = new StringRedisSerializer();
        this.setSerializer(serializer);
        this.setStringSerializer(serializer);
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error((Object)"Listener execution failed", ex);
    }

    protected Object extractMessage(Message message) {
        if (this.serializer != null) {
            return this.serializer.deserialize(message.getBody());
        }
        return message.getBody();
    }

    protected String getListenerMethodName(Message originalMessage, Object extractedMessage) {
        return this.getDefaultListenerMethod();
    }

    protected void invokeListenerMethod(String methodName, Object[] arguments) {
        try {
            this.invoker.invoke(arguments);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof DataAccessException) {
                throw (DataAccessException)targetEx;
            }
            throw new RedisListenerExecutionFailedException("Listener method '" + methodName + "' threw exception", targetEx);
        }
        catch (Throwable ex) {
            throw new RedisListenerExecutionFailedException("Failed to invoke target method '" + methodName + "' with arguments " + ObjectUtils.nullSafeToString((Object[])arguments), ex);
        }
    }

    private class MethodInvoker {
        private final Object delegate;
        private String methodName;
        private List<Method> methods;
        private boolean lenient = false;

        MethodInvoker(Object delegate, final String methodName) {
            this.delegate = delegate;
            this.methodName = methodName;
            this.lenient = delegate instanceof MessageListener;
            Class<?> c = delegate.getClass();
            this.methods = new ArrayList<Method>();
            ReflectionUtils.doWithMethods(c, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    ReflectionUtils.makeAccessible((Method)method);
                    MethodInvoker.this.methods.add(method);
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    if (Modifier.isPublic(method.getModifiers()) && methodName.equals(method.getName())) {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        return parameterTypes.length == 2 && String.class.equals(parameterTypes[1]) || parameterTypes.length == 1;
                    }
                    return false;
                }
            });
            Assert.isTrue((this.lenient || !this.methods.isEmpty() ? 1 : 0) != 0, (String)("Cannot find a suitable method named [" + c.getName() + "#" + methodName + "] - is the method public and has the proper arguments?"));
        }

        void invoke(Object[] arguments) throws InvocationTargetException, IllegalAccessException {
            Object[] message = new Object[]{arguments[0]};
            for (Method m : this.methods) {
                Class<?>[] types = m.getParameterTypes();
                Object[] args = types.length == 2 ? arguments : message;
                m.invoke(this.delegate, args);
            }
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

