/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractOperations<K, V> {
    RedisTemplate<K, V> template;

    AbstractOperations(RedisTemplate<K, V> template) {
        this.template = template;
    }

    RedisSerializer keySerializer() {
        return this.template.getKeySerializer();
    }

    RedisSerializer valueSerializer() {
        return this.template.getValueSerializer();
    }

    RedisSerializer hashKeySerializer() {
        return this.template.getHashKeySerializer();
    }

    RedisSerializer hashValueSerializer() {
        return this.template.getHashValueSerializer();
    }

    RedisSerializer stringSerializer() {
        return this.template.getStringSerializer();
    }

    <T> T execute(RedisCallback<T> callback, boolean b) {
        return this.template.execute(callback, b);
    }

    public RedisOperations<K, V> getOperations() {
        return this.template;
    }

    byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        return this.keySerializer().serialize(key);
    }

    byte[] rawString(String key) {
        return this.stringSerializer().serialize(key);
    }

    byte[] rawValue(Object value) {
        return this.valueSerializer().serialize(value);
    }

    <HK> byte[] rawHashKey(HK hashKey) {
        Assert.notNull(hashKey, (String)"non null hash key required");
        return this.hashKeySerializer().serialize(hashKey);
    }

    <HV> byte[] rawHashValue(HV value) {
        return this.hashValueSerializer().serialize(value);
    }

    byte[][] rawKeys(K key, K otherKey) {
        byte[][] rawKeys = new byte[][]{this.rawKey(key), this.rawKey(key)};
        return rawKeys;
    }

    byte[][] rawKeys(Collection<K> keys) {
        return this.rawKeys((K)null, keys);
    }

    byte[][] rawKeys(K key, Collection<K> keys) {
        byte[][] rawKeys = new byte[keys.size() + (key != null ? 1 : 0)][];
        int i = 0;
        if (key != null) {
            rawKeys[i++] = this.rawKey(key);
        }
        for (K k : keys) {
            rawKeys[i++] = this.rawKey(k);
        }
        return rawKeys;
    }

    Set<V> deserializeValues(Set<byte[]> rawValues) {
        return SerializationUtils.deserialize(rawValues, this.valueSerializer());
    }

    Set<ZSetOperations.TypedTuple<V>> deserializeTupleValues(Set<RedisZSetCommands.Tuple> rawValues) {
        if (rawValues == null) {
            return null;
        }
        LinkedHashSet<ZSetOperations.TypedTuple<V>> set = new LinkedHashSet<ZSetOperations.TypedTuple<V>>(rawValues.size());
        for (RedisZSetCommands.Tuple rawValue : rawValues) {
            set.add(new DefaultTypedTuple(this.valueSerializer().deserialize(rawValue.getValue()), rawValue.getScore()));
        }
        return set;
    }

    List<V> deserializeValues(List<byte[]> rawValues) {
        return SerializationUtils.deserialize(rawValues, this.valueSerializer());
    }

    <T> Set<T> deserializeHashKeys(Set<byte[]> rawKeys) {
        return SerializationUtils.deserialize(rawKeys, this.hashKeySerializer());
    }

    <T> List<T> deserializeHashValues(List<byte[]> rawValues) {
        return SerializationUtils.deserialize(rawValues, this.hashValueSerializer());
    }

    <HK, HV> Map<HK, HV> deserializeHashMap(Map<byte[], byte[]> entries) {
        if (entries == null) {
            return null;
        }
        LinkedHashMap<HK, HV> map = new LinkedHashMap<HK, HV>(entries.size());
        for (Map.Entry<byte[], byte[]> entry : entries.entrySet()) {
            map.put(this.deserializeHashKey(entry.getKey()), this.deserializeHashValue(entry.getValue()));
        }
        return map;
    }

    K deserializeKey(byte[] value) {
        return (K)this.keySerializer().deserialize(value);
    }

    V deserializeValue(byte[] value) {
        return (V)this.valueSerializer().deserialize(value);
    }

    String deserializeString(byte[] value) {
        return (String)this.stringSerializer().deserialize(value);
    }

    <HK> HK deserializeHashKey(byte[] value) {
        return (HK)this.hashKeySerializer().deserialize(value);
    }

    <HV> HV deserializeHashValue(byte[] value) {
        return (HV)this.hashValueSerializer().deserialize(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class ValueDeserializingRedisCallback
    implements RedisCallback<V> {
        private Object key;

        public ValueDeserializingRedisCallback(Object key) {
            this.key = key;
        }

        @Override
        public final V doInRedis(RedisConnection connection) {
            byte[] result = this.inRedis(AbstractOperations.this.rawKey(this.key), connection);
            return AbstractOperations.this.deserializeValue(result);
        }

        protected abstract byte[] inRedis(byte[] var1, RedisConnection var2);
    }
}

