/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.ZStoreArgs;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.Charsets;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.lettuce.BytesRedisCodec;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class LettuceUtils {
    static final RedisCodec<byte[], byte[]> CODEC = new BytesRedisCodec();

    LettuceUtils() {
    }

    static DataAccessException convertRedisAccessException(RuntimeException ex) {
        if (ex instanceof RedisCommandInterruptedException) {
            return new RedisSystemException("Redis command interrupted", ex);
        }
        if (ex instanceof RedisException) {
            return new RedisSystemException("Redis exception", ex);
        }
        return null;
    }

    static Properties info(String reply) {
        if (reply == null) {
            return null;
        }
        Properties info = new Properties();
        StringReader stringReader = new StringReader(reply);
        try {
            info.load(stringReader);
        }
        catch (Exception ex) {
            throw new RedisSystemException("Cannot read Redis info", ex);
        }
        finally {
            stringReader.close();
        }
        return info;
    }

    static int asBit(boolean value) {
        return value ? 1 : 0;
    }

    static boolean convertPosition(RedisListCommands.Position where) {
        Assert.notNull((Object)"list positions are mandatory");
        return !RedisListCommands.Position.AFTER.equals((Object)where);
    }

    static Set<RedisZSetCommands.Tuple> convertTuple(List<ScoredValue<byte[]>> zrange) {
        if (zrange == null) {
            return null;
        }
        LinkedHashSet<RedisZSetCommands.Tuple> tuples = new LinkedHashSet<RedisZSetCommands.Tuple>(zrange.size());
        for (int i = 0; i < zrange.size(); ++i) {
            tuples.add(new DefaultTuple((byte[])zrange.get((int)i).value, zrange.get((int)i).score));
        }
        return tuples;
    }

    static SortArgs sort(SortParameters params) {
        Boolean isAlpha;
        SortArgs args = new SortArgs();
        if (params.getByPattern() != null) {
            args.by(new String(params.getByPattern(), Charsets.ASCII));
        }
        if (params.getLimit() != null) {
            args.limit(params.getLimit().getStart(), params.getLimit().getCount());
        }
        if (params.getGetPattern() != null) {
            byte[][] pattern;
            for (byte[] bs : pattern = params.getGetPattern()) {
                args.get(new String(bs, Charsets.ASCII));
            }
        }
        if (params.getOrder() != null) {
            if (params.getOrder() == SortParameters.Order.ASC) {
                args.asc();
            } else {
                args.desc();
            }
        }
        if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
            args.alpha();
        }
        return args;
    }

    static ZStoreArgs zArgs(RedisZSetCommands.Aggregate aggregate, int[] weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        long[] lg = new long[weights.length];
        for (int i = 0; i < lg.length; ++i) {
            lg[i] = weights[i];
        }
        args.weights(lg);
        return args;
    }

    static List<byte[]> toList(KeyValue<byte[], byte[]> blpop) {
        if (blpop == null) {
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>(2);
        list.add((byte[])blpop.key);
        list.add((byte[])blpop.value);
        return list;
    }
}

