/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.serializer.RedisSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RedisOperations<K, V> {
    public <T> T execute(RedisCallback<T> var1);

    public <T> T execute(SessionCallback<T> var1);

    public Boolean hasKey(K var1);

    public void delete(K var1);

    public void delete(Collection<K> var1);

    public DataType type(K var1);

    public Set<K> keys(K var1);

    public K randomKey();

    public void rename(K var1, K var2);

    public Boolean renameIfAbsent(K var1, K var2);

    public Boolean expire(K var1, long var2, TimeUnit var4);

    public Boolean expireAt(K var1, Date var2);

    public Boolean persist(K var1);

    public Boolean move(K var1, int var2);

    public Long getExpire(K var1);

    public void watch(K var1);

    public void watch(Collection<K> var1);

    public void unwatch();

    public void multi();

    public void discard();

    public List<Object> exec();

    public Long convertAndSend(String var1, Object var2);

    public ValueOperations<K, V> opsForValue();

    public BoundValueOperations<K, V> boundValueOps(K var1);

    public ListOperations<K, V> opsForList();

    public BoundListOperations<K, V> boundListOps(K var1);

    public SetOperations<K, V> opsForSet();

    public BoundSetOperations<K, V> boundSetOps(K var1);

    public ZSetOperations<K, V> opsForZSet();

    public BoundZSetOperations<K, V> boundZSetOps(K var1);

    public <HK, HV> HashOperations<K, HK, HV> opsForHash();

    public <HK, HV> BoundHashOperations<K, HK, HV> boundHashOps(K var1);

    public List<V> sort(SortQuery<K> var1);

    public <T> List<T> sort(SortQuery<K> var1, RedisSerializer<T> var2);

    public <T> List<T> sort(SortQuery<K> var1, BulkMapper<T, V> var2);

    public <T, S> List<T> sort(SortQuery<K> var1, BulkMapper<T, S> var2, RedisSerializer<S> var3);

    public Long sort(SortQuery<K> var1, K var2);

    public RedisSerializer<?> getValueSerializer();

    public RedisSerializer<?> getKeySerializer();
}

