/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisClient;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceUtils;

public class LettuceConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private String hostName = "localhost";
    private int port = 6379;
    private RedisClient client;
    private long timeout = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);

    public LettuceConnectionFactory() {
    }

    public LettuceConnectionFactory(String host, int port) {
        this.hostName = host;
        this.port = port;
    }

    public void afterPropertiesSet() {
        this.client = new RedisClient(this.hostName, this.port);
        this.client.setDefaultTimeout(this.timeout, TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        this.client.shutdown();
    }

    public RedisConnection getConnection() {
        return new LettuceConnection((RedisAsyncConnection<byte[], byte[]>)this.client.connectAsync(LettuceUtils.CODEC), this.timeout, this.client);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return LettuceUtils.convertRedisAccessException(ex);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

