/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Set;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.DefaultBoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ZSetOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultBoundZSetOperations<K, V>
extends DefaultBoundKeyOperations<K>
implements BoundZSetOperations<K, V> {
    private final ZSetOperations<K, V> ops;

    public DefaultBoundZSetOperations(K key, RedisOperations<K, V> operations) {
        super(key, operations);
        this.ops = operations.opsForZSet();
    }

    @Override
    public Boolean add(V value, double score) {
        return this.ops.add(this.getKey(), value, score);
    }

    @Override
    public Double incrementScore(V value, double delta) {
        return this.ops.incrementScore(this.getKey(), value, delta);
    }

    @Override
    public RedisOperations<K, V> getOperations() {
        return this.ops.getOperations();
    }

    @Override
    public void intersectAndStore(K destKey, K otherKey) {
        this.ops.intersectAndStore(this.getKey(), otherKey, destKey);
    }

    @Override
    public void intersectAndStore(Collection<K> otherKeys, K destKey) {
        this.ops.intersectAndStore(this.getKey(), otherKeys, destKey);
    }

    @Override
    public Set<V> range(long start, long end) {
        return this.ops.range(this.getKey(), start, end);
    }

    @Override
    public Set<V> rangeByScore(double min, double max) {
        return this.ops.rangeByScore(this.getKey(), min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(double min, double max) {
        return this.ops.rangeByScoreWithScores(this.getKey(), min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeWithScores(long start, long end) {
        return this.ops.rangeWithScores(this.getKey(), start, end);
    }

    @Override
    public Set<V> reverseRangeByScore(double min, double max) {
        return this.ops.reverseRangeByScore(this.getKey(), min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(double min, double max) {
        return this.ops.reverseRangeByScoreWithScores(this.getKey(), min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(long start, long end) {
        return this.ops.reverseRangeWithScores(this.getKey(), start, end);
    }

    @Override
    public Long rank(Object o) {
        return this.ops.rank(this.getKey(), o);
    }

    @Override
    public Long reverseRank(Object o) {
        return this.ops.reverseRank(this.getKey(), o);
    }

    @Override
    public Double score(Object o) {
        return this.ops.score(this.getKey(), o);
    }

    @Override
    public Boolean remove(Object o) {
        return this.ops.remove(this.getKey(), o);
    }

    @Override
    public void removeRange(long start, long end) {
        this.ops.removeRange(this.getKey(), start, end);
    }

    @Override
    public void removeRangeByScore(double min, double max) {
        this.ops.removeRangeByScore(this.getKey(), min, max);
    }

    @Override
    public Set<V> reverseRange(long start, long end) {
        return this.ops.reverseRange(this.getKey(), start, end);
    }

    @Override
    public Long count(double min, double max) {
        return this.ops.count(this.getKey(), min, max);
    }

    @Override
    public Long size() {
        return this.ops.size(this.getKey());
    }

    @Override
    public void unionAndStore(K otherKey, K destKey) {
        this.ops.unionAndStore(this.getKey(), otherKey, destKey);
    }

    @Override
    public void unionAndStore(Collection<K> otherKeys, K destKey) {
        this.ops.unionAndStore(this.getKey(), otherKeys, destKey);
    }

    @Override
    public DataType getType() {
        return DataType.ZSET;
    }
}

