/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.mapping;

import org.springframework.core.KotlinDetector;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.r2dbc.mapping.R2dbcSimpleTypeHolder;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.util.KotlinReflectionUtils;

public class R2dbcMappingContext
extends RelationalMappingContext {
    public R2dbcMappingContext() {
    }

    public R2dbcMappingContext(NamingStrategy namingStrategy) {
        super(namingStrategy);
    }

    public static R2dbcMappingContext forPlainIdentifiers() {
        R2dbcMappingContext context = R2dbcMappingContext.forQuotedIdentifiers();
        context.setForceQuote(false);
        return context;
    }

    public static R2dbcMappingContext forPlainIdentifiers(NamingStrategy namingStrategy) {
        R2dbcMappingContext context = R2dbcMappingContext.forQuotedIdentifiers(namingStrategy);
        context.setForceQuote(false);
        return context;
    }

    public static R2dbcMappingContext forQuotedIdentifiers() {
        return new R2dbcMappingContext();
    }

    public static R2dbcMappingContext forQuotedIdentifiers(NamingStrategy namingStrategy) {
        return new R2dbcMappingContext(namingStrategy);
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        if (R2dbcSimpleTypeHolder.HOLDER.isSimpleType(type.getType())) {
            return false;
        }
        return !KotlinDetector.isKotlinType((Class)type.getType()) || KotlinReflectionUtils.isSupportedKotlinClass((Class)type.getType());
    }
}

