/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.r2dbc.repository.Modifying;
import org.springframework.data.r2dbc.repository.Query;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.Lock;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.relational.repository.query.SimpleRelationalEntityMetadata;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class R2dbcQueryMethod
extends QueryMethod {
    private static final TypeInformation<Page> PAGE_TYPE = TypeInformation.of(Page.class);
    private static final TypeInformation<Slice> SLICE_TYPE = TypeInformation.of(Slice.class);
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    private final Optional<Query> query;
    private final boolean modifying;
    private final Lazy<Boolean> isCollectionQuery;
    private final Optional<Lock> lock;
    @Nullable
    private RelationalEntityMetadata<?> metadata;

    public R2dbcQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        super(method, metadata, projectionFactory, RelationalParameters::new);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        this.mappingContext = mappingContext;
        if (ReflectionUtils.hasParameterOfType((Method)method, Pageable.class)) {
            boolean singleWrapperWithWrappedPageableResult;
            TypeInformation returnType = TypeInformation.fromReturnTypeOf((Method)method);
            boolean multiWrapper = ReactiveWrappers.isMultiValueType((Class)returnType.getType());
            boolean bl = singleWrapperWithWrappedPageableResult = ReactiveWrappers.isSingleValueType((Class)returnType.getType()) && (PAGE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()) || SLICE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()));
            if (singleWrapperWithWrappedPageableResult) {
                throw new InvalidDataAccessApiUsageException(String.format("'%s.%s' must not use sliced or paged execution; Please use Flux.buffer(size, skip)", ClassUtils.getShortName(method.getDeclaringClass()), method.getName()));
            }
            if (!multiWrapper) {
                throw new IllegalStateException(String.format("Method has to use a either multi-item reactive wrapper return type or a wrapped Page/Slice type; Offending method: %s", method.toString()));
            }
            if (ReflectionUtils.hasParameterOfType((Method)method, Sort.class)) {
                throw new IllegalStateException(String.format("Method must not have Pageable *and* Sort parameter; Use sorting capabilities on Pageable instead; Offending method: %s", method.toString()));
            }
        }
        this.query = Optional.ofNullable((Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class));
        this.modifying = AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Modifying.class);
        this.isCollectionQuery = Lazy.of(() -> !this.isPageQuery() && !this.isSliceQuery() && ReactiveWrappers.isMultiValueType((Class)metadata.getReturnType(method).getType()) || super.isCollectionQuery());
        this.lock = Optional.ofNullable((Lock)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Lock.class));
    }

    public boolean isCollectionQuery() {
        return (Boolean)this.isCollectionQuery.get();
    }

    public boolean isModifyingQuery() {
        return this.modifying;
    }

    public boolean hasLockMode() {
        return this.lock.isPresent();
    }

    Optional<Lock> getLock() {
        return this.lock;
    }

    public boolean isStreamQuery() {
        return true;
    }

    public RelationalEntityMetadata<?> getEntityInformation() {
        if (this.metadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType) || ReflectionUtils.isVoid((Class)returnedObjectType)) {
                this.metadata = new SimpleRelationalEntityMetadata(domainClass, (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass));
            } else {
                RelationalPersistentEntity returnedEntity = (RelationalPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                RelationalPersistentEntity managedEntity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                RelationalPersistentEntity tableEntity = domainClass.isAssignableFrom(returnedObjectType) ? returnedEntity : managedEntity;
                this.metadata = new SimpleRelationalEntityMetadata(returnedEntity.getType(), tableEntity);
            }
        }
        return this.metadata;
    }

    public RelationalParameters getParameters() {
        return (RelationalParameters)super.getParameters();
    }

    public boolean hasReactiveWrapperParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (!ReactiveWrapperConverters.supports((Class)parameter.getType())) continue;
            return true;
        }
        return false;
    }

    public String getRequiredAnnotatedQuery() {
        return this.query.map(Query::value).orElseThrow(() -> new IllegalStateException("Query method " + String.valueOf((Object)this) + " has no annotated query"));
    }

    Optional<Query> getQueryAnnotation() {
        return this.query;
    }

    public boolean hasAnnotatedQuery() {
        return this.getQueryAnnotation().isPresent();
    }
}

