/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.query;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.query.BoundCondition;
import org.springframework.data.relational.core.dialect.Escaper;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.ValueFunction;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.AsteriskFromTable;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.domain.SqlSort;
import org.springframework.data.util.Pair;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.binding.BindMarker;
import org.springframework.r2dbc.core.binding.BindMarkers;
import org.springframework.r2dbc.core.binding.Bindings;
import org.springframework.r2dbc.core.binding.MutableBindings;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class QueryMapper {
    private final R2dbcConverter converter;
    private final R2dbcDialect dialect;
    private final MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;

    public QueryMapper(R2dbcDialect dialect, R2dbcConverter converter) {
        Assert.notNull((Object)converter, (String)"R2dbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"R2dbcDialect must not be null");
        this.converter = converter;
        this.dialect = dialect;
        this.mappingContext = converter.getMappingContext();
    }

    public String toSql(SqlIdentifier identifier) {
        Assert.notNull((Object)identifier, (String)"SqlIdentifier must not be null");
        return identifier.toSql(this.dialect.getIdentifierProcessing());
    }

    @Deprecated(since="3.2", forRemoval=true)
    public Sort getMappedObject(Sort sort, @Nullable RelationalPersistentEntity<?> entity) {
        if (entity == null) {
            return sort;
        }
        ArrayList<Sort.Order> mappedOrder = new ArrayList<Sort.Order>();
        for (Sort.Order order : sort) {
            SqlSort.validate((Sort.Order)order);
            Field field = this.createPropertyField(entity, SqlIdentifier.unquoted((String)order.getProperty()), this.mappingContext);
            mappedOrder.add(Sort.Order.by((String)this.toSql(field.getMappedColumnName())).with(order.getNullHandling()).with(order.getDirection()));
        }
        return Sort.by(mappedOrder);
    }

    public List<OrderByField> getMappedSort(Table table, Sort sort, @Nullable RelationalPersistentEntity<?> entity) {
        ArrayList<OrderByField> mappedOrder = new ArrayList<OrderByField>();
        for (Sort.Order order : sort) {
            SqlSort.validate((Sort.Order)order);
            OrderByField simpleOrderByField = this.createSimpleOrderByField(table, entity, order);
            OrderByField orderBy = simpleOrderByField.withNullHandling(order.getNullHandling());
            mappedOrder.add(order.isAscending() ? orderBy.asc() : orderBy.desc());
        }
        return mappedOrder;
    }

    private OrderByField createSimpleOrderByField(Table table, RelationalPersistentEntity<?> entity, Sort.Order order) {
        SqlSort.SqlOrder sqlOrder;
        if (order instanceof SqlSort.SqlOrder && (sqlOrder = (SqlSort.SqlOrder)order).isUnsafe()) {
            return OrderByField.from((Expression)Expressions.just((String)sqlOrder.getProperty()));
        }
        Field field = this.createPropertyField(entity, SqlIdentifier.unquoted((String)order.getProperty()), this.mappingContext);
        return OrderByField.from((Expression)table.column(field.getMappedColumnName()));
    }

    public Expression getMappedObject(Expression expression, @Nullable RelationalPersistentEntity<?> entity) {
        if (entity == null || expression instanceof AsteriskFromTable || expression instanceof Expressions.SimpleExpression) {
            return expression;
        }
        if (expression instanceof Column) {
            Column column = (Column)expression;
            Field field = this.createPropertyField(entity, column.getName());
            TableLike table = column.getTable();
            Column columnFromTable = table.column(field.getMappedColumnName());
            return column instanceof Aliased ? columnFromTable.as(((Aliased)column).getAlias()) : columnFromTable;
        }
        if (expression instanceof SimpleFunction) {
            SimpleFunction function = (SimpleFunction)expression;
            List arguments = function.getExpressions();
            ArrayList<Expression> mappedArguments = new ArrayList<Expression>(arguments.size());
            for (Expression argument : arguments) {
                mappedArguments.add(this.getMappedObject(argument, entity));
            }
            SimpleFunction mappedFunction = SimpleFunction.create((String)function.getFunctionName(), mappedArguments);
            return function instanceof Aliased ? mappedFunction.as(((Aliased)function).getAlias()) : mappedFunction;
        }
        throw new IllegalArgumentException(String.format("Cannot map %s", expression));
    }

    public BoundCondition getMappedObject(BindMarkers markers, CriteriaDefinition criteria, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Assert.notNull((Object)markers, (String)"BindMarkers must not be null");
        Assert.notNull((Object)criteria, (String)"CriteriaDefinition must not be null");
        Assert.notNull((Object)table, (String)"Table must not be null");
        MutableBindings bindings = new MutableBindings(markers);
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Cannot map empty Criteria");
        }
        Condition mapped = this.unroll(criteria, table, entity, bindings);
        return new BoundCondition((Bindings)bindings, mapped);
    }

    @Deprecated
    public BoundCondition getMappedObject(BindMarkers markers, Criteria criteria, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Assert.notNull((Object)markers, (String)"BindMarkers must not be null");
        Assert.notNull((Object)criteria, (String)"Criteria must not be null");
        Assert.notNull((Object)table, (String)"Table must not be null");
        MutableBindings bindings = new MutableBindings(markers);
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Cannot map empty Criteria");
        }
        Condition mapped = this.unroll((CriteriaDefinition)criteria, table, entity, bindings);
        return new BoundCondition((Bindings)bindings, mapped);
    }

    private Condition unroll(CriteriaDefinition criteria, Table table, @Nullable RelationalPersistentEntity<?> entity, MutableBindings bindings) {
        CriteriaDefinition current = criteria;
        HashMap<CriteriaDefinition, CriteriaDefinition> forwardChain = new HashMap<CriteriaDefinition, CriteriaDefinition>();
        while (current.hasPrevious()) {
            forwardChain.put(current.getPrevious(), current);
            current = current.getPrevious();
        }
        Condition mapped = this.getCondition(current, bindings, table, entity);
        while (forwardChain.containsKey(current)) {
            CriteriaDefinition criterion = (CriteriaDefinition)forwardChain.get(current);
            Condition result = null;
            Condition condition = this.getCondition(criterion, bindings, table, entity);
            if (condition != null) {
                result = this.combine(criterion, mapped, criterion.getCombinator(), condition);
            }
            if (result != null) {
                mapped = result;
            }
            current = criterion;
        }
        if (mapped == null) {
            throw new IllegalStateException("Cannot map empty Criteria");
        }
        return mapped;
    }

    @Nullable
    private Condition unrollGroup(List<? extends CriteriaDefinition> criteria, Table table, CriteriaDefinition.Combinator combinator, @Nullable RelationalPersistentEntity<?> entity, MutableBindings bindings) {
        Condition mapped = null;
        for (CriteriaDefinition criteriaDefinition : criteria) {
            if (criteriaDefinition.isEmpty()) continue;
            Condition condition = this.unroll(criteriaDefinition, table, entity, bindings);
            mapped = this.combine(criteriaDefinition, mapped, combinator, condition);
        }
        return mapped;
    }

    @Nullable
    private Condition getCondition(CriteriaDefinition criteria, MutableBindings bindings, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        if (criteria.isEmpty()) {
            return null;
        }
        if (criteria.isGroup()) {
            Condition condition = this.unrollGroup(criteria.getGroup(), table, criteria.getCombinator(), entity, bindings);
            return condition == null ? null : Conditions.nest((Condition)condition);
        }
        return this.mapCondition(criteria, bindings, table, entity);
    }

    private Condition combine(CriteriaDefinition criteria, @Nullable Condition currentCondition, CriteriaDefinition.Combinator combinator, Condition nextCondition) {
        if (currentCondition == null) {
            currentCondition = nextCondition;
        } else if (combinator == CriteriaDefinition.Combinator.INITIAL) {
            currentCondition = currentCondition.and(Conditions.nest((Condition)nextCondition));
        } else if (combinator == CriteriaDefinition.Combinator.AND) {
            currentCondition = currentCondition.and(nextCondition);
        } else if (combinator == CriteriaDefinition.Combinator.OR) {
            currentCondition = currentCondition.or(nextCondition);
        } else {
            throw new IllegalStateException("Combinator " + String.valueOf(combinator) + " not supported");
        }
        return currentCondition;
    }

    private Condition mapCondition(CriteriaDefinition criteria, MutableBindings bindings, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Class typeHint;
        Object mappedValue;
        Field propertyField = this.createPropertyField(entity, criteria.getColumn(), this.mappingContext);
        Column column = table.column(propertyField.getMappedColumnName());
        TypeInformation actualType = propertyField.getTypeHint().getRequiredActualType();
        CriteriaDefinition.Comparator comparator = criteria.getComparator();
        Object object = criteria.getValue();
        if (object instanceof Parameter) {
            Parameter parameter = (Parameter)object;
            mappedValue = this.convertValue(comparator, parameter.getValue(), propertyField.getTypeHint());
            typeHint = this.getTypeHint(mappedValue, actualType.getType(), parameter);
        } else {
            object = criteria.getValue();
            if (object instanceof ValueFunction) {
                ValueFunction valueFunction = (ValueFunction)object;
                mappedValue = valueFunction.map(v -> this.convertValue(comparator, v, propertyField.getTypeHint())).apply(this.getEscaper(comparator));
                typeHint = actualType.getType();
            } else {
                mappedValue = this.convertValue(comparator, criteria.getValue(), propertyField.getTypeHint());
                typeHint = actualType.getType();
            }
        }
        return this.createCondition(column, mappedValue, typeHint, bindings, comparator, criteria.isIgnoreCase());
    }

    private Escaper getEscaper(CriteriaDefinition.Comparator comparator) {
        if (comparator == CriteriaDefinition.Comparator.LIKE || comparator == CriteriaDefinition.Comparator.NOT_LIKE) {
            return this.dialect.getLikeEscaper();
        }
        return Escaper.DEFAULT;
    }

    public Parameter getBindValue(Parameter value) {
        if (value.isEmpty()) {
            return Parameter.empty(this.converter.getTargetType(value.getType()));
        }
        return Parameter.from((Object)this.convertValue(value.getValue(), TypeInformation.OBJECT));
    }

    @Nullable
    private Object convertValue(CriteriaDefinition.Comparator comparator, @Nullable Object value, TypeInformation<?> typeHint) {
        Collection collection;
        if ((CriteriaDefinition.Comparator.IN.equals((Object)comparator) || CriteriaDefinition.Comparator.NOT_IN.equals((Object)comparator)) && value instanceof Collection && !(collection = (Collection)value).isEmpty()) {
            ArrayList<Object> mapped = new ArrayList<Object>(collection.size());
            for (Object o : collection) {
                mapped.add(this.convertValue(o, typeHint));
            }
            return mapped;
        }
        return this.convertValue(value, typeHint);
    }

    @Nullable
    protected Object convertValue(@Nullable Object value, TypeInformation<?> typeInformation) {
        if (value == null) {
            return null;
        }
        if (value instanceof Pair) {
            Pair pair = (Pair)value;
            Object first = this.convertValue(pair.getFirst(), typeInformation.getActualType() != null ? typeInformation.getRequiredActualType() : TypeInformation.OBJECT);
            Object second = this.convertValue(pair.getSecond(), typeInformation.getActualType() != null ? typeInformation.getRequiredActualType() : TypeInformation.OBJECT);
            return Pair.of((Object)first, (Object)second);
        }
        return this.converter.writeValue(value, typeInformation);
    }

    protected MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    private Condition createCondition(Column column, @Nullable Object mappedValue, Class<?> valueType, MutableBindings bindings, CriteriaDefinition.Comparator comparator, boolean ignoreCase) {
        if (comparator.equals((Object)CriteriaDefinition.Comparator.IS_NULL)) {
            return column.isNull();
        }
        if (comparator.equals((Object)CriteriaDefinition.Comparator.IS_NOT_NULL)) {
            return column.isNotNull();
        }
        if (comparator == CriteriaDefinition.Comparator.IS_TRUE) {
            Expression bind = this.booleanBind(column, mappedValue, valueType, bindings, ignoreCase);
            return column.isEqualTo(bind);
        }
        if (comparator == CriteriaDefinition.Comparator.IS_FALSE) {
            Expression bind = this.booleanBind(column, mappedValue, valueType, bindings, ignoreCase);
            return column.isEqualTo(bind);
        }
        Column columnExpression = column;
        if (ignoreCase) {
            columnExpression = Functions.upper((Expression)column);
        }
        if (comparator == CriteriaDefinition.Comparator.NOT_IN || comparator == CriteriaDefinition.Comparator.IN) {
            In condition;
            if (mappedValue instanceof Iterable) {
                ArrayList<Expression> expressions = new ArrayList<Expression>(mappedValue instanceof Collection ? ((Collection)mappedValue).size() : 10);
                for (Object o : (Iterable)mappedValue) {
                    BindMarker bindMarker = bindings.nextMarker(column.getName().getReference());
                    expressions.add(this.bind(o, valueType, bindings, bindMarker));
                }
                condition = Conditions.in((Expression)columnExpression, (Expression[])expressions.toArray(new Expression[0]));
            } else {
                BindMarker bindMarker = bindings.nextMarker(column.getName().getReference());
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker);
                condition = Conditions.in((Expression)columnExpression, (Expression)expression);
            }
            if (comparator == CriteriaDefinition.Comparator.NOT_IN) {
                condition = condition.not();
            }
            return condition;
        }
        if (comparator == CriteriaDefinition.Comparator.BETWEEN || comparator == CriteriaDefinition.Comparator.NOT_BETWEEN) {
            Pair pair = (Pair)mappedValue;
            Expression begin = this.bind(pair.getFirst(), valueType, bindings, bindings.nextMarker(column.getName().getReference()), ignoreCase);
            Expression end = this.bind(pair.getSecond(), valueType, bindings, bindings.nextMarker(column.getName().getReference()), ignoreCase);
            return comparator == CriteriaDefinition.Comparator.BETWEEN ? Conditions.between((Expression)columnExpression, (Expression)begin, (Expression)end) : Conditions.notBetween((Expression)columnExpression, (Expression)begin, (Expression)end);
        }
        BindMarker bindMarker = bindings.nextMarker(column.getName().getReference());
        switch (comparator) {
            case EQ: {
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker, ignoreCase);
                return Conditions.isEqual((Expression)columnExpression, (Expression)expression);
            }
            case NEQ: {
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker, ignoreCase);
                return Conditions.isEqual((Expression)columnExpression, (Expression)expression).not();
            }
            case LT: {
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker);
                return column.isLess(expression);
            }
            case LTE: {
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker);
                return column.isLessOrEqualTo(expression);
            }
            case GT: {
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker);
                return column.isGreater(expression);
            }
            case GTE: {
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker);
                return column.isGreaterOrEqualTo(expression);
            }
            case LIKE: {
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker, ignoreCase);
                return Conditions.like((Expression)columnExpression, (Expression)expression);
            }
            case NOT_LIKE: {
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker, ignoreCase);
                return Conditions.notLike((Expression)columnExpression, (Expression)expression);
            }
        }
        throw new UnsupportedOperationException("Comparator " + String.valueOf(comparator) + " not supported");
    }

    Field createPropertyField(@Nullable RelationalPersistentEntity<?> entity, SqlIdentifier key) {
        return entity == null ? new Field(key) : new MetadataBackedField(key, entity, this.mappingContext);
    }

    Field createPropertyField(@Nullable RelationalPersistentEntity<?> entity, SqlIdentifier key, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext) {
        return entity == null ? new Field(key) : new MetadataBackedField(key, entity, mappingContext);
    }

    Class<?> getTypeHint(@Nullable Object mappedValue, Class<?> propertyType) {
        return propertyType;
    }

    Class<?> getTypeHint(@Nullable Object mappedValue, Class<?> propertyType, Parameter parameter) {
        if (mappedValue == null || propertyType.equals(Object.class)) {
            return parameter.getType();
        }
        if (mappedValue.getClass().equals(parameter.getValue().getClass())) {
            return parameter.getType();
        }
        return propertyType;
    }

    private Expression bind(@Nullable Object mappedValue, Class<?> valueType, MutableBindings bindings, BindMarker bindMarker) {
        return this.bind(mappedValue, valueType, bindings, bindMarker, false);
    }

    private Expression bind(@Nullable Object mappedValue, Class<?> valueType, MutableBindings bindings, BindMarker bindMarker, boolean ignoreCase) {
        if (mappedValue != null) {
            bindings.bind(bindMarker, mappedValue);
        } else {
            bindings.bindNull(bindMarker, valueType);
        }
        return ignoreCase ? Functions.upper((Expression)SQL.bindMarker((String)bindMarker.getPlaceholder())) : SQL.bindMarker((String)bindMarker.getPlaceholder());
    }

    private Expression booleanBind(Column column, Object mappedValue, Class<?> valueType, MutableBindings bindings, boolean ignoreCase) {
        BindMarker bindMarker = bindings.nextMarker(column.getName().getReference());
        return this.bind(mappedValue, valueType, bindings, bindMarker, ignoreCase);
    }

    protected static class Field {
        protected final SqlIdentifier name;

        public Field(SqlIdentifier name) {
            Assert.notNull((Object)name, (String)"Name must not be null");
            this.name = name;
        }

        public SqlIdentifier getMappedColumnName() {
            return this.name;
        }

        public TypeInformation<?> getTypeHint() {
            return TypeInformation.OBJECT;
        }
    }

    protected static class MetadataBackedField
    extends Field {
        private final RelationalPersistentEntity<?> entity;
        private final MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
        @Nullable
        private final RelationalPersistentProperty property;
        @Nullable
        private final PersistentPropertyPath<RelationalPersistentProperty> path;

        protected MetadataBackedField(SqlIdentifier name, RelationalPersistentEntity<?> entity, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> context) {
            this(name, entity, context, null);
        }

        protected MetadataBackedField(SqlIdentifier name, RelationalPersistentEntity<?> entity, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> context, @Nullable RelationalPersistentProperty property) {
            super(name);
            Assert.notNull(entity, (String)"RelationalPersistentEntity must not be null");
            this.entity = entity;
            this.mappingContext = context;
            this.path = this.getPath(name.getReference());
            this.property = this.path == null ? property : (RelationalPersistentProperty)this.path.getLeafProperty();
        }

        @Override
        public SqlIdentifier getMappedColumnName() {
            return this.path == null || this.path.getLeafProperty() == null ? super.getMappedColumnName() : ((RelationalPersistentProperty)this.path.getLeafProperty()).getColumnName();
        }

        @Nullable
        private PersistentPropertyPath<RelationalPersistentProperty> getPath(String pathExpression) {
            try {
                PropertyPath path = this.forName(pathExpression);
                if (this.isPathToJavaLangClassProperty(path)) {
                    return null;
                }
                return this.mappingContext.getPersistentPropertyPath(path);
            }
            catch (MappingException | PropertyReferenceException e) {
                return null;
            }
        }

        private PropertyPath forName(String path) {
            if (this.entity.getPersistentProperty(path) != null) {
                return PropertyPath.from((String)Pattern.quote(path), (TypeInformation)this.entity.getTypeInformation());
            }
            return PropertyPath.from((String)path, (TypeInformation)this.entity.getTypeInformation());
        }

        private boolean isPathToJavaLangClassProperty(PropertyPath path) {
            return path.getType().equals(Class.class) && path.getLeafProperty().getOwningType().getType().equals(Class.class);
        }

        @Override
        public TypeInformation<?> getTypeHint() {
            if (this.property == null) {
                return super.getTypeHint();
            }
            if (this.property.getType().isPrimitive()) {
                return TypeInformation.of((Class)ClassUtils.resolvePrimitiveIfNecessary((Class)this.property.getType()));
            }
            if (this.property.getType().isArray()) {
                return this.property.getTypeInformation();
            }
            if (this.property.getType().isInterface() || Modifier.isAbstract(this.property.getType().getModifiers())) {
                return TypeInformation.OBJECT;
            }
            return this.property.getTypeInformation();
        }
    }
}

