/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.r2dbc.UncategorizedR2dbcException;
import org.springframework.data.r2dbc.connectionfactory.ConnectionFactoryUtils;
import org.springframework.data.r2dbc.connectionfactory.ConnectionProxy;
import org.springframework.data.r2dbc.convert.ColumnMapRowMapper;
import org.springframework.data.r2dbc.core.ConnectionAccessor;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.DefaultDatabaseClientBuilder;
import org.springframework.data.r2dbc.core.DefaultSqlResult;
import org.springframework.data.r2dbc.core.ExecuteFunction;
import org.springframework.data.r2dbc.core.FetchSpec;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.SqlProvider;
import org.springframework.data.r2dbc.core.StatementFilterFunction;
import org.springframework.data.r2dbc.core.StatementFilterFunctions;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.r2dbc.core.UpdatedRowsFetchSpec;
import org.springframework.data.r2dbc.dialect.BindTarget;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.query.Update;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
class DefaultDatabaseClient
implements DatabaseClient,
ConnectionAccessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ConnectionFactory connector;
    private final R2dbcExceptionTranslator exceptionTranslator;
    private final ExecuteFunction executeFunction;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final boolean namedParameters;
    private final DefaultDatabaseClientBuilder builder;
    private final ProjectionFactory projectionFactory;

    DefaultDatabaseClient(ConnectionFactory connector, R2dbcExceptionTranslator exceptionTranslator, ExecuteFunction executeFunction, ReactiveDataAccessStrategy dataAccessStrategy, boolean namedParameters, ProjectionFactory projectionFactory, DefaultDatabaseClientBuilder builder) {
        this.connector = connector;
        this.exceptionTranslator = exceptionTranslator;
        this.executeFunction = executeFunction;
        this.dataAccessStrategy = dataAccessStrategy;
        this.namedParameters = namedParameters;
        this.projectionFactory = projectionFactory;
        this.builder = builder;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.connector;
    }

    @Override
    public DatabaseClient.Builder mutate() {
        return this.builder;
    }

    @Override
    public DatabaseClient.SelectFromSpec select() {
        return new DefaultSelectFromSpec();
    }

    @Override
    public DatabaseClient.InsertIntoSpec insert() {
        return new DefaultInsertIntoSpec();
    }

    @Override
    public DatabaseClient.UpdateTableSpec update() {
        return new DefaultUpdateTableSpec();
    }

    @Override
    public DatabaseClient.DeleteFromSpec delete() {
        return new DefaultDeleteFromSpec();
    }

    @Override
    public DatabaseClient.GenericExecuteSpec execute(String sql) {
        Assert.hasText((String)sql, (String)"SQL must not be null or empty!");
        return this.execute(() -> sql);
    }

    @Override
    public DatabaseClient.GenericExecuteSpec execute(Supplier<String> sqlSupplier) {
        Assert.notNull(sqlSupplier, (String)"SQL Supplier must not be null!");
        return this.createGenericExecuteSpec(sqlSupplier);
    }

    @Override
    public <T> Mono<T> inConnection(Function<Connection, Mono<T>> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Mono connectionMono = this.getConnection().map(it -> new ConnectionCloseHolder((Connection)it, this::closeConnection));
        return Mono.usingWhen((Publisher)connectionMono, it -> {
            Connection connectionToUse = this.createConnectionProxy(it.connection);
            return DefaultDatabaseClient.doInConnection(connectionToUse, action);
        }, ConnectionCloseHolder::close, (it, err) -> it.close(), ConnectionCloseHolder::close).onErrorMap(R2dbcException.class, ex -> this.translateException("execute", DefaultDatabaseClient.getSql(action), (R2dbcException)ex));
    }

    @Override
    public <T> Flux<T> inConnectionMany(Function<Connection, Flux<T>> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Mono connectionMono = this.getConnection().map(it -> new ConnectionCloseHolder((Connection)it, this::closeConnection));
        return Flux.usingWhen((Publisher)connectionMono, it -> {
            Connection connectionToUse = this.createConnectionProxy(it.connection);
            return DefaultDatabaseClient.doInConnectionMany(connectionToUse, action);
        }, ConnectionCloseHolder::close, (it, err) -> it.close(), ConnectionCloseHolder::close).onErrorMap(R2dbcException.class, ex -> this.translateException("executeMany", DefaultDatabaseClient.getSql(action), (R2dbcException)ex));
    }

    protected Mono<Connection> getConnection() {
        return ConnectionFactoryUtils.getConnection(this.obtainConnectionFactory());
    }

    protected ReactiveDataAccessStrategy getDataAccessStrategy() {
        return this.dataAccessStrategy;
    }

    protected Publisher<Void> closeConnection(Connection connection) {
        return ConnectionFactoryUtils.currentConnectionFactory(this.obtainConnectionFactory()).then().onErrorResume(Exception.class, e -> Mono.from((Publisher)connection.close()));
    }

    protected ConnectionFactory obtainConnectionFactory() {
        return this.connector;
    }

    protected Connection createConnectionProxy(Connection con) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(con));
    }

    protected DataAccessException translateException(String task, @Nullable String sql, R2dbcException ex) {
        DataAccessException dae = this.exceptionTranslator.translate(task, sql, ex);
        return dae != null ? dae : new UncategorizedR2dbcException(task, sql, ex);
    }

    protected <T> DefaultTypedExecuteSpec<T> createTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, StatementFilterFunction filterFunction, Class<T> typeToRead) {
        return new DefaultTypedExecuteSpec<T>(byIndex, byName, sqlSupplier, filterFunction, typeToRead);
    }

    protected ExecuteSpecSupport createGenericExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, StatementFilterFunction filterFunction) {
        return new DefaultGenericExecuteSpec(byIndex, byName, sqlSupplier, filterFunction);
    }

    protected DefaultGenericExecuteSpec createGenericExecuteSpec(Supplier<String> sqlSupplier) {
        return new DefaultGenericExecuteSpec(sqlSupplier);
    }

    private void bindByName(Statement statement, Map<String, SettableValue> byName) {
        byName.forEach((name, o) -> {
            SettableValue converted = this.dataAccessStrategy.getBindValue((SettableValue)o);
            if (converted.getValue() != null) {
                statement.bind(name, converted.getValue());
            } else {
                statement.bindNull(name, converted.getType());
            }
        });
    }

    private void bindByIndex(Statement statement, Map<Integer, SettableValue> byIndex) {
        byIndex.forEach((i, o) -> {
            SettableValue converted = this.dataAccessStrategy.getBindValue((SettableValue)o);
            if (converted.getValue() != null) {
                statement.bind(i.intValue(), converted.getValue());
            } else {
                statement.bindNull(i.intValue(), converted.getType());
            }
        });
    }

    private <R> FetchSpec<R> exchangeInsert(BiFunction<Row, RowMetadata, R> mappingFunction, PreparedOperation<?> operation) {
        String sql = DefaultDatabaseClient.getRequiredSql(operation);
        Function<Connection, Statement> insertFunction = this.wrapPreparedOperation(sql, operation).andThen(rec$ -> ((Statement)rec$).returnGeneratedValues(new String[0]));
        Function<Connection, Flux<Result>> resultFunction = this.toFunction(sql, StatementFilterFunctions.empty(), insertFunction);
        return new DefaultSqlResult<R>(this, sql, resultFunction, it -> DefaultDatabaseClient.sumRowsUpdated(resultFunction, it), mappingFunction);
    }

    private UpdatedRowsFetchSpec exchangeUpdate(PreparedOperation<?> operation) {
        String sql = DefaultDatabaseClient.getRequiredSql(operation);
        Function<Connection, Statement> executeFunction = this.wrapPreparedOperation(sql, operation);
        Function<Connection, Flux<Result>> resultFunction = this.toFunction(sql, StatementFilterFunctions.empty(), executeFunction);
        return new DefaultSqlResult<RowMetadata>(this, sql, resultFunction, it -> DefaultDatabaseClient.sumRowsUpdated(resultFunction, it), (row, rowMetadata) -> rowMetadata);
    }

    private static Mono<Integer> sumRowsUpdated(Function<Connection, Flux<Result>> resultFunction, Connection it) {
        return resultFunction.apply(it).flatMap(Result::getRowsUpdated).collect(Collectors.summingInt(Integer::intValue));
    }

    private Function<Connection, Statement> wrapPreparedOperation(String sql, PreparedOperation<?> operation) {
        return it -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
            }
            Statement statement = it.createStatement(sql);
            operation.bindTo((org.springframework.r2dbc.core.binding.BindTarget)new StatementWrapper(statement));
            return statement;
        };
    }

    private Function<Connection, Flux<Result>> toFunction(String sql, StatementFilterFunction filterFunction, Function<Connection, Statement> statementFactory) {
        return it -> {
            Flux from = Flux.defer(() -> {
                Statement statement = (Statement)statementFactory.apply((Connection)it);
                return filterFunction.filter(statement, this.executeFunction);
            }).cast(Result.class);
            return from.checkpoint("SQL \"" + sql + "\" [DatabaseClient]");
        };
    }

    private static <T> Flux<T> doInConnectionMany(Connection connection, Function<Connection, Flux<T>> action) {
        try {
            return action.apply(connection);
        }
        catch (R2dbcException e) {
            String sql = DefaultDatabaseClient.getSql(action);
            return Flux.error((Throwable)((Object)new UncategorizedR2dbcException("doInConnectionMany", sql, e)));
        }
    }

    private static <T> Mono<T> doInConnection(Connection connection, Function<Connection, Mono<T>> action) {
        try {
            return action.apply(connection);
        }
        catch (R2dbcException e) {
            String sql = DefaultDatabaseClient.getSql(action);
            return Mono.error((Throwable)((Object)new UncategorizedR2dbcException("doInConnection", sql, e)));
        }
    }

    @Nullable
    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static String getRequiredSql(Supplier<String> sqlSupplier) {
        String sql = sqlSupplier.get();
        Assert.state((boolean)StringUtils.hasText((String)sql), (String)"SQL returned by SQL supplier must not be empty!");
        return sql;
    }

    private static void assertRegularClass(Class<?> table) {
        Assert.notNull(table, (String)"Entity type must not be null");
        Assert.isTrue((!table.isInterface() && !table.isEnum() ? 1 : 0) != 0, () -> String.format("Entity type %s must be a class", table.getName()));
    }

    static class StatementWrapper
    implements BindTarget {
        final Statement statement;

        StatementWrapper(Statement statement) {
            this.statement = statement;
        }

        @Override
        public void bind(String identifier, Object value) {
            this.statement.bind(identifier, value);
        }

        @Override
        public void bind(int index, Object value) {
            this.statement.bind(index, value);
        }

        @Override
        public void bindNull(String identifier, Class<?> type) {
            this.statement.bindNull(identifier, type);
        }

        @Override
        public void bindNull(int index, Class<?> type) {
            this.statement.bindNull(index, type);
        }
    }

    static class ConnectionCloseHolder
    extends AtomicBoolean {
        private static final long serialVersionUID = -8994138383301201380L;
        final Connection connection;
        final Function<Connection, Publisher<Void>> closeFunction;

        ConnectionCloseHolder(Connection connection, Function<Connection, Publisher<Void>> closeFunction) {
            this.connection = connection;
            this.closeFunction = closeFunction;
        }

        Mono<Void> close() {
            return Mono.defer(() -> {
                if (this.compareAndSet(false, true)) {
                    return Mono.from(this.closeFunction.apply(this.connection));
                }
                return Mono.empty();
            });
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("unwrap")) {
                return this.target;
            }
            if (method.getName().equals("close")) {
                return Mono.error((Throwable)new UnsupportedOperationException("Close is not supported!"));
            }
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    class DefaultDeleteSpec<T>
    implements DatabaseClient.DeleteMatchingSpec,
    DatabaseClient.TypedDeleteSpec<T> {
        @Nullable
        private final Class<T> typeToDelete;
        @Nullable
        private final SqlIdentifier table;
        @Nullable
        private final CriteriaDefinition where;

        DefaultDeleteSpec(@Nullable Class<T> typeToDelete, @Nullable SqlIdentifier table, CriteriaDefinition where) {
            this.typeToDelete = typeToDelete;
            this.table = table;
            this.where = where;
        }

        @Override
        public DatabaseClient.DeleteSpec matching(CriteriaDefinition criteria) {
            Assert.notNull((Object)criteria, (String)"Criteria must not be null!");
            return new DefaultDeleteSpec<T>(this.typeToDelete, this.table, criteria);
        }

        @Override
        public DatabaseClient.TypedDeleteSpec<T> table(SqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null!");
            return new DefaultDeleteSpec<T>(this.typeToDelete, tableName, this.where);
        }

        @Override
        public UpdatedRowsFetchSpec fetch() {
            SqlIdentifier table;
            if (StringUtils.isEmpty((Object)this.table)) {
                Assert.state((this.typeToDelete != null ? 1 : 0) != 0, (String)"Type to delete must not be null!");
                table = DefaultDatabaseClient.this.dataAccessStrategy.getTableName(this.typeToDelete);
            } else {
                table = this.table;
            }
            return this.exchange(table);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private UpdatedRowsFetchSpec exchange(SqlIdentifier table) {
            StatementMapper.TypedStatementMapper<T> mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            if (this.typeToDelete != null) {
                mapper = mapper.forType(this.typeToDelete);
            }
            StatementMapper.DeleteSpec delete = mapper.createDelete(table);
            if (this.where != null) {
                delete = delete.withCriteria(this.where);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(delete);
            return DefaultDatabaseClient.this.exchangeUpdate(operation);
        }
    }

    class DefaultDeleteFromSpec
    implements DatabaseClient.DeleteFromSpec {
        DefaultDeleteFromSpec() {
        }

        @Override
        public DefaultDeleteSpec<?> from(SqlIdentifier table) {
            return new DefaultDeleteSpec(null, table, null);
        }

        public <T> DefaultDeleteSpec<T> from(Class<T> table) {
            DefaultDatabaseClient.assertRegularClass(table);
            return new DefaultDeleteSpec<T>(table, null, null);
        }
    }

    class DefaultTypedUpdateSpec<T>
    implements DatabaseClient.TypedUpdateSpec<T>,
    DatabaseClient.UpdateMatchingSpec {
        private final Class<T> typeToUpdate;
        @Nullable
        private final SqlIdentifier table;
        @Nullable
        private final T objectToUpdate;
        @Nullable
        private final CriteriaDefinition where;

        DefaultTypedUpdateSpec(@Nullable Class<T> typeToUpdate, @Nullable SqlIdentifier table, @Nullable T objectToUpdate, CriteriaDefinition where) {
            this.typeToUpdate = typeToUpdate;
            this.table = table;
            this.objectToUpdate = objectToUpdate;
            this.where = where;
        }

        @Override
        public DatabaseClient.UpdateMatchingSpec using(T objectToUpdate) {
            Assert.notNull(objectToUpdate, (String)"Object to update must not be null");
            return new DefaultTypedUpdateSpec<T>(this.typeToUpdate, this.table, objectToUpdate, this.where);
        }

        @Override
        public DatabaseClient.TypedUpdateSpec<T> table(SqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null!");
            return new DefaultTypedUpdateSpec<T>(this.typeToUpdate, tableName, this.objectToUpdate, this.where);
        }

        @Override
        public DatabaseClient.UpdateSpec matching(CriteriaDefinition criteria) {
            Assert.notNull((Object)criteria, (String)"Criteria must not be null!");
            return new DefaultTypedUpdateSpec<T>(this.typeToUpdate, this.table, this.objectToUpdate, criteria);
        }

        @Override
        public UpdatedRowsFetchSpec fetch() {
            SqlIdentifier table = StringUtils.isEmpty((Object)this.table) ? DefaultDatabaseClient.this.dataAccessStrategy.getTableName(this.typeToUpdate) : this.table;
            return this.exchange(table);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private UpdatedRowsFetchSpec exchange(SqlIdentifier table) {
            StatementMapper mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            OutboundRow columns = DefaultDatabaseClient.this.dataAccessStrategy.getOutboundRow(this.objectToUpdate);
            List<SqlIdentifier> ids = DefaultDatabaseClient.this.dataAccessStrategy.getIdentifierColumns(this.typeToUpdate);
            if (ids.isEmpty()) {
                throw new IllegalStateException("No identifier columns in " + this.typeToUpdate.getName() + "!");
            }
            Object id = columns.remove(ids.get(0));
            org.springframework.data.relational.core.query.Update update = null;
            for (SqlIdentifier column : columns.keySet()) {
                if (update == null) {
                    update = org.springframework.data.relational.core.query.Update.update((String)DefaultDatabaseClient.this.dataAccessStrategy.toSql(column), columns.get(column));
                    continue;
                }
                update = update.set(DefaultDatabaseClient.this.dataAccessStrategy.toSql(column), columns.get(column));
            }
            Criteria updateCriteria = Criteria.where((String)DefaultDatabaseClient.this.dataAccessStrategy.toSql(ids.get(0))).is(id);
            if (this.where != null) {
                updateCriteria = updateCriteria.and(this.where);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(mapper.createUpdate(table, update).withCriteria((CriteriaDefinition)updateCriteria));
            return DefaultDatabaseClient.this.exchangeUpdate(operation);
        }
    }

    class DefaultGenericUpdateSpec
    implements DatabaseClient.GenericUpdateSpec,
    DatabaseClient.UpdateMatchingSpec {
        @Nullable
        private final Class<?> typeToUpdate;
        @Nullable
        private final SqlIdentifier table;
        @Nullable
        private final org.springframework.data.relational.core.query.Update assignments;
        @Nullable
        private final CriteriaDefinition where;

        DefaultGenericUpdateSpec(@Nullable Class<?> typeToUpdate, @Nullable SqlIdentifier table, @Nullable org.springframework.data.relational.core.query.Update assignments, CriteriaDefinition where) {
            this.typeToUpdate = typeToUpdate;
            this.table = table;
            this.assignments = assignments;
            this.where = where;
        }

        @Override
        public DatabaseClient.UpdateMatchingSpec using(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null");
            return new DefaultGenericUpdateSpec(this.typeToUpdate, this.table, org.springframework.data.relational.core.query.Update.from(update.getAssignments()), this.where);
        }

        @Override
        public DatabaseClient.UpdateMatchingSpec using(org.springframework.data.relational.core.query.Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null");
            return new DefaultGenericUpdateSpec(this.typeToUpdate, this.table, update, this.where);
        }

        @Override
        public DatabaseClient.UpdateSpec matching(CriteriaDefinition criteria) {
            Assert.notNull((Object)criteria, (String)"Criteria must not be null");
            return new DefaultGenericUpdateSpec(this.typeToUpdate, this.table, this.assignments, criteria);
        }

        @Override
        public UpdatedRowsFetchSpec fetch() {
            SqlIdentifier table;
            if (StringUtils.isEmpty((Object)this.table)) {
                Assert.state((this.typeToUpdate != null ? 1 : 0) != 0, (String)"Type to update must not be null!");
                table = DefaultDatabaseClient.this.dataAccessStrategy.getTableName(this.typeToUpdate);
            } else {
                table = this.table;
            }
            return this.exchange(table);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private UpdatedRowsFetchSpec exchange(SqlIdentifier table) {
            StatementMapper.TypedStatementMapper<?> mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            if (this.typeToUpdate != null) {
                mapper = mapper.forType(this.typeToUpdate);
            }
            Assert.state((this.assignments != null ? 1 : 0) != 0, (String)"Update assignments must not be null!");
            StatementMapper.UpdateSpec update = mapper.createUpdate(table, this.assignments);
            if (this.where != null) {
                update = update.withCriteria(this.where);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(update);
            return DefaultDatabaseClient.this.exchangeUpdate(operation);
        }
    }

    class DefaultUpdateTableSpec
    implements DatabaseClient.UpdateTableSpec {
        DefaultUpdateTableSpec() {
        }

        @Override
        public DatabaseClient.GenericUpdateSpec table(SqlIdentifier table) {
            return new DefaultGenericUpdateSpec(null, table, null, null);
        }

        @Override
        public <T> DatabaseClient.TypedUpdateSpec<T> table(Class<T> table) {
            DefaultDatabaseClient.assertRegularClass(table);
            return new DefaultTypedUpdateSpec<Object>(table, null, null, null);
        }
    }

    class DefaultTypedInsertSpec<T, R>
    implements DatabaseClient.TypedInsertSpec<T>,
    DatabaseClient.InsertSpec<R> {
        private final Class<?> typeToInsert;
        private final SqlIdentifier table;
        private final Publisher<T> objectToInsert;
        private final BiFunction<Row, RowMetadata, R> mappingFunction;

        DefaultTypedInsertSpec(Class<?> typeToInsert, BiFunction<Row, RowMetadata, R> mappingFunction) {
            this.typeToInsert = typeToInsert;
            this.table = DefaultDatabaseClient.this.dataAccessStrategy.getTableName(typeToInsert);
            this.objectToInsert = Mono.empty();
            this.mappingFunction = mappingFunction;
        }

        DefaultTypedInsertSpec(Class<?> typeToInsert, SqlIdentifier table, Publisher<T> objectToInsert, BiFunction<Row, RowMetadata, R> mappingFunction) {
            this.typeToInsert = typeToInsert;
            this.table = table;
            this.objectToInsert = objectToInsert;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public DatabaseClient.TypedInsertSpec<T> table(SqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null!");
            return new DefaultTypedInsertSpec<T, R>(this.typeToInsert, tableName, this.objectToInsert, this.mappingFunction);
        }

        @Override
        public DatabaseClient.InsertSpec using(T objectToInsert) {
            Assert.notNull(objectToInsert, (String)"Object to insert must not be null!");
            return new DefaultTypedInsertSpec<T, R>(this.typeToInsert, this.table, Mono.just(objectToInsert), this.mappingFunction);
        }

        @Override
        public DatabaseClient.InsertSpec using(Publisher<T> objectToInsert) {
            Assert.notNull(objectToInsert, (String)"Publisher to insert must not be null!");
            return new DefaultTypedInsertSpec<T, R>(this.typeToInsert, this.table, objectToInsert, this.mappingFunction);
        }

        @Override
        public <MR> FetchSpec<MR> map(Function<Row, MR> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange((row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        @Override
        public <MR> FetchSpec<MR> map(BiFunction<Row, RowMetadata, MR> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public FetchSpec<R> fetch() {
            return this.exchange(this.mappingFunction);
        }

        @Override
        public Mono<Void> then() {
            return Mono.from(this.objectToInsert).flatMapMany(toInsert -> this.exchange(toInsert, (row, md) -> row).all()).then();
        }

        private <MR> FetchSpec<MR> exchange(final BiFunction<Row, RowMetadata, MR> mappingFunction) {
            return new FetchSpec<MR>(){

                @Override
                public Mono<MR> one() {
                    return Mono.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMap(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).one());
                }

                @Override
                public Mono<MR> first() {
                    return Mono.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMap(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).first());
                }

                @Override
                public Flux<MR> all() {
                    return Flux.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMap(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).all());
                }

                @Override
                public Mono<Integer> rowsUpdated() {
                    return Mono.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMapMany(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).rowsUpdated()).collect(Collectors.summingInt(Integer::intValue));
                }
            };
        }

        private <MR> FetchSpec<MR> exchange(Object toInsert, BiFunction<Row, RowMetadata, MR> mappingFunction) {
            OutboundRow outboundRow = DefaultDatabaseClient.this.dataAccessStrategy.getOutboundRow(toInsert);
            StatementMapper mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            StatementMapper.InsertSpec insert = mapper.createInsert(this.table);
            for (SqlIdentifier column : outboundRow.keySet()) {
                Parameter settableValue = outboundRow.get(column);
                if (!settableValue.hasValue()) continue;
                insert = insert.withColumn(column, settableValue);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(insert);
            return DefaultDatabaseClient.this.exchangeInsert(mappingFunction, operation);
        }
    }

    class DefaultGenericInsertSpec<T>
    implements DatabaseClient.GenericInsertSpec<T> {
        private final SqlIdentifier table;
        private final Map<SqlIdentifier, SettableValue> byName;
        private final BiFunction<Row, RowMetadata, T> mappingFunction;

        DefaultGenericInsertSpec(SqlIdentifier table, Map<SqlIdentifier, SettableValue> byName, BiFunction<Row, RowMetadata, T> mappingFunction) {
            this.table = table;
            this.byName = byName;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public DatabaseClient.GenericInsertSpec<T> value(SqlIdentifier field, Object value) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            LinkedHashMap<SqlIdentifier, SettableValue> byName = new LinkedHashMap<SqlIdentifier, SettableValue>(this.byName);
            if (value instanceof SettableValue) {
                byName.put(field, (SettableValue)value);
            } else {
                byName.put(field, SettableValue.fromOrEmpty(value, value.getClass()));
            }
            return new DefaultGenericInsertSpec<T>(this.table, byName, this.mappingFunction);
        }

        @Override
        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange((row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        @Override
        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public FetchSpec<T> fetch() {
            return this.exchange(this.mappingFunction);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private <R> FetchSpec<R> exchange(BiFunction<Row, RowMetadata, R> mappingFunction) {
            StatementMapper mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            StatementMapper.InsertSpec insert = mapper.createInsert(this.table);
            for (SqlIdentifier column : this.byName.keySet()) {
                insert = insert.withColumn(column, this.byName.get(column));
            }
            PreparedOperation<?> operation = mapper.getMappedObject(insert);
            return DefaultDatabaseClient.this.exchangeInsert(mappingFunction, operation);
        }
    }

    class DefaultInsertIntoSpec
    implements DatabaseClient.InsertIntoSpec {
        DefaultInsertIntoSpec() {
        }

        @Override
        public DatabaseClient.GenericInsertSpec<Map<String, Object>> into(SqlIdentifier table) {
            return new DefaultGenericInsertSpec<Map<String, Object>>(table, Collections.emptyMap(), (BiFunction<Row, RowMetadata, Map<String, Object>>)((Object)ColumnMapRowMapper.INSTANCE));
        }

        @Override
        public <T> DatabaseClient.TypedInsertSpec<T> into(Class<T> table) {
            DefaultDatabaseClient.assertRegularClass(table);
            return new DefaultTypedInsertSpec(table, ColumnMapRowMapper.INSTANCE);
        }
    }

    private class DefaultTypedSelectSpec<T>
    extends DefaultSelectSpecSupport
    implements DatabaseClient.TypedSelectSpec<T> {
        private final Class<T> typeToRead;
        private final BiFunction<Row, RowMetadata, T> mappingFunction;

        DefaultTypedSelectSpec(Class<T> typeToRead) {
            super(DefaultDatabaseClient.this.dataAccessStrategy.getTableName(typeToRead));
            this.typeToRead = typeToRead;
            this.mappingFunction = DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(typeToRead);
        }

        DefaultTypedSelectSpec(SqlIdentifier table, @Nullable List<SqlIdentifier> projectedFields, CriteriaDefinition criteria, Sort sort, Pageable page, Class<T> typeToRead, BiFunction<Row, RowMetadata, T> mappingFunction) {
            super(table, projectedFields, criteria, sort, page);
            this.typeToRead = typeToRead;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public <R> FetchSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            BiFunction<Row, RowMetadata, Object> rowMapper = resultType.isInterface() ? DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(this.typeToRead).andThen(r -> DefaultDatabaseClient.this.projectionFactory.createProjection(resultType, r)) : DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(resultType);
            return this.exchange(rowMapper);
        }

        @Override
        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange((row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        @Override
        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public DefaultTypedSelectSpec<T> project(SqlIdentifier ... selectedFields) {
            return (DefaultTypedSelectSpec)super.project(selectedFields);
        }

        @Override
        public DefaultTypedSelectSpec<T> matching(CriteriaDefinition criteria) {
            return (DefaultTypedSelectSpec)super.where(criteria);
        }

        @Override
        public DefaultTypedSelectSpec<T> orderBy(Sort sort) {
            return (DefaultTypedSelectSpec)super.orderBy(sort);
        }

        @Override
        public DefaultTypedSelectSpec<T> page(Pageable pageable) {
            return (DefaultTypedSelectSpec)super.page(pageable);
        }

        @Override
        public FetchSpec<T> fetch() {
            return this.exchange(this.mappingFunction);
        }

        private <R> FetchSpec<R> exchange(BiFunction<Row, RowMetadata, R> mappingFunction) {
            StatementMapper.TypedStatementMapper<T> mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper().forType(this.typeToRead);
            List<SqlIdentifier> columns = this.projectedFields.isEmpty() ? DefaultDatabaseClient.this.dataAccessStrategy.getAllColumns(this.typeToRead) : this.projectedFields;
            StatementMapper.SelectSpec selectSpec = mapper.createSelect(this.table).withProjection(columns.toArray(new SqlIdentifier[0])).withPage(this.page).withSort(this.sort);
            if (this.criteria != null) {
                selectSpec = selectSpec.withCriteria(this.criteria);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(selectSpec);
            return this.execute(operation, mappingFunction);
        }

        @Override
        protected DefaultTypedSelectSpec<T> createInstance(SqlIdentifier table, List<SqlIdentifier> projectedFields, @Nullable CriteriaDefinition criteria, Sort sort, Pageable page) {
            return new DefaultTypedSelectSpec<T>(table, projectedFields, criteria, sort, page, this.typeToRead, this.mappingFunction);
        }
    }

    private class DefaultGenericSelectSpec
    extends DefaultSelectSpecSupport
    implements DatabaseClient.GenericSelectSpec {
        DefaultGenericSelectSpec(SqlIdentifier table, @Nullable List<SqlIdentifier> projectedFields, CriteriaDefinition criteria, Sort sort, Pageable page) {
            super(table, projectedFields, criteria, sort, page);
        }

        DefaultGenericSelectSpec(SqlIdentifier table) {
            super(table);
        }

        @Override
        public <R> DatabaseClient.TypedSelectSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            BiFunction<Row, RowMetadata, R> rowMapper = resultType.isInterface() ? ColumnMapRowMapper.INSTANCE.andThen(map -> DefaultDatabaseClient.this.projectionFactory.createProjection(resultType, map)) : DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(resultType);
            return new DefaultTypedSelectSpec<R>(this.table, this.projectedFields, this.criteria, this.sort, this.page, resultType, rowMapper);
        }

        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange((row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public DefaultGenericSelectSpec project(SqlIdentifier ... selectedFields) {
            return (DefaultGenericSelectSpec)super.project(selectedFields);
        }

        @Override
        public DefaultGenericSelectSpec matching(CriteriaDefinition criteria) {
            return (DefaultGenericSelectSpec)super.where(criteria);
        }

        @Override
        public DefaultGenericSelectSpec orderBy(Sort sort) {
            return (DefaultGenericSelectSpec)super.orderBy(sort);
        }

        @Override
        public DefaultGenericSelectSpec page(Pageable pageable) {
            return (DefaultGenericSelectSpec)super.page(pageable);
        }

        @Override
        public FetchSpec<Map<String, Object>> fetch() {
            return this.exchange((BiFunction)((Object)ColumnMapRowMapper.INSTANCE));
        }

        private <R> FetchSpec<R> exchange(BiFunction<Row, RowMetadata, R> mappingFunction) {
            StatementMapper mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            StatementMapper.SelectSpec selectSpec = mapper.createSelect(this.table).withProjection(this.projectedFields.toArray(new SqlIdentifier[0])).withSort(this.sort).withPage(this.page);
            if (this.criteria != null) {
                selectSpec = selectSpec.withCriteria(this.criteria);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(selectSpec);
            return this.execute(operation, mappingFunction);
        }

        @Override
        protected DefaultGenericSelectSpec createInstance(SqlIdentifier table, List<SqlIdentifier> projectedFields, @Nullable CriteriaDefinition criteria, Sort sort, Pageable page) {
            return new DefaultGenericSelectSpec(table, projectedFields, criteria, sort, page);
        }
    }

    private abstract class DefaultSelectSpecSupport {
        final SqlIdentifier table;
        final List<SqlIdentifier> projectedFields;
        @Nullable
        final CriteriaDefinition criteria;
        final Sort sort;
        final Pageable page;

        DefaultSelectSpecSupport(SqlIdentifier table) {
            Assert.notNull((Object)table, (String)"Table name must not be null!");
            this.table = table;
            this.projectedFields = Collections.emptyList();
            this.criteria = null;
            this.sort = Sort.unsorted();
            this.page = Pageable.unpaged();
        }

        DefaultSelectSpecSupport(SqlIdentifier table, @Nullable List<SqlIdentifier> projectedFields, CriteriaDefinition criteria, Sort sort, Pageable page) {
            this.table = table;
            this.projectedFields = projectedFields;
            this.criteria = criteria;
            this.sort = sort;
            this.page = page;
        }

        public DefaultSelectSpecSupport project(SqlIdentifier ... selectedFields) {
            Assert.notNull((Object)selectedFields, (String)"Projection fields must not be null!");
            ArrayList<SqlIdentifier> projectedFields = new ArrayList<SqlIdentifier>(this.projectedFields.size() + selectedFields.length);
            projectedFields.addAll(this.projectedFields);
            projectedFields.addAll(Arrays.asList(selectedFields));
            return this.createInstance(this.table, projectedFields, this.criteria, this.sort, this.page);
        }

        public DefaultSelectSpecSupport where(CriteriaDefinition whereCriteria) {
            Assert.notNull((Object)whereCriteria, (String)"Criteria must not be null!");
            return this.createInstance(this.table, this.projectedFields, whereCriteria, this.sort, this.page);
        }

        public DefaultSelectSpecSupport orderBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null!");
            return this.createInstance(this.table, this.projectedFields, this.criteria, sort, this.page);
        }

        public DefaultSelectSpecSupport page(Pageable page) {
            Assert.notNull((Object)page, (String)"Pageable must not be null!");
            return this.createInstance(this.table, this.projectedFields, this.criteria, this.sort, page);
        }

        <R> FetchSpec<R> execute(PreparedOperation<?> preparedOperation, BiFunction<Row, RowMetadata, R> mappingFunction) {
            String sql = DefaultDatabaseClient.getRequiredSql(preparedOperation);
            Function selectFunction = DefaultDatabaseClient.this.wrapPreparedOperation(sql, preparedOperation);
            Function resultFunction = DefaultDatabaseClient.this.toFunction(sql, StatementFilterFunctions.empty(), selectFunction);
            return new DefaultSqlResult<R>(DefaultDatabaseClient.this, sql, resultFunction, it -> Mono.error((Throwable)new UnsupportedOperationException("Not available for SELECT")), mappingFunction);
        }

        protected abstract DefaultSelectSpecSupport createInstance(SqlIdentifier var1, List<SqlIdentifier> var2, @Nullable CriteriaDefinition var3, Sort var4, Pageable var5);
    }

    class DefaultSelectFromSpec
    implements DatabaseClient.SelectFromSpec {
        DefaultSelectFromSpec() {
        }

        @Override
        public DatabaseClient.GenericSelectSpec from(SqlIdentifier table) {
            return new DefaultGenericSelectSpec(table);
        }

        @Override
        public <T> DatabaseClient.TypedSelectSpec<T> from(Class<T> table) {
            DefaultDatabaseClient.assertRegularClass(table);
            return new DefaultTypedSelectSpec<T>(table);
        }
    }

    protected class DefaultTypedExecuteSpec<T>
    extends ExecuteSpecSupport
    implements DatabaseClient.TypedExecuteSpec<T> {
        private final Class<T> typeToRead;
        private final BiFunction<Row, RowMetadata, T> mappingFunction;

        DefaultTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, StatementFilterFunction filterFunction, Class<T> typeToRead) {
            super(byIndex, byName, sqlSupplier, filterFunction);
            this.typeToRead = typeToRead;
            this.mappingFunction = typeToRead.isInterface() ? ColumnMapRowMapper.INSTANCE.andThen(map -> DefaultDatabaseClient.this.projectionFactory.createProjection(typeToRead, map)) : DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(typeToRead);
        }

        @Override
        public <R> DatabaseClient.TypedExecuteSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return DefaultDatabaseClient.this.createTypedExecuteSpec(this.byIndex, this.byName, this.sqlSupplier, this.filterFunction, resultType);
        }

        @Override
        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.sqlSupplier, (row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        @Override
        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.sqlSupplier, mappingFunction);
        }

        @Override
        public FetchSpec<T> fetch() {
            return this.exchange(this.sqlSupplier, this.mappingFunction);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        @Override
        public DefaultTypedExecuteSpec<T> bind(int index, Object value) {
            return (DefaultTypedExecuteSpec)super.bind(index, value);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bindNull(int index, Class<?> type) {
            return (DefaultTypedExecuteSpec)super.bindNull(index, type);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bind(String name, Object value) {
            return (DefaultTypedExecuteSpec)super.bind(name, value);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bindNull(String name, Class<?> type) {
            return (DefaultTypedExecuteSpec)super.bindNull(name, type);
        }

        @Override
        public DefaultTypedExecuteSpec<T> filter(StatementFilterFunction filter) {
            return (DefaultTypedExecuteSpec)super.filter(filter);
        }

        @Override
        protected DefaultTypedExecuteSpec<T> createInstance(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, StatementFilterFunction filterFunction) {
            return DefaultDatabaseClient.this.createTypedExecuteSpec(byIndex, byName, sqlSupplier, filterFunction, this.typeToRead);
        }
    }

    protected class DefaultGenericExecuteSpec
    extends ExecuteSpecSupport
    implements DatabaseClient.GenericExecuteSpec {
        DefaultGenericExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, StatementFilterFunction filterFunction) {
            super(byIndex, byName, sqlSupplier, filterFunction);
        }

        DefaultGenericExecuteSpec(Supplier<String> sqlSupplier) {
            super(sqlSupplier);
        }

        @Override
        public <R> DatabaseClient.TypedExecuteSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return DefaultDatabaseClient.this.createTypedExecuteSpec(this.byIndex, this.byName, this.sqlSupplier, this.filterFunction, resultType);
        }

        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.sqlSupplier, (row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.sqlSupplier, mappingFunction);
        }

        @Override
        public FetchSpec<Map<String, Object>> fetch() {
            return this.exchange(this.sqlSupplier, ColumnMapRowMapper.INSTANCE);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        @Override
        public DefaultGenericExecuteSpec bind(int index, Object value) {
            return (DefaultGenericExecuteSpec)super.bind(index, value);
        }

        @Override
        public DefaultGenericExecuteSpec bindNull(int index, Class<?> type) {
            return (DefaultGenericExecuteSpec)super.bindNull(index, type);
        }

        @Override
        public DefaultGenericExecuteSpec bind(String name, Object value) {
            return (DefaultGenericExecuteSpec)super.bind(name, value);
        }

        @Override
        public DefaultGenericExecuteSpec bindNull(String name, Class<?> type) {
            return (DefaultGenericExecuteSpec)super.bindNull(name, type);
        }

        @Override
        public DefaultGenericExecuteSpec filter(StatementFilterFunction filter) {
            return (DefaultGenericExecuteSpec)super.filter(filter);
        }

        @Override
        protected ExecuteSpecSupport createInstance(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, StatementFilterFunction filterFunction) {
            return DefaultDatabaseClient.this.createGenericExecuteSpec(byIndex, byName, sqlSupplier, filterFunction);
        }
    }

    class ExecuteSpecSupport {
        final Map<Integer, SettableValue> byIndex;
        final Map<String, SettableValue> byName;
        final Supplier<String> sqlSupplier;
        final StatementFilterFunction filterFunction;

        ExecuteSpecSupport(Supplier<String> sqlSupplier) {
            this.byIndex = Collections.emptyMap();
            this.byName = Collections.emptyMap();
            this.sqlSupplier = sqlSupplier;
            this.filterFunction = StatementFilterFunctions.empty();
        }

        ExecuteSpecSupport(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, StatementFilterFunction filterFunction) {
            this.byIndex = byIndex;
            this.byName = byName;
            this.sqlSupplier = sqlSupplier;
            this.filterFunction = filterFunction;
        }

        <T> FetchSpec<T> exchange(Supplier<String> sqlSupplier, BiFunction<Row, RowMetadata, T> mappingFunction) {
            String sql = DefaultDatabaseClient.getRequiredSql(sqlSupplier);
            Function<Connection, Statement> statementFactory = it -> {
                if (DefaultDatabaseClient.this.logger.isDebugEnabled()) {
                    DefaultDatabaseClient.this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
                }
                if (sqlSupplier instanceof PreparedOperation) {
                    Statement statement = it.createStatement(sql);
                    StatementWrapper bindTarget = new StatementWrapper(statement);
                    ((PreparedOperation)sqlSupplier).bindTo((org.springframework.r2dbc.core.binding.BindTarget)bindTarget);
                    return statement;
                }
                if (DefaultDatabaseClient.this.namedParameters) {
                    LinkedHashMap<String, SettableValue> remainderByName = new LinkedHashMap<String, SettableValue>(this.byName);
                    LinkedHashMap<Integer, SettableValue> remainderByIndex = new LinkedHashMap<Integer, SettableValue>(this.byIndex);
                    PreparedOperation<?> operation = DefaultDatabaseClient.this.dataAccessStrategy.processNamedParameters(sql, (index, name) -> {
                        if (this.byName.containsKey(name)) {
                            remainderByName.remove(name);
                            return DefaultDatabaseClient.this.dataAccessStrategy.getBindValue(this.byName.get(name));
                        }
                        if (this.byIndex.containsKey(index)) {
                            remainderByIndex.remove(index);
                            return DefaultDatabaseClient.this.dataAccessStrategy.getBindValue(this.byIndex.get(index));
                        }
                        return null;
                    });
                    String expanded = DefaultDatabaseClient.getRequiredSql(operation);
                    if (DefaultDatabaseClient.this.logger.isTraceEnabled()) {
                        DefaultDatabaseClient.this.logger.trace((Object)("Expanded SQL [" + expanded + "]"));
                    }
                    Statement statement = it.createStatement(expanded);
                    StatementWrapper bindTarget = new StatementWrapper(statement);
                    operation.bindTo((org.springframework.r2dbc.core.binding.BindTarget)bindTarget);
                    DefaultDatabaseClient.this.bindByName(statement, remainderByName);
                    DefaultDatabaseClient.this.bindByIndex(statement, remainderByIndex);
                    return statement;
                }
                Statement statement = it.createStatement(sql);
                DefaultDatabaseClient.this.bindByIndex(statement, this.byIndex);
                DefaultDatabaseClient.this.bindByName(statement, this.byName);
                return statement;
            };
            Function resultFunction = DefaultDatabaseClient.this.toFunction(sql, this.filterFunction, statementFactory);
            return new DefaultSqlResult<T>(DefaultDatabaseClient.this, sql, resultFunction, it -> DefaultDatabaseClient.sumRowsUpdated(resultFunction, it), mappingFunction);
        }

        public ExecuteSpecSupport bind(int index, Object value) {
            this.assertNotPreparedOperation();
            Assert.notNull((Object)value, () -> String.format("Value at index %d must not be null. Use bindNull(\u2026) instead.", index));
            LinkedHashMap<Integer, SettableValue> byIndex = new LinkedHashMap<Integer, SettableValue>(this.byIndex);
            if (value instanceof SettableValue) {
                byIndex.put(index, (SettableValue)value);
            } else {
                byIndex.put(index, SettableValue.fromOrEmpty(value, value.getClass()));
            }
            return this.createInstance(byIndex, this.byName, this.sqlSupplier, this.filterFunction);
        }

        public ExecuteSpecSupport bindNull(int index, Class<?> type) {
            this.assertNotPreparedOperation();
            LinkedHashMap<Integer, SettableValue> byIndex = new LinkedHashMap<Integer, SettableValue>(this.byIndex);
            byIndex.put(index, SettableValue.empty(type));
            return this.createInstance(byIndex, this.byName, this.sqlSupplier, this.filterFunction);
        }

        public ExecuteSpecSupport bind(String name, Object value) {
            this.assertNotPreparedOperation();
            Assert.hasText((String)name, (String)"Parameter name must not be null or empty!");
            Assert.notNull((Object)value, () -> String.format("Value for parameter %s must not be null. Use bindNull(\u2026) instead.", name));
            LinkedHashMap<String, SettableValue> byName = new LinkedHashMap<String, SettableValue>(this.byName);
            if (value instanceof SettableValue) {
                byName.put(name, (SettableValue)value);
            } else {
                byName.put(name, SettableValue.fromOrEmpty(value, value.getClass()));
            }
            return this.createInstance(this.byIndex, byName, this.sqlSupplier, this.filterFunction);
        }

        public ExecuteSpecSupport bindNull(String name, Class<?> type) {
            this.assertNotPreparedOperation();
            Assert.hasText((String)name, (String)"Parameter name must not be null or empty!");
            LinkedHashMap<String, SettableValue> byName = new LinkedHashMap<String, SettableValue>(this.byName);
            byName.put(name, SettableValue.empty(type));
            return this.createInstance(this.byIndex, byName, this.sqlSupplier, this.filterFunction);
        }

        public ExecuteSpecSupport filter(StatementFilterFunction filter) {
            Assert.notNull((Object)filter, (String)"Statement FilterFunction must not be null!");
            return this.createInstance(this.byIndex, this.byName, this.sqlSupplier, this.filterFunction.andThen(filter));
        }

        private void assertNotPreparedOperation() {
            if (this.sqlSupplier instanceof PreparedOperation) {
                throw new InvalidDataAccessApiUsageException("Cannot add bindings to a PreparedOperation");
            }
        }

        protected ExecuteSpecSupport createInstance(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, StatementFilterFunction filterFunction) {
            return new ExecuteSpecSupport(byIndex, byName, sqlSupplier, filterFunction);
        }
    }
}

