/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.DtoInstantiatingConverter;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

interface R2dbcQueryExecution {
    public Publisher<?> execute(RowsFetchSpec<Object> var1);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        private final ResultProcessor processor;
        private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
        private final EntityInstantiators instantiators;
        private final Lazy<DtoInstantiatingConverter> converter;

        ResultProcessingConverter(ResultProcessor processor, MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext, EntityInstantiators instantiators) {
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
            this.converter = Lazy.of(() -> new DtoInstantiatingConverter(processor.getReturnedType().getReturnedType(), this.mappingContext, this.instantiators));
        }

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            if (ReflectionUtils.isVoid((Class)returnedType.getReturnedType())) {
                if (source instanceof Mono) {
                    return ((Mono)source).then();
                }
                if (source instanceof Publisher) {
                    return Flux.from((Publisher)((Publisher)source)).then();
                }
                if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                    return source;
                }
            }
            return this.processor.processResult(source, it -> ((DtoInstantiatingConverter)this.converter.get()).convert(it));
        }
    }

    public static final class ResultProcessingExecution
    implements R2dbcQueryExecution {
        private final R2dbcQueryExecution delegate;
        private final Converter<Object, Object> converter;

        ResultProcessingExecution(R2dbcQueryExecution delegate, Converter<Object, Object> converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        public Publisher<Object> execute(RowsFetchSpec<Object> fetchSpec) {
            return (Publisher)this.converter.convert(this.delegate.execute(fetchSpec));
        }
    }
}

