/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.connectionfactory;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.r2dbc.connectionfactory.ConnectionProxy;
import org.springframework.data.r2dbc.connectionfactory.DelegatingConnectionFactory;
import org.springframework.data.r2dbc.connectionfactory.SmartConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@Deprecated
public class SingleConnectionConnectionFactory
extends DelegatingConnectionFactory
implements SmartConnectionFactory,
DisposableBean {
    private boolean suppressClose;
    @Nullable
    private Boolean autoCommit;
    private final AtomicReference<Connection> target = new AtomicReference();
    @Nullable
    private Connection connection;
    private final Mono<? extends Connection> connectionEmitter;

    public SingleConnectionConnectionFactory(ConnectionFactory targetConnectionFactory) {
        super(targetConnectionFactory);
        this.connectionEmitter = super.create().cache();
    }

    public SingleConnectionConnectionFactory(String url, boolean suppressClose) {
        super(ConnectionFactories.get((String)url));
        this.suppressClose = suppressClose;
        this.connectionEmitter = super.create().cache();
    }

    public SingleConnectionConnectionFactory(final Connection target, final ConnectionFactoryMetadata metadata, boolean suppressClose) {
        super(new ConnectionFactory(){

            public Publisher<? extends Connection> create() {
                return Mono.just((Object)target);
            }

            public ConnectionFactoryMetadata getMetadata() {
                return metadata;
            }
        });
        Assert.notNull((Object)target, (String)"Connection must not be null");
        Assert.notNull((Object)metadata, (String)"ConnectionFactoryMetadata must not be null");
        this.target.set(target);
        this.connectionEmitter = Mono.just((Object)target);
        this.suppressClose = suppressClose;
        this.connection = suppressClose ? this.getCloseSuppressingConnectionProxy(target) : target;
    }

    public void setSuppressClose(boolean suppressClose) {
        this.suppressClose = suppressClose;
    }

    protected boolean isSuppressClose() {
        return this.suppressClose;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Nullable
    protected Boolean getAutoCommitValue() {
        return this.autoCommit;
    }

    @Override
    public Mono<? extends Connection> create() {
        Connection connection = this.target.get();
        return this.connectionEmitter.map(it -> {
            if (connection == null) {
                this.target.compareAndSet(connection, (Connection)it);
                this.connection = this.isSuppressClose() ? this.getCloseSuppressingConnectionProxy((Connection)it) : it;
            }
            return this.connection;
        }).flatMap(this::prepareConnection);
    }

    @Override
    public boolean shouldClose(Connection con) {
        return con != this.connection && con != this.target.get();
    }

    public void destroy() {
        this.resetConnection().block();
    }

    public Mono<Void> resetConnection() {
        Connection connection = this.target.get();
        if (connection == null) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            if (this.target.compareAndSet(connection, null)) {
                this.connection = null;
                return Mono.from((Publisher)connection.close());
            }
            return Mono.empty();
        });
    }

    protected Mono<Connection> prepareConnection(Connection connection) {
        Boolean autoCommit = this.getAutoCommitValue();
        if (autoCommit != null) {
            return Mono.from((Publisher)connection.setAutoCommit(autoCommit.booleanValue())).thenReturn((Object)connection);
        }
        return Mono.just((Object)connection);
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(target));
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("unwrap")) {
                return this.target;
            }
            if (method.getName().equals("close")) {
                return Mono.empty();
            }
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

