/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.convert.RowPropertyAccessor;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.support.ArrayUtils;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MappingR2dbcConverter
extends BasicRelationalConverter
implements R2dbcConverter {
    public MappingR2dbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context) {
        super(context, (CustomConversions)new R2dbcCustomConversions(Collections.emptyList()));
    }

    public MappingR2dbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, CustomConversions conversions) {
        super(context, conversions);
    }

    public <R> R read(Class<R> type, Row row) {
        return this.read(type, row, null);
    }

    @Override
    public <R> R read(Class<R> type, Row row, @Nullable RowMetadata metadata) {
        ClassTypeInformation typeInfo = ClassTypeInformation.from(type);
        Class rawType = typeInfo.getType();
        if (Row.class.isAssignableFrom(rawType)) {
            return type.cast(row);
        }
        if (this.getConversions().hasCustomReadTarget(Row.class, rawType) && this.getConversionService().canConvert(Row.class, rawType)) {
            return (R)this.getConversionService().convert((Object)row, rawType);
        }
        return this.read(this.getRequiredPersistentEntity(type), row, metadata);
    }

    private <R> R read(RelationalPersistentEntity<R> entity, Row row, @Nullable RowMetadata metadata) {
        R result = this.createInstance(row, metadata, "", entity);
        if (entity.requiresPropertyPopulation()) {
            ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(result), this.getConversionService());
            for (RelationalPersistentProperty property : entity) {
                Object value;
                if (entity.isConstructorArgument((PersistentProperty)property) || (value = this.readFrom(row, metadata, property, "")) == null) continue;
                propertyAccessor.setProperty((PersistentProperty)property, value);
            }
        }
        return result;
    }

    @Nullable
    private Object readFrom(Row row, @Nullable RowMetadata metadata, RelationalPersistentProperty property, String prefix) {
        String identifier = prefix + property.getColumnName().getReference();
        try {
            Object value = null;
            if (metadata == null || metadata.getColumnNames().contains(identifier)) {
                value = row.get(identifier);
            }
            if (value == null) {
                return null;
            }
            if (this.getConversions().hasCustomReadTarget(value.getClass(), property.getType())) {
                return this.readValue(value, property.getTypeInformation());
            }
            if (property.isEntity()) {
                return this.readEntityFrom(row, metadata, (PersistentProperty<?>)property);
            }
            return this.readValue(value, property.getTypeInformation());
        }
        catch (Exception o_O) {
            throw new MappingException(String.format("Could not read property %s from column %s!", property, identifier), (Throwable)o_O);
        }
    }

    public Object readValue(@Nullable Object value, TypeInformation<?> type) {
        if (null == value) {
            return null;
        }
        if (this.getConversions().hasCustomReadTarget(value.getClass(), type.getType())) {
            return this.getConversionService().convert(value, type.getType());
        }
        if (value instanceof Collection || value.getClass().isArray()) {
            return this.readCollectionOrArray(MappingR2dbcConverter.asCollection(value), type);
        }
        return this.getPotentiallyConvertedSimpleRead(value, type.getType());
    }

    private Object readCollectionOrArray(Collection<?> source, TypeInformation<?> targetType) {
        Collection<Object> items;
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Class collectionType = targetType.isSubTypeOf(Collection.class) ? targetType.getType() : List.class;
        ClassTypeInformation componentType = targetType.getComponentType() != null ? targetType.getComponentType() : ClassTypeInformation.OBJECT;
        Class rawComponentType = componentType.getType();
        Collection collection = items = targetType.getType().isArray() ? new ArrayList(source.size()) : CollectionFactory.createCollection((Class)collectionType, (Class)rawComponentType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
        }
        for (Object element : source) {
            if (!Object.class.equals((Object)rawComponentType) && element instanceof Collection && !rawComponentType.isArray() && !ClassUtils.isAssignable(Iterable.class, (Class)rawComponentType)) {
                throw new MappingException(String.format("Cannot convert %1$s of type %2$s into an instance of %3$s! Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions", element, element.getClass(), rawComponentType));
            }
            if (element instanceof List) {
                items.add(this.readCollectionOrArray((Collection)element, (TypeInformation<?>)componentType));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(element, rawComponentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (this.getConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.getConversionService().convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.getConversionService().convert(value, target);
    }

    private <S> S readEntityFrom(Row row, @Nullable RowMetadata metadata, PersistentProperty<?> property) {
        String prefix = property.getName() + "_";
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property.getActualType());
        if (entity.hasIdProperty() && this.readFrom(row, metadata, (RelationalPersistentProperty)entity.getRequiredIdProperty(), prefix) == null) {
            return null;
        }
        S instance = this.createInstance(row, metadata, prefix, entity);
        if (entity.requiresPropertyPopulation()) {
            PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
            ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(accessor, this.getConversionService());
            for (RelationalPersistentProperty p : entity) {
                if (entity.isConstructorArgument(property)) continue;
                propertyAccessor.setProperty((PersistentProperty)p, this.readFrom(row, metadata, p, prefix));
            }
        }
        return instance;
    }

    private <S> S createInstance(Row row, @Nullable RowMetadata rowMetadata, String prefix, RelationalPersistentEntity<S> entity) {
        NoOpParameterValueProvider provider;
        PreferredConstructor persistenceConstructor = entity.getPersistenceConstructor();
        if (persistenceConstructor != null && persistenceConstructor.hasParameters()) {
            SpELContext spELContext = new SpELContext((PropertyAccessor)new RowPropertyAccessor(rowMetadata));
            DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator((Object)row, spELContext);
            provider = new SpELExpressionParameterValueProvider((SpELExpressionEvaluator)expressionEvaluator, this.getConversionService(), (ParameterValueProvider)new RowParameterValueProvider(row, rowMetadata, entity, this, prefix));
        } else {
            provider = NoOpParameterValueProvider.INSTANCE;
        }
        return (S)this.createInstance((PersistentEntity)entity, arg_0 -> ((ParameterValueProvider)provider).getParameterValue(arg_0));
    }

    public void write(Object source, OutboundRow sink) {
        Class userClass = ClassUtils.getUserClass((Object)source);
        Optional customTarget = this.getConversions().getCustomWriteTarget(userClass, OutboundRow.class);
        if (customTarget.isPresent()) {
            OutboundRow result = (OutboundRow)this.getConversionService().convert(source, OutboundRow.class);
            sink.putAll(result);
            return;
        }
        this.writeInternal(source, sink, userClass);
    }

    private void writeInternal(Object source, OutboundRow sink, Class<?> userClass) {
        RelationalPersistentEntity<?> entity = this.getRequiredPersistentEntity(userClass);
        PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(source);
        this.writeProperties(sink, entity, propertyAccessor, entity.isNew(source));
    }

    private void writeProperties(OutboundRow sink, RelationalPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, boolean isNew) {
        for (RelationalPersistentProperty property : entity) {
            if (!property.isWritable()) continue;
            Object value = accessor.getProperty((PersistentProperty)property);
            if (value == null) {
                this.writeNullInternal(sink, property);
                continue;
            }
            if (this.getConversions().isSimpleType(value.getClass())) {
                this.writeSimpleInternal(sink, value, isNew, property);
                continue;
            }
            this.writePropertyInternal(sink, value, isNew, property);
        }
    }

    private void writeSimpleInternal(OutboundRow sink, Object value, boolean isNew, RelationalPersistentProperty property) {
        Object result = this.getPotentiallyConvertedSimpleWrite(value);
        sink.put(property.getColumnName(), Parameter.fromOrEmpty((Object)result, this.getPotentiallyConvertedSimpleNullType(property.getType())));
    }

    private void writePropertyInternal(OutboundRow sink, Object value, boolean isNew, RelationalPersistentProperty property) {
        ClassTypeInformation valueType = ClassTypeInformation.from(value.getClass());
        if (valueType.isCollectionLike()) {
            if (valueType.getActualType() != null && valueType.getRequiredActualType().isCollectionLike()) {
                this.writeSimpleInternal(sink, value, isNew, property);
                return;
            }
            List<Object> collectionInternal = this.createCollection(MappingR2dbcConverter.asCollection(value), property);
            sink.put(property.getColumnName(), Parameter.from(collectionInternal));
            return;
        }
        throw new InvalidDataAccessApiUsageException("Nested entities are not supported");
    }

    protected List<Object> createCollection(Collection<?> collection, RelationalPersistentProperty property) {
        return this.writeCollectionInternal(collection, property.getTypeInformation(), new ArrayList());
    }

    private List<Object> writeCollectionInternal(Collection<?> source, @Nullable TypeInformation<?> type, Collection<?> sink) {
        List<Object> collection;
        TypeInformation componentType = null;
        List<Object> list = collection = sink instanceof List ? (List<Object>)sink : new ArrayList(sink);
        if (type != null) {
            componentType = type.getComponentType();
        }
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.getConversions().isSimpleType(elementType)) {
                collection.add(this.getPotentiallyConvertedSimpleWrite(element, componentType != null ? componentType.getType() : Object.class));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                collection.add(this.writeCollectionInternal(MappingR2dbcConverter.asCollection(element), componentType, new ArrayList()));
                continue;
            }
            throw new InvalidDataAccessApiUsageException("Nested entities are not supported");
        }
        return collection;
    }

    private void writeNullInternal(OutboundRow sink, RelationalPersistentProperty property) {
        sink.put(property.getColumnName(), Parameter.empty(this.getPotentiallyConvertedSimpleNullType(property.getType())));
    }

    private Class<?> getPotentiallyConvertedSimpleNullType(Class<?> type) {
        Optional customTarget = this.getConversions().getCustomWriteTarget(type);
        if (customTarget.isPresent()) {
            return (Class)customTarget.get();
        }
        if (type.isEnum()) {
            return String.class;
        }
        return type;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(@Nullable Object value) {
        return this.getPotentiallyConvertedSimpleWrite(value, Object.class);
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(@Nullable Object value, Class<?> typeHint) {
        Optional customTarget;
        if (value == null) {
            return null;
        }
        if (Object.class != typeHint && this.getConversionService().canConvert(value.getClass(), typeHint)) {
            value = this.getConversionService().convert(value, typeHint);
        }
        if ((customTarget = this.getConversions().getCustomWriteTarget(value.getClass())).isPresent()) {
            return this.getConversionService().convert(value, (Class)customTarget.get());
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    @Override
    public Object getArrayValue(ArrayColumns arrayColumns, RelationalPersistentProperty property, Object value) {
        Class actualType = null;
        if (value instanceof Collection) {
            actualType = CollectionUtils.findCommonElementType((Collection)((Collection)value));
        } else if (value.getClass().isArray()) {
            actualType = value.getClass().getComponentType();
        }
        if (actualType == null) {
            actualType = property.getActualType();
        }
        Class targetType = arrayColumns.getArrayType(actualType);
        if (!property.isArray() || !targetType.isAssignableFrom(value.getClass())) {
            int depth = value.getClass().isArray() ? ArrayUtils.getDimensionDepth(value.getClass()) : 1;
            Class<?> targetArrayType = ArrayUtils.getArrayClass(targetType, depth);
            return this.getConversionService().convert(value, targetArrayType);
        }
        return value;
    }

    @Override
    public Class<?> getTargetType(Class<?> valueType) {
        Optional writeTarget = this.getConversions().getCustomWriteTarget(valueType);
        return writeTarget.orElseGet(() -> Enum.class.isAssignableFrom(valueType) ? String.class : valueType);
    }

    @Override
    public boolean isSimpleType(Class<?> type) {
        return this.getConversions().isSimpleType(type);
    }

    @Override
    public <T> BiFunction<Row, RowMetadata, T> populateIdIfNecessary(T object) {
        Assert.notNull(object, (String)"Entity object must not be null!");
        Class userClass = ClassUtils.getUserClass(object);
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(userClass);
        return (row, metadata) -> {
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(object);
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entity.getRequiredIdProperty();
            boolean idPropertyUpdateNeeded = false;
            Object id = propertyAccessor.getProperty((PersistentProperty)idProperty);
            if (idProperty.getType().isPrimitive()) {
                idPropertyUpdateNeeded = id instanceof Number && ((Number)id).longValue() == 0L;
            } else {
                boolean bl = idPropertyUpdateNeeded = id == null;
            }
            if (idPropertyUpdateNeeded) {
                return this.potentiallySetId((Row)row, (RowMetadata)metadata, (PersistentPropertyAccessor<?>)propertyAccessor, idProperty) ? propertyAccessor.getBean() : object;
            }
            return object;
        };
    }

    private boolean potentiallySetId(Row row, RowMetadata metadata, PersistentPropertyAccessor<?> propertyAccessor, RelationalPersistentProperty idProperty) {
        Collection columns = metadata.getColumnNames();
        Object generatedIdValue = null;
        String idColumnName = idProperty.getColumnName().getReference();
        if (columns.contains(idColumnName)) {
            generatedIdValue = row.get(idColumnName);
        } else if (columns.size() == 1) {
            String key = (String)columns.iterator().next();
            generatedIdValue = row.get(key);
        }
        if (generatedIdValue == null) {
            return false;
        }
        ConversionService conversionService = this.getConversionService();
        propertyAccessor.setProperty((PersistentProperty)idProperty, conversionService.convert(generatedIdValue, idProperty.getType()));
        return true;
    }

    private <R> RelationalPersistentEntity<R> getRequiredPersistentEntity(Class<R> type) {
        return (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(type);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    private class RowParameterValueProvider
    implements ParameterValueProvider<RelationalPersistentProperty> {
        private final Row resultSet;
        private final RowMetadata metadata;
        private final RelationalPersistentEntity<?> entity;
        private final RelationalConverter converter;
        private final String prefix;

        public RowParameterValueProvider(Row resultSet, RowMetadata metadata, RelationalPersistentEntity<?> entity, RelationalConverter converter, String prefix) {
            this.resultSet = resultSet;
            this.metadata = metadata;
            this.entity = entity;
            this.converter = converter;
            this.prefix = prefix;
        }

        @Nullable
        public <T> T getParameterValue(PreferredConstructor.Parameter<T, RelationalPersistentProperty> parameter) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)this.entity.getRequiredPersistentProperty(parameter.getName());
            Object value = MappingR2dbcConverter.this.readFrom(this.resultSet, this.metadata, property, this.prefix);
            if (value == null) {
                return null;
            }
            Class type = parameter.getType().getType();
            if (type.isInstance(value)) {
                return type.cast(value);
            }
            try {
                return (T)this.converter.getConversionService().convert(value, type);
            }
            catch (Exception o_O) {
                throw new MappingException(String.format("Couldn't read parameter %s.", parameter.getName()), (Throwable)o_O);
            }
        }
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<RelationalPersistentProperty>
    {
        INSTANCE;


        public <T> T getParameterValue(PreferredConstructor.Parameter<T, RelationalPersistentProperty> parameter) {
            return null;
        }
    }
}

