/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.repository.query.AbstractR2dbcQuery;
import org.springframework.data.r2dbc.repository.query.BindableQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class StringBasedR2dbcQuery
extends AbstractR2dbcQuery {
    private final String sql;
    private final Map<String, Boolean> namedParameters = new ConcurrentHashMap<String, Boolean>();

    public StringBasedR2dbcQuery(R2dbcQueryMethod queryMethod, DatabaseClient databaseClient, R2dbcConverter converter, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, databaseClient, converter, expressionParser, evaluationContextProvider);
    }

    public StringBasedR2dbcQuery(String query, R2dbcQueryMethod method, DatabaseClient databaseClient, R2dbcConverter converter, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, databaseClient, converter);
        Assert.hasText((String)query, (String)"Query must not be empty");
        this.sql = query;
    }

    @Override
    protected BindableQuery createQuery(final RelationalParameterAccessor accessor) {
        return new BindableQuery(){

            @Override
            public <T extends DatabaseClient.BindSpec<T>> T bind(T bindSpec) {
                T bindSpecToUse = bindSpec;
                Parameters bindableParameters = accessor.getBindableParameters();
                int index = 0;
                int bindingIndex = 0;
                for (Object value : accessor.getValues()) {
                    Parameter bindableParameter;
                    Optional name;
                    if (this.isNamedParameter(name = (bindableParameter = bindableParameters.getBindableParameter(index++)).getName())) {
                        if (value == null) {
                            if (!accessor.hasBindableNullValue()) continue;
                            bindSpecToUse = bindSpecToUse.bindNull((String)name.get(), bindableParameter.getType());
                            continue;
                        }
                        bindSpecToUse = bindSpecToUse.bind((String)name.get(), value);
                        continue;
                    }
                    if (value == null) {
                        if (!accessor.hasBindableNullValue()) continue;
                        bindSpecToUse = bindSpecToUse.bindNull(bindingIndex++, bindableParameter.getType());
                        continue;
                    }
                    bindSpecToUse = bindSpecToUse.bind(bindingIndex++, value);
                }
                return bindSpecToUse;
            }

            private boolean isNamedParameter(Optional<String> name) {
                if (!name.isPresent()) {
                    return false;
                }
                return StringBasedR2dbcQuery.this.namedParameters.computeIfAbsent(name.get(), it -> {
                    Pattern namedParameterPattern = Pattern.compile("(\\W)" + Pattern.quote(it) + "(\\W|$)");
                    return namedParameterPattern.matcher(this.get()).find();
                });
            }

            @Override
            public String get() {
                return StringBasedR2dbcQuery.this.sql;
            }
        };
    }
}

