/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.convert;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.value.LossyCoercion;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.ConverterBuilder;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.domain.Vector;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.neo4j.core.convert.TemporalAmountConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class AdditionalTypes {
    static final List<?> CONVERTERS;
    private static final DateTimeFormatter DATE_TIME_FORMATTER;

    private AdditionalTypes() {
    }

    static Value value(Map<?, ?> map) {
        return Values.value(map);
    }

    static Value value(Vector vector) {
        return Values.value((double[])vector.toDoubleArray());
    }

    static TimeZone asTimeZone(Value value) {
        return TimeZone.getTimeZone(value.asString());
    }

    static Value value(TimeZone timeZone) {
        if (timeZone == null) {
            return Values.NULL;
        }
        return Values.value((String)timeZone.getID());
    }

    static ZoneId asZoneId(Value value) {
        return ZoneId.of(value.asString());
    }

    static Value value(ZoneId zoneId) {
        if (zoneId == null) {
            return Values.NULL;
        }
        return Values.value((String)zoneId.getId());
    }

    static UUID asUUID(Value value) {
        return UUID.fromString(value.asString());
    }

    static Value value(UUID uuid) {
        if (uuid == null) {
            return Values.NULL;
        }
        return Values.value((String)uuid.toString());
    }

    static URL asURL(Value value) {
        try {
            return new URL(value.asString());
        }
        catch (MalformedURLException ex) {
            throw new MappingException("Could not create URL from value: " + value.asString(), (Throwable)ex);
        }
    }

    static Value value(URL url) {
        if (url == null) {
            return Values.NULL;
        }
        return Values.value((String)url.toString());
    }

    static URI asURI(Value value) {
        return URI.create(value.asString());
    }

    static Value value(URI uri) {
        if (uri == null) {
            return Values.NULL;
        }
        return Values.value((String)uri.toString());
    }

    static Instant asInstant(Value value) {
        return value.asZonedDateTime().toInstant();
    }

    static Value value(Instant instant) {
        return Values.value((OffsetDateTime)instant.atOffset(ZoneOffset.UTC));
    }

    static BigDecimal asBigDecimal(Value value) {
        return new BigDecimal(value.asString());
    }

    static Value value(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return Values.NULL;
        }
        return Values.value((String)bigDecimal.toString());
    }

    static BigInteger asBigInteger(Value value) {
        return new BigInteger(value.asString());
    }

    static Value value(BigInteger bigInteger) {
        if (bigInteger == null) {
            return Values.NULL;
        }
        return Values.value((String)bigInteger.toString());
    }

    static Byte asByte(Value value) {
        byte[] bytes = value.asByteArray();
        Assert.isTrue((bytes.length == 1 ? 1 : 0) != 0, (String)"Expected a byte array with exactly 1 element");
        return bytes[0];
    }

    static Value value(Byte aByte) {
        if (aByte == null) {
            return Values.NULL;
        }
        return Values.value((Object)new Byte[]{aByte});
    }

    static Character asCharacter(Value value) {
        char[] chars = value.asString().toCharArray();
        Assert.isTrue((chars.length == 1 ? 1 : 0) != 0, (String)"Expected a char array with exactly 1 element");
        return Character.valueOf(chars[0]);
    }

    static Date asDate(Value value) {
        return Date.from(DATE_TIME_FORMATTER.parse((CharSequence)value.asString(), Instant::from));
    }

    static Value value(Date date) {
        if (date == null) {
            return Values.NULL;
        }
        return Values.value((String)DATE_TIME_FORMATTER.format(date.toInstant().atZone(ZoneOffset.UTC.normalized())));
    }

    static Float asFloat(Value value) {
        return Float.valueOf(Float.parseFloat(value.asString()));
    }

    static Value value(Float aFloat) {
        if (aFloat == null) {
            return Values.NULL;
        }
        return Values.value((String)aFloat.toString());
    }

    static @Nullable Locale asLocale(Value value) {
        return StringUtils.parseLocale((String)value.asString());
    }

    static Value value(Locale locale) {
        if (locale == null) {
            return Values.NULL;
        }
        return Values.value((String)locale.toString());
    }

    static Short asShort(Value value) {
        long val = value.asLong();
        if (val > 32767L || val < -32768L) {
            throw new LossyCoercion(value.type().name(), "Java short");
        }
        return (short)val;
    }

    static Value value(Short aShort) {
        if (aShort == null) {
            return Values.NULL;
        }
        return Values.value((long)aShort.longValue());
    }

    static boolean[] asBooleanArray(Value value) {
        boolean[] array = new boolean[value.size()];
        int i2 = 0;
        for (Boolean v : value.values(Value::asBoolean)) {
            array[i2++] = v;
        }
        return array;
    }

    static char[] asCharArray(Value value) {
        char[] array = new char[value.size()];
        int i2 = 0;
        for (Character v : value.values(AdditionalTypes::asCharacter)) {
            array[i2++] = v.charValue();
        }
        return array;
    }

    static String[] asStringArray(Value value) {
        String[] array = new String[value.size()];
        return value.asList(Value::asString).toArray(array);
    }

    static double[] asDoubleArray(Value value) {
        double[] array = new double[value.size()];
        int i2 = 0;
        Iterator iterator = value.values(Value::asDouble).iterator();
        while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            array[i2++] = v;
        }
        return array;
    }

    static float[] asFloatArray(Value value) {
        float[] array = new float[value.size()];
        int i2 = 0;
        Iterator iterator = value.values(AdditionalTypes::asFloat).iterator();
        while (iterator.hasNext()) {
            float v = ((Float)iterator.next()).floatValue();
            array[i2++] = v;
        }
        return array;
    }

    static Value value(float[] aFloatArray) {
        if (aFloatArray == null) {
            return Values.NULL;
        }
        String[] values = new String[aFloatArray.length];
        int i2 = 0;
        for (float v : aFloatArray) {
            values[i2++] = Float.toString(v);
        }
        return Values.value((String[])values);
    }

    static int[] asIntArray(Value value) {
        int[] array = new int[value.size()];
        int i2 = 0;
        Iterator iterator = value.values(Value::asInt).iterator();
        while (iterator.hasNext()) {
            int v = (Integer)iterator.next();
            array[i2++] = v;
        }
        return array;
    }

    static long[] asLongArray(Value value) {
        long[] array = new long[value.size()];
        int i2 = 0;
        Iterator iterator = value.values(Value::asLong).iterator();
        while (iterator.hasNext()) {
            long v = (Long)iterator.next();
            array[i2++] = v;
        }
        return array;
    }

    static short[] asShortArray(Value value) {
        short[] array = new short[value.size()];
        int i2 = 0;
        Iterator iterator = value.values(AdditionalTypes::asShort).iterator();
        while (iterator.hasNext()) {
            short v = (Short)iterator.next();
            array[i2++] = v;
        }
        return array;
    }

    static Vector asVector(Value value) {
        double[] array = AdditionalTypes.asDoubleArray(value);
        return Vector.of((double[])array);
    }

    static Value value(short[] aShortArray) {
        if (aShortArray == null) {
            return Values.NULL;
        }
        long[] values = new long[aShortArray.length];
        int i2 = 0;
        for (short v : aShortArray) {
            values[i2++] = v;
        }
        return Values.value((long[])values);
    }

    static {
        DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        ArrayList<Object> hlp = new ArrayList<Object>();
        hlp.add(ConverterBuilder.reading(Value.class, boolean[].class, AdditionalTypes::asBooleanArray).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Byte.class, AdditionalTypes::asByte).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, Byte.TYPE, AdditionalTypes::asByte).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, Character.class, AdditionalTypes::asCharacter).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Character.TYPE, AdditionalTypes::asCharacter).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, char[].class, AdditionalTypes::asCharArray).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Date.class, AdditionalTypes::asDate).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, double[].class, AdditionalTypes::asDoubleArray).andWriting(Values::value));
        hlp.add(new EnumConverter());
        hlp.add(ConverterBuilder.reading(Value.class, Float.class, AdditionalTypes::asFloat).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, Float.TYPE, AdditionalTypes::asFloat).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, float[].class, AdditionalTypes::asFloatArray).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, Integer.class, Value::asInt).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Integer.TYPE, Value::asInt).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, int[].class, AdditionalTypes::asIntArray).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Locale.class, AdditionalTypes::asLocale).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, long[].class, AdditionalTypes::asLongArray).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Short.class, AdditionalTypes::asShort).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, Short.TYPE, AdditionalTypes::asShort).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, short[].class, AdditionalTypes::asShortArray).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, String[].class, AdditionalTypes::asStringArray).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, BigDecimal.class, AdditionalTypes::asBigDecimal).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, BigInteger.class, AdditionalTypes::asBigInteger).andWriting(AdditionalTypes::value));
        hlp.add(new TemporalAmountConverter());
        hlp.add(ConverterBuilder.reading(Value.class, Instant.class, AdditionalTypes::asInstant).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, UUID.class, AdditionalTypes::asUUID).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, URL.class, AdditionalTypes::asURL).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, URI.class, AdditionalTypes::asURI).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, TimeZone.class, AdditionalTypes::asTimeZone).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, ZoneId.class, AdditionalTypes::asZoneId).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, Entity.class, Value::asEntity));
        hlp.add(ConverterBuilder.reading(Value.class, Node.class, Value::asNode));
        hlp.add(ConverterBuilder.reading(Value.class, Relationship.class, Value::asRelationship));
        hlp.add(ConverterBuilder.reading(Value.class, Map.class, MapAccessor::asMap).andWriting(AdditionalTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, Vector.class, AdditionalTypes::asVector).andWriting(AdditionalTypes::value));
        CONVERTERS = Collections.unmodifiableList(hlp);
    }

    @ReadingConverter
    @WritingConverter
    static final class EnumConverter
    implements GenericConverter {
        private final Set<GenericConverter.ConvertiblePair> convertibleTypes;

        EnumConverter() {
            HashSet<GenericConverter.ConvertiblePair> tmp = new HashSet<GenericConverter.ConvertiblePair>();
            tmp.add(new GenericConverter.ConvertiblePair(Value.class, Enum.class));
            tmp.add(new GenericConverter.ConvertiblePair(Enum.class, Value.class));
            this.convertibleTypes = Collections.unmodifiableSet(tmp);
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return this.convertibleTypes;
        }

        public @Nullable Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return Value.class.isAssignableFrom(targetType.getType()) ? Values.NULL : null;
            }
            if (Value.class.isAssignableFrom(sourceType.getType())) {
                return Enum.valueOf(targetType.getType(), ((Value)source).asString());
            }
            return Values.value((String)((Enum)source).name());
        }
    }

    static final class EnumArrayConverter
    implements GenericConverter,
    ConditionalConverter {
        private final EnumConverter delegate = new EnumConverter();

        EnumArrayConverter() {
        }

        private static boolean describesSupportedEnumVariant(TypeDescriptor typeDescriptor) {
            TypeDescriptor elementTypeDescriptor = typeDescriptor.getElementTypeDescriptor();
            return typeDescriptor.isArray() && elementTypeDescriptor != null && Enum.class.isAssignableFrom(elementTypeDescriptor.getType());
        }

        public @Nullable Set<// Could not load outer class - annotation placement on inner may be incorrect
        GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return null;
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (Value.class.isAssignableFrom(sourceType.getType())) {
                return EnumArrayConverter.describesSupportedEnumVariant(targetType);
            }
            if (Value.class.isAssignableFrom(targetType.getType())) {
                return EnumArrayConverter.describesSupportedEnumVariant(sourceType);
            }
            return false;
        }

        public @Nullable Object convert(@Nullable Object object, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (object == null) {
                return Value.class.isAssignableFrom(targetType.getType()) ? Values.NULL : null;
            }
            if (Value.class.isAssignableFrom(sourceType.getType())) {
                Value source = (Value)object;
                TypeDescriptor elementTypeDescriptor = Objects.requireNonNull(targetType.getElementTypeDescriptor());
                Object[] targetArray = (Object[])Array.newInstance(elementTypeDescriptor.getType(), source.size());
                Arrays.setAll(targetArray, i2 -> this.delegate.convert(source.get(i2), TypeDescriptor.valueOf(Value.class), elementTypeDescriptor));
                return targetArray;
            }
            Enum[] source = (Enum[])object;
            return Values.value((Object)Arrays.stream(source).map(e -> this.delegate.convert(e, Objects.requireNonNull(sourceType.getElementTypeDescriptor()), TypeDescriptor.valueOf(Value.class))).toArray());
        }
    }
}

