/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.convert;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.Point;
import org.springframework.data.convert.ConverterBuilder;

final class CypherTypes {
    static final List<?> CONVERTERS;

    private CypherTypes() {
    }

    static {
        ArrayList<ConverterBuilder.ConverterAware> hlp = new ArrayList<ConverterBuilder.ConverterAware>();
        hlp.add(ConverterBuilder.reading(Value.class, Void.class, v -> null).andWriting(v -> Values.NULL));
        hlp.add(ConverterBuilder.reading(Value.class, Void.TYPE, v -> null).andWriting(v -> Values.NULL));
        hlp.add(ConverterBuilder.reading(Value.class, Boolean.class, Value::asBoolean).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Boolean.TYPE, Value::asBoolean).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Long.class, Value::asLong).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Long.TYPE, Value::asLong).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Double.class, Value::asDouble).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Double.TYPE, Value::asDouble).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, String.class, Value::asString).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, byte[].class, Value::asByteArray).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, LocalDate.class, Value::asLocalDate).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, OffsetTime.class, Value::asOffsetTime).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, OffsetDateTime.class, Value::asOffsetDateTime).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, LocalTime.class, Value::asLocalTime).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, ZonedDateTime.class, Value::asZonedDateTime).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, LocalDateTime.class, Value::asLocalDateTime).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, IsoDuration.class, Value::asIsoDuration).andWriting(Values::value));
        hlp.add(ConverterBuilder.reading(Value.class, Point.class, Value::asPoint).andWriting(Values::value));
        CONVERTERS = Collections.unmodifiableList(hlp);
    }
}

