/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.springframework.core.CollectionFactory;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;

@API(status=API.Status.INTERNAL, since="6.1")
final class RelationshipHandler {
    private static final int DEFAULT_SIZE = 32;
    private final Neo4jPersistentProperty property;
    private final @Nullable Object rawValue;
    private final Cardinality cardinality;
    private final Map<Object, Object> newRelatedObjectsByType;
    private Collection<Object> newRelatedObjects;

    RelationshipHandler(Neo4jPersistentProperty property, @Nullable Object rawValue, Cardinality cardinality, Collection<Object> newRelatedObjects, Map<Object, Object> newRelatedObjectsByType) {
        this.property = property;
        this.rawValue = rawValue;
        this.cardinality = cardinality;
        this.newRelatedObjects = newRelatedObjects;
        this.newRelatedObjectsByType = newRelatedObjectsByType;
    }

    static RelationshipHandler forProperty(Neo4jPersistentProperty property, @Nullable Object rawValue) {
        Cardinality cardinality;
        List<Object> newRelationshipObjectCollection = Collections.emptyList();
        Map newRelationshipObjectCollectionMap = Collections.emptyMap();
        if (property.isCollectionLike()) {
            cardinality = Cardinality.ONE_TO_MANY;
            int size = rawValue != null ? ((Collection)rawValue).size() : 32;
            newRelationshipObjectCollection = CollectionFactory.createCollection((Class)property.getType(), (int)size);
        } else if (property.isDynamicOneToManyAssociation()) {
            cardinality = Cardinality.DYNAMIC_ONE_TO_MANY;
            int size = rawValue != null ? ((Map)rawValue).size() : 32;
            newRelationshipObjectCollectionMap = CollectionFactory.createMap((Class)property.getType(), (int)size);
        } else if (property.isDynamicAssociation()) {
            cardinality = Cardinality.DYNAMIC_ONE_TO_ONE;
            int size = rawValue != null ? ((Map)rawValue).size() : 32;
            newRelationshipObjectCollectionMap = CollectionFactory.createMap((Class)property.getType(), (int)size);
        } else {
            cardinality = Cardinality.ONE_TO_ONE;
        }
        return new RelationshipHandler(property, rawValue, cardinality, newRelationshipObjectCollection, newRelationshipObjectCollectionMap);
    }

    void handle(Object relatedValueToStore, Object newRelatedObject, Object potentiallyRecreatedRelatedObject) {
        if (potentiallyRecreatedRelatedObject != newRelatedObject) {
            if (this.cardinality == Cardinality.ONE_TO_ONE) {
                this.newRelatedObjects = Collections.singletonList(potentiallyRecreatedRelatedObject);
            } else if (this.cardinality == Cardinality.ONE_TO_MANY) {
                this.newRelatedObjects.add(potentiallyRecreatedRelatedObject);
            } else {
                Object key = ((Map.Entry)relatedValueToStore).getKey();
                if (this.cardinality == Cardinality.DYNAMIC_ONE_TO_ONE) {
                    this.newRelatedObjectsByType.put(key, potentiallyRecreatedRelatedObject);
                } else {
                    Collection newCollection = (Collection)this.newRelatedObjectsByType.computeIfAbsent(key, k -> {
                        Collection objects = this.rawValue != null ? (Collection)((Map)this.rawValue).get(key) : null;
                        return CollectionFactory.createCollection((Class)this.property.getTypeInformation().getRequiredActualType().getType(), (int)(objects != null ? objects.size() : 32));
                    });
                    newCollection.add(potentiallyRecreatedRelatedObject);
                }
            }
        }
    }

    void applyFinalResultToOwner(PersistentPropertyAccessor<?> parentPropertyAccessor) {
        Object finalRelation = null;
        switch (this.cardinality.ordinal()) {
            case 0: {
                finalRelation = Optional.ofNullable(this.newRelatedObjects).flatMap(v -> v.stream().findFirst()).orElse(null);
                break;
            }
            case 1: {
                if (this.newRelatedObjects.isEmpty()) break;
                finalRelation = this.newRelatedObjects;
                break;
            }
            case 2: 
            case 3: {
                if (this.newRelatedObjectsByType.isEmpty()) break;
                finalRelation = this.newRelatedObjectsByType;
            }
        }
        if (finalRelation != null) {
            parentPropertyAccessor.setProperty((PersistentProperty)this.property, finalRelation);
        }
    }

    static enum Cardinality {
        ONE_TO_ONE,
        ONE_TO_MANY,
        DYNAMIC_ONE_TO_ONE,
        DYNAMIC_ONE_TO_MANY;

    }
}

