/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.support;

import java.util.Date;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;

final class DateLongConverter
implements Neo4jPersistentPropertyConverter<Date> {
    DateLongConverter() {
    }

    @Override
    public Value write(@Nullable Date source) {
        return source != null ? Values.value((long)source.getTime()) : Values.NULL;
    }

    @Override
    public @Nullable Date read(@Nullable Value source) {
        return source != null && !TypeSystem.getDefault().NULL().isTypeOf(source) ? new Date(source.asLong()) : null;
    }
}

