/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

final class Neo4jRepositoryFactorySupport {
    private Neo4jRepositoryFactorySupport() {
    }

    static void assertIdentifierType(Class<?> repositoryIdType, Class<?> entityIdType) {
        if (repositoryIdType.equals(entityIdType) || Neo4jRepositoryFactorySupport.isCompatibleType(repositoryIdType, entityIdType)) {
            return;
        }
        String errorMessage = String.format("The repository id type %s differs from the entity id type %s", repositoryIdType, entityIdType);
        throw new IllegalArgumentException(errorMessage);
    }

    private static boolean isCompatibleType(Class<?> repositoryIdType, Class<?> entityIdType) {
        return Neo4jRepositoryFactorySupport.isCompatibleLongType(repositoryIdType, entityIdType) || Neo4jRepositoryFactorySupport.isCompatibleIntegerType(repositoryIdType, entityIdType);
    }

    private static boolean isCompatibleLongType(Class<?> repositoryIdType, Class<?> entityIdType) {
        return repositoryIdType.equals(Long.class) && entityIdType.equals(Long.TYPE) || repositoryIdType.equals(Long.TYPE) && entityIdType.equals(Long.class);
    }

    private static boolean isCompatibleIntegerType(Class<?> repositoryIdType, Class<?> entityIdType) {
        return repositoryIdType.equals(Integer.class) && entityIdType.equals(Integer.TYPE) || repositoryIdType.equals(Integer.TYPE) && entityIdType.equals(Integer.class);
    }
}

