/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.support;

import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Driver;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;

public enum UserAgent {
    INSTANCE(UserAgent.getVersionOf(Driver.class), UserAgent.getVersionOf(AbstractMappingContext.class), UserAgent.getVersionOf(EnableNeo4jRepositories.class));

    private final @Nullable String driverVersion;
    private final @Nullable String springDataVersion;
    private final @Nullable String sdnVersion;
    private final String representation;

    private UserAgent(@Nullable String driverVersion, String springDataVersion, String sdnVersion) {
        int idxOfDash;
        int n2 = idxOfDash = driverVersion != null ? driverVersion.indexOf(45) : -1;
        this.driverVersion = driverVersion != null ? driverVersion.substring(0, idxOfDash > 0 ? idxOfDash : driverVersion.length()) : null;
        this.springDataVersion = springDataVersion;
        this.sdnVersion = sdnVersion;
        String unknown = "-";
        this.representation = String.format("Java/%s (%s %s %s) neo4j-java/%s spring-data/%s spring-data-neo4j/%s", System.getProperty("java.version"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), this.driverVersion != null ? this.driverVersion : unknown, this.springDataVersion != null ? this.springDataVersion : unknown, this.sdnVersion != null ? this.sdnVersion : unknown);
    }

    private static @Nullable String getVersionOf(Class<?> type) {
        Package p = type.getPackage();
        String version = p.getImplementationVersion();
        if (version != null && !version.trim().isEmpty()) {
            return version;
        }
        return null;
    }

    public @Nullable String getDriverVersion() {
        return this.driverVersion;
    }

    public @Nullable String getSpringDataVersion() {
        return this.springDataVersion;
    }

    public @Nullable String getSdnVersion() {
        return this.sdnVersion;
    }

    public String toString() {
        return this.representation;
    }
}

